/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSdkCredentialsHolder;
import com.jetbrains.python.remote.PythonSshInterpreterManager;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteSdkAdditionalData
extends PythonSdkAdditionalData
implements PyRemoteSdkAdditionalDataBase {
    private static final String PYCHARM_HELPERS = ".pycharm_helpers";
    private static final String SKELETONS_PATH = "SKELETONS_PATH";
    private static final String VERSION = "VERSION";
    private static final String RUN_AS_ROOT_VIA_SUDO = "RUN_AS_ROOT_VIA_SUDO";
    private final RemoteConnectionCredentialsWrapper myRemoteConnectionCredentialsWrapper = new RemoteConnectionCredentialsWrapper();
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties = new RemoteSdkPropertiesHolder(".pycharm_helpers");
    private String mySkeletonsPath;
    private String myVersionString;

    public PyRemoteSdkAdditionalData(String interpreterPath) {
        this(interpreterPath, false);
    }

    public PyRemoteSdkAdditionalData(String interpreterPath, boolean runAsRootViaSudo) {
        super(PyRemoteSdkAdditionalData.computeFlavor(interpreterPath));
        this.setInterpreterPath(interpreterPath);
        this.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    private RemoteSdkCredentialsProducer<PyRemoteSdkCredentials> getProducer() {
        PythonSshInterpreterManager manager = PythonSshInterpreterManager.Factory.getInstance();
        if (manager != null) {
            return manager.getRemoteSdkCredentialsProducer((Function<RemoteCredentials, PyRemoteSdkCredentials>)((Function)credentials -> this.createPyRemoteSdkCredentials((RemoteCredentials)credentials)), this.myRemoteConnectionCredentialsWrapper);
        }
        throw new IllegalStateException("No plugin");
    }

    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        return this.myRemoteConnectionCredentialsWrapper;
    }

    @Nullable
    private static PythonSdkFlavor computeFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor flavor : PyRemoteSdkAdditionalData.getApplicableFlavors(sdkPath.contains("\\"))) {
            if (!flavor.isValidSdkPath(new File(sdkPath))) continue;
            return flavor;
        }
        return null;
    }

    private static List<PythonSdkFlavor> getApplicableFlavors(boolean isWindows) {
        ArrayList<PythonSdkFlavor> result = new ArrayList<PythonSdkFlavor>();
        if (isWindows) {
            result.add(WinPythonSdkFlavor.getInstance());
        } else {
            result.add(UnixPythonSdkFlavor.getInstance());
        }
        result.addAll(PythonSdkFlavor.getPlatformIndependentFlavors());
        return result;
    }

    public String getSkeletonsPath() {
        return this.mySkeletonsPath;
    }

    public void setSkeletonsPath(String path) {
        this.mySkeletonsPath = path;
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myRemoteConnectionCredentialsWrapper.setCredentials(key, credentials);
    }

    public CredentialsType getRemoteConnectionType() {
        return this.myRemoteConnectionCredentialsWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases) {
        this.myRemoteConnectionCredentialsWrapper.switchType(cases);
    }

    private PyRemoteSdkCredentials createPyRemoteSdkCredentials(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(0);
        }
        PyRemoteSdkCredentialsHolder res = new PyRemoteSdkCredentialsHolder();
        RemoteSdkCredentialsBuilder.copyCredentials((RemoteCredentials)credentials, (MutableRemoteCredentials)res);
        this.myRemoteSdkProperties.copyTo((RemoteSdkProperties)res);
        res.setSkeletonsPath(this.getSkeletonsPath());
        res.setInitialized(this.isInitialized());
        res.setValid(this.isValid());
        res.setSdkId(this.getSdkId());
        return res;
    }

    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    public boolean isRunAsRootViaSudo() {
        return this.myRemoteSdkProperties.isRunAsRootViaSudo();
    }

    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRemoteSdkProperties.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myRemoteSdkProperties.getPathMappings();
        if (pathMappingSettings == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return pathMappingSettings;
    }

    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myRemoteSdkProperties.setPathMappings(pathMappings);
    }

    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    public void setSdkId(String sdkId) {
        throw new IllegalStateException("sdkId in this class is constructed based on fields, so it can't be set");
    }

    public String getSdkId() {
        return PyRemoteSdkAdditionalData.constructSdkID(this.myRemoteConnectionCredentialsWrapper, this.myRemoteSdkProperties);
    }

    public String getPresentableDetails() {
        return this.myRemoteConnectionCredentialsWrapper.getPresentableDetails(this.myRemoteSdkProperties.getInterpreterPath());
    }

    private static String constructSdkID(@NotNull RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper, @NotNull RemoteSdkPropertiesHolder properties) {
        if (remoteConnectionCredentialsWrapper == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(3);
        }
        return remoteConnectionCredentialsWrapper.getId() + properties.getInterpreterPath();
    }

    public boolean isInitialized() {
        return this.myRemoteSdkProperties.isInitialized();
    }

    public void setInitialized(boolean initialized) {
        this.myRemoteSdkProperties.setInitialized(initialized);
    }

    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    public void setValid(boolean valid) {
        this.myRemoteSdkProperties.setValid(valid);
    }

    @Deprecated
    public PyRemoteSdkCredentials getRemoteSdkCredentials() throws InterruptedException, ExecutionException {
        return (PyRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials();
    }

    public PyRemoteSdkCredentials getRemoteSdkCredentials(boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return (PyRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials(allowSynchronousInteraction);
    }

    public PyRemoteSdkCredentials getRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return (PyRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials(allowSynchronousInteraction);
    }

    public boolean connectionEquals(PyRemoteSdkAdditionalData data) {
        return this.myRemoteConnectionCredentialsWrapper.equals((Object)data.myRemoteConnectionCredentialsWrapper);
    }

    public Object getRemoteSdkDataKey() {
        return this.myRemoteConnectionCredentialsWrapper.getConnectionKey();
    }

    public void produceRemoteSdkCredentials(@NotNull Consumer<PyRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(4);
        }
        this.getProducer().produceRemoteSdkCredentials(remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(boolean allowSynchronousInteraction, @NotNull Consumer<PyRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(5);
        }
        this.getProducer().produceRemoteSdkCredentials(allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction, @NotNull Consumer<PyRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(6);
        }
        this.getProducer().produceRemoteSdkCredentials(allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    @Override
    @NotNull
    public PyRemoteSdkAdditionalData copy() {
        PyRemoteSdkAdditionalData copy = new PyRemoteSdkAdditionalData(this.myRemoteSdkProperties.getInterpreterPath(), this.isRunAsRootViaSudo());
        this.copyTo(copy);
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = copy;
        if (pyRemoteSdkAdditionalData == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(7);
        }
        return pyRemoteSdkAdditionalData;
    }

    public void copyTo(@NotNull PyRemoteSdkAdditionalData copy) {
        if (copy == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(8);
        }
        copy.setSkeletonsPath(this.mySkeletonsPath);
        copy.setVersionString(this.myVersionString);
        this.myRemoteSdkProperties.copyTo((RemoteSdkProperties)copy.myRemoteSdkProperties);
        this.myRemoteConnectionCredentialsWrapper.copyTo(copy.myRemoteConnectionCredentialsWrapper);
    }

    @Override
    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(9);
        }
        super.save(rootElement);
        this.myRemoteSdkProperties.save(rootElement);
        rootElement.setAttribute(SKELETONS_PATH, StringUtil.notNullize((String)this.getSkeletonsPath()));
        rootElement.setAttribute(VERSION, StringUtil.notNullize((String)this.getVersionString()));
        rootElement.setAttribute(RUN_AS_ROOT_VIA_SUDO, Boolean.toString(this.isRunAsRootViaSudo()));
        this.myRemoteConnectionCredentialsWrapper.save(rootElement);
    }

    @NotNull
    public static PyRemoteSdkAdditionalData loadRemote(@NotNull Sdk sdk, @Nullable Element element) {
        if (sdk == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(10);
        }
        String path = sdk.getHomePath();
        assert (path != null);
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(RemoteSdkCredentialsHolder.getInterpreterPathFromFullPath((String)path), false);
        data.load(element);
        if (element != null) {
            CredentialsManager.getInstance().loadCredentials(path, element, (RemoteSdkAdditionalData)data);
            if (data.myRemoteConnectionCredentialsWrapper.getRemoteConnectionType().hasPrefix("ssh://")) {
                CredentialsManager.updateOutdatedSdk((RemoteSdkAdditionalData)data, null);
            }
            data.myRemoteSdkProperties.load(element);
            data.setSkeletonsPath(StringUtil.nullize((String)element.getAttributeValue(SKELETONS_PATH)));
            String helpersPath = StringUtil.nullize((String)element.getAttributeValue("PYCHARM_HELPERS_PATH"));
            if (helpersPath != null) {
                data.setHelpersPath(helpersPath);
            }
            data.setVersionString(StringUtil.nullize((String)element.getAttributeValue(VERSION)));
            data.setRunAsRootViaSudo(StringUtil.equals((CharSequence)element.getAttributeValue(RUN_AS_ROOT_VIA_SUDO), (CharSequence)"true"));
        }
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = data;
        if (pyRemoteSdkAdditionalData == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(11);
        }
        return pyRemoteSdkAdditionalData;
    }

    @Override
    public void setVersionString(String versionString) {
        this.myVersionString = versionString;
    }

    @Override
    public String getVersionString() {
        return this.myVersionString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteConnectionCredentialsWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkCredentialsConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPyRemoteSdkCredentials";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "constructSdkID";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteSdkCredentials";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

