/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteProcess;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteProcessHandlerUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J=\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/remote/console/PythonConsoleSshProcessCreatorBase;", "T", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "(Lcom/intellij/remote/CredentialsType;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/python/remote/PyRemotePathMapper;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;Ljava/lang/String;Ljava/lang/Object;)Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "intellij.python.remoteInterpreter"})
public abstract class PythonConsoleSshProcessCreatorBase<T>
implements PythonConsoleRemoteProcessCreator<T> {
    private final Logger LOG;
    @NotNull
    private final CredentialsType<T> credentialsType;

    @Override
    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, T credentials) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        int scriptPort = NetUtils.findAvailableSocketPort();
        PydevConsoleCli.setupPythonConsoleScriptInServerMode$default(commandLine, (SdkAdditionalData)data, null, 2, null);
        try {
            PyRemoteProcessHandlerUtil.SshExecProcessWithHandler sshExecProcessWithHandler = PyRemoteProcessHandlerUtil.startRemoteProcess(project, commandLine, data, pathMapper);
            Intrinsics.checkExpressionValueIsNotNull((Object)sshExecProcessWithHandler, (String)"PyRemoteProcessHandlerUt\u2026ndLine, data, pathMapper)");
            PyRemoteProcessHandlerUtil.SshExecProcessWithHandler result = sshExecProcessWithHandler;
            PyRemoteProcessHandler pyRemoteProcessHandler = result.getHandler();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteProcessHandler, (String)"result.handler");
            PyRemoteProcessHandler processHandler2 = pyRemoteProcessHandler;
            SshExecProcess sshExecProcess = result.getProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)sshExecProcess, (String)"result.process");
            SshExecProcess remoteProcess = sshExecProcess;
            PydevConsoleCommunicationClient remoteConsoleCommunication = null;
            int remoteScriptPort = PydevConsoleRunnerImpl.getRemotePortFromProcess((Process)remoteProcess);
            remoteProcess.addLocalTunnel(scriptPort, "localhost", remoteScriptPort);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Using tunneled communication for Python console:" + " port " + scriptPort + " (=> " + remoteScriptPort + ") on pydevconsole.py side");
            }
            remoteConsoleCommunication = new PydevConsoleCommunicationClient(project, "localhost", scriptPort, (Process)remoteProcess);
            remoteConsoleCommunication.connect();
            ProcessHandler processHandler3 = (ProcessHandler)processHandler2;
            PydevConsoleCommunication pydevConsoleCommunication = remoteConsoleCommunication;
            String string = processHandler2.getCommandLine();
            RemoteProcess remoteProcess2 = (RemoteProcess)processHandler2.getProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)remoteProcess2, (String)"processHandler.process");
            Process process2 = (Process)remoteProcess2;
            PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = processHandler2.getRemoteSocketToLocalHostProvider();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteSocketToLocalHostProvider, (String)"processHandler.remoteSocketToLocalHostProvider");
            return new RemoteConsoleProcessData(processHandler3, pydevConsoleCommunication, string, process2, pyRemoteSocketToLocalHostProvider);
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public CredentialsType<T> getCredentialsType() {
        return this.credentialsType;
    }

    public PythonConsoleSshProcessCreatorBase(@NotNull CredentialsType<T> credentialsType) {
        Intrinsics.checkParameterIsNotNull(credentialsType, (String)"credentialsType");
        this.credentialsType = credentialsType;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
    }
}

