/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.SshConfigCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ui.RemoteSdkUpdatedCallback;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.sdk.add.RemoteSdkCreationUtilKt;
import com.jetbrains.python.remote.sdk.add.SshSdkCreationUtilKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FileSystemException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001aH\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001aH\u0010\u0011\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0013\u001a*\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0010\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0000\u001a\u0018\u0010!\u001a\u00020\"2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020$\u001a\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\tH\u0002\u001a \u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u001fH\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"NOT_EMPTY_URL", "", "createSdkFromExistingServerConfiguration", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "existingWebServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "existingSdks", "", "interpreterPath", "runAsRootViaSudo", "", "createSdkFromNewServerConfiguration", "newSshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "newWebServerConfig", "createSftpWebServerConfig", "sshUiData", "createSshUiData", "remoteCredentials", "Lcom/jetbrains/plugins/webDeployment/config/RemoteCredentialsVerifiableHolder;", "isProjectLevel", "credentials", "Lcom/intellij/credentialStore/Credentials;", "saveCredentialsInPermanentStore", "getRemoteCredentialsWithAuth", "Lcom/intellij/remote/RemoteCredentials;", "uiData", "initializeHelpersPath", "", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "setSshConfigCredentials", "sshConfig", "setWebDeploymentCredentials", "webServerConfig", "intellij.python.remoteInterpreter"})
public final class SshSdkCreationUtilKt {
    @NonNls
    private static final String NOT_EMPTY_URL = "http:///";

    @NotNull
    public static final Sdk createSdkFromExistingServerConfiguration(@Nullable Project project, @Nullable Module module, @NotNull SshConfig existingSshConfig, @NotNull WebServerConfig existingWebServerConfig, @NotNull List<? extends Sdk> existingSdks, @NotNull String interpreterPath, boolean runAsRootViaSudo) {
        Intrinsics.checkParameterIsNotNull((Object)existingSshConfig, (String)"existingSshConfig");
        Intrinsics.checkParameterIsNotNull((Object)existingWebServerConfig, (String)"existingWebServerConfig");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)interpreterPath, (String)"interpreterPath");
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(interpreterPath, runAsRootViaSudo);
        SshSdkCreationUtilKt.setWebDeploymentCredentials(data, existingWebServerConfig, (RemoteCredentials)new SshUiData(existingSshConfig));
        SshSdkCreationUtilKt.initializeHelpersPath(project, data);
        Sdk sdk = RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(project, data, existingSdks, null, 8, null);
        if (existingSshConfig.isProjectLevel()) {
            PySdkExtKt.associateWithModule(sdk, module, null);
        }
        return sdk;
    }

    @NotNull
    public static final Sdk createSdkFromNewServerConfiguration(@Nullable Project project, @Nullable Module module, @NotNull SshUiData newSshUiData, @NotNull WebServerConfig newWebServerConfig, @NotNull List<? extends Sdk> existingSdks, @NotNull String interpreterPath, boolean runAsRootViaSudo) {
        Intrinsics.checkParameterIsNotNull((Object)newSshUiData, (String)"newSshUiData");
        Intrinsics.checkParameterIsNotNull((Object)newWebServerConfig, (String)"newWebServerConfig");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)interpreterPath, (String)"interpreterPath");
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(interpreterPath, runAsRootViaSudo);
        SshConfig sshConfig = newSshUiData.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)sshConfig, (String)"newSshUiData.config");
        SshSdkCreationUtilKt.setSshConfigCredentials(data, sshConfig);
        SshSdkCreationUtilKt.setWebDeploymentCredentials(data, newWebServerConfig, (RemoteCredentials)newSshUiData);
        SshConfigManager.getInstance((Project)project).addDataConfig(newSshUiData);
        SshSdkCreationUtilKt.setWebDeploymentCredentials(data, newWebServerConfig, (RemoteCredentials)newSshUiData);
        GroupedServersConfigManager.getInstance((Project)project).addServer(newWebServerConfig);
        SshSdkCreationUtilKt.initializeHelpersPath(project, data);
        Sdk sdk = RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(project, data, existingSdks, null, 8, null);
        SshConfig sshConfig2 = newSshUiData.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)sshConfig2, (String)"newSshUiData.config");
        if (sshConfig2.isProjectLevel()) {
            PySdkExtKt.associateWithModule(sdk, module, null);
        }
        return sdk;
    }

    private static final void setSshConfigCredentials(PyRemoteSdkAdditionalData data, SshConfig sshConfig) {
        SshConfigCredentialsHolder sshConfigCredentialsHolder = new SshConfigCredentialsHolder(sshConfig.createPresentableId());
        SshConfigCredentialsType sshConfigCredentialsType = SshConfigCredentialsType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)sshConfigCredentialsType, (String)"SshConfigCredentialsType.getInstance()");
        data.setCredentials(sshConfigCredentialsType.getCredentialsKey(), sshConfigCredentialsHolder);
    }

    private static final void setWebDeploymentCredentials(PyRemoteSdkAdditionalData data, WebServerConfig webServerConfig, RemoteCredentials remoteCredentials) {
        String string = webServerConfig.getId();
        if (string == null) {
            throw (Throwable)new IllegalStateException();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"webServerConfig.id ?: th\u2026w IllegalStateException()");
        String webServerConfigId = string;
        WebDeploymentCredentialsHolder webDeploymentCredentialsHolder = new WebDeploymentCredentialsHolder(webServerConfigId, webServerConfig.getName(), remoteCredentials);
        data.setCredentials(WebDeploymentCredentialsType.Companion.getInstance().getCredentialsKey(), webDeploymentCredentialsHolder);
    }

    public static final void initializeHelpersPath(@Nullable Project project, @NotNull PyRemoteSdkAdditionalData data) throws FileSystemException, RemoteCancelledException {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        PyRemoteSdkCredentials remoteSdkCredentials = data.getRemoteSdkCredentials(project, true);
        RemoteSdkUpdatedCallback callback2 = initializeHelpersPath.callback.1.INSTANCE;
        RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteSdkCredentials)remoteSdkCredentials, (String)"Creating Helpers Directory", (RemoteSdkUpdatedCallback)callback2);
        PyRemoteSdkCredentials pyRemoteSdkCredentials = remoteSdkCredentials;
        Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteSdkCredentials, (String)"remoteSdkCredentials");
        data.setHelpersPath(pyRemoteSdkCredentials.getHelpersPath());
    }

    @NotNull
    public static final SshUiData createSshUiData(@NotNull RemoteCredentialsVerifiableHolder remoteCredentials, boolean isProjectLevel, @Nullable Credentials credentials, boolean saveCredentialsInPermanentStore) {
        Intrinsics.checkParameterIsNotNull((Object)remoteCredentials, (String)"remoteCredentials");
        SshUiData data = new SshUiData(new SshConfig(true), false);
        data.loadFromCredentials((RemoteCredentials)remoteCredentials);
        data.setCredentials(credentials, saveCredentialsInPermanentStore, false);
        SshConfig sshConfig = data.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)sshConfig, (String)"data.config");
        sshConfig.setProjectLevel(isProjectLevel);
        return data;
    }

    public static /* synthetic */ SshUiData createSshUiData$default(RemoteCredentialsVerifiableHolder remoteCredentialsVerifiableHolder, boolean bl, Credentials credentials, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return SshSdkCreationUtilKt.createSshUiData(remoteCredentialsVerifiableHolder, bl, credentials, bl2);
    }

    @NotNull
    public static final WebServerConfig createSftpWebServerConfig(@NotNull SshUiData sshUiData) {
        Intrinsics.checkParameterIsNotNull((Object)sshUiData, (String)"sshUiData");
        WebServerConfig webServerConfig = new WebServerConfig(WebServerConfig.getNextId());
        SshConfig sshConfig = sshUiData.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)sshConfig, (String)"sshUiData.config");
        webServerConfig.setIsProjectLevel(sshConfig.isProjectLevel());
        SshUiData sshUiData2 = sshUiData;
        boolean bl = false;
        boolean bl2 = false;
        SshUiData it = sshUiData2;
        boolean bl3 = false;
        webServerConfig.setName(it.getUserName() + '@' + it.getHost() + ':' + it.getPort());
        webServerConfig.setUrl(NOT_EMPTY_URL);
        webServerConfig.getFileTransferConfig().setSshConfig(sshUiData.getConfig());
        return webServerConfig;
    }

    @NotNull
    public static final RemoteCredentials getRemoteCredentialsWithAuth(@NotNull SshUiData uiData) {
        Intrinsics.checkParameterIsNotNull((Object)uiData, (String)"uiData");
        SshUiData sshUiData = uiData.clone();
        Intrinsics.checkExpressionValueIsNotNull((Object)sshUiData, (String)"uiData.clone()");
        return (RemoteCredentials)sshUiData;
    }
}

