/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.jetbrains.python.scientific.PySciToolWindowListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/scientific/PyScientificTimeStatService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lastTimeOpened", "", "logTime", "", "duration", "registerToolwindowListener", "toolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowHidden", "toolWindowOpened", "intellij.python.scientific"})
public final class PyScientificTimeStatService {
    private long lastTimeOpened;
    private final Project project;

    public final void registerToolwindowListener(@NotNull ToolWindow toolwindow) {
        Intrinsics.checkParameterIsNotNull((Object)toolwindow, (String)"toolwindow");
        JComponent jComponent = toolwindow.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"toolwindow.component");
        PySciToolWindowListener newListener = new PySciToolWindowListener(this.project, jComponent);
        toolwindow.getComponent().addAncestorListener((AncestorListener)((Object)newListener));
        Disposer.register((Disposable)toolwindow.getDisposable(), (Disposable)newListener);
    }

    public final void toolWindowOpened() {
        this.lastTimeOpened = System.currentTimeMillis();
    }

    public final void toolWindowHidden() {
        if (this.lastTimeOpened > 0L) {
            long current = System.currentTimeMillis();
            this.logTime(current - this.lastTimeOpened);
            this.lastTimeOpened = -1L;
        }
    }

    private final void logTime(long duration) {
        FeatureUsageData data = new FeatureUsageData().addProject(this.project).addData("duration_ms", duration);
        FUCounterUsageLogger.getInstance().logEvent(this.project, "python.sciview", "toolwindow.shown", data);
    }

    public PyScientificTimeStatService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.lastTimeOpened = -1L;
    }
}

