/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.templateLanguages.PyTemplatesBundle;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonIcons;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMarkTemplateDirectoryAction
extends AnAction {
    private static boolean allDirectoriesAreTemplateRoots(Module module, VirtualFile[] files) {
        List<VirtualFile> folders = TemplatesService.getInstance(module).getTemplateFolders();
        return folders.containsAll(Arrays.asList(files));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PyMarkTemplateDirectoryAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        boolean isEnabled = module != null && virtualFiles != null && virtualFiles.length > 0 && PyMarkTemplateDirectoryAction.allFilesAreDirectories(virtualFiles);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(isEnabled);
        presentation.setIcon(PythonIcons.Python.TemplateRoot);
        presentation.setText(PythonProBundle.message(PyMarkTemplateDirectoryAction.isSelected(module, virtualFiles) ? "python.template.unmark.as.template.folder" : "python.template.folder"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PyMarkTemplateDirectoryAction.$$$reportNull$$$0(1);
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (module == null || virtualFiles == null) {
            return;
        }
        List<VirtualFile> folders = TemplatesService.getInstance(module).getTemplateFolders();
        List<VirtualFile> fileList = Arrays.asList(virtualFiles);
        boolean isSelected = PyMarkTemplateDirectoryAction.isSelected(module, virtualFiles);
        if (!isSelected) {
            folders.addAll(fileList);
        } else {
            folders.removeAll(fileList);
        }
        TemplatesService.getInstance(module).setTemplateFolders(folders.toArray(VirtualFile.EMPTY_ARRAY));
        Project project = module.getProject();
        ProjectView.getInstance((Project)project).refresh();
        if (!isSelected && TemplatesService.getInstance(module).getTemplateLanguage() == "None" && Messages.showYesNoDialog((Project)project, (String)PyTemplatesBundle.message("no_selected_template_language", new Object[0]), (String)PyTemplatesBundle.message("no_selected_template_language_header", new Object[0]), null) == 0) {
            ShowSettingsUtil.getInstance().showSettingsDialog(project, PyTemplatesBundle.message("python_template_languages", new Object[0]));
        }
    }

    private static boolean isSelected(@Nullable Module module, VirtualFile @Nullable [] virtualFiles) {
        return module != null && virtualFiles != null && virtualFiles.length > 0 && PyMarkTemplateDirectoryAction.allDirectoriesAreTemplateRoots(module, virtualFiles);
    }

    private static boolean allFilesAreDirectories(VirtualFile[] files) {
        for (VirtualFile file2 : files) {
            if (file2.isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/python/templateLanguages/PyMarkTemplateDirectoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

