/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.reflection;

import com.jetbrains.reflection.Property;
import java.beans.PropertyDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/reflection/JavaProperty;", "Lcom/jetbrains/reflection/Property;", "property", "Ljava/beans/PropertyDescriptor;", "instance", "", "(Ljava/beans/PropertyDescriptor;Ljava/lang/Object;)V", "getInstance", "()Ljava/lang/Object;", "getProperty", "()Ljava/beans/PropertyDescriptor;", "get", "getName", "", "getType", "Ljava/lang/Class;", "set", "", "value", "intellij.python.community.impl"})
final class JavaProperty
implements Property {
    @NotNull
    private final PropertyDescriptor property;
    @Nullable
    private final Object instance;

    @Override
    @NotNull
    public String getName() {
        String string = this.property.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        Class<?> clazz = this.property.getPropertyType();
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        return clazz;
    }

    @Override
    @NotNull
    public Object get() {
        Object object = this.property.getReadMethod().invoke(this.instance, new Object[0]);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    @Override
    public void set(@Nullable Object value2) {
        this.property.getWriteMethod().invoke(this.instance, value2);
    }

    @NotNull
    public final PropertyDescriptor getProperty() {
        return this.property;
    }

    @Nullable
    public final Object getInstance() {
        return this.instance;
    }

    public JavaProperty(@NotNull PropertyDescriptor property, @Nullable Object instance) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        this.property = property;
        this.instance = instance;
    }
}

