/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseOutputReader;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterNotebookProcessHandlerKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterProcessException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0003*+,B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b\u0012<\b\u0002\u0010\n\u001a6\u0012\u0017\u0012\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cH\u0002J\u0006\u0010%\u001a\u00020\u001cJ\b\u0010&\u001a\u00020\u0006H\u0002J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020\u0006H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018RB\u0010\n\u001a6\u0012\u0017\u0012\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler;", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "onServerInit", "Lkotlin/Function1;", "", "onServerTerminated", "Lkotlin/Function2;", "Lcom/intellij/execution/process/ProcessEvent;", "onServerError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lkotlin/ParameterName;", "name", "e", "notebookProcessHandler", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "STDERR_DATA_MAX_CAPACITY", "", "<set-?>", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "connectionParameters", "getConnectionParameters", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "serverInitLatch", "Ljava/util/concurrent/CountDownLatch;", "serverPath", "", "stderrData", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "token", "urlString", "checkIfInterrupted", "", "errorData", "collectErrorData", "initJupyterServer", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "startNotify", "Companion", "ConnectionPatternMatchResult", "JupyterProcessListener", "intellij.python.jupyter"})
public final class JupyterNotebookProcessHandler
extends KillableColoredProcessHandler {
    private String urlString;
    private String token;
    private String serverPath;
    private final int STDERR_DATA_MAX_CAPACITY = 8192;
    private final StringBuilder stderrData;
    private final CountDownLatch serverInitLatch;
    @Nullable
    private volatile JupyterConnectionParameters connectionParameters;
    private final Function1<JupyterNotebookProcessHandler, Unit> onServerInit;
    private final Function2<JupyterNotebookProcessHandler, ProcessEvent, Unit> onServerTerminated;
    private final Function2<Exception, JupyterNotebookProcessHandler, Unit> onServerError;
    private static final Pattern CONNECTION_PATTERN;
    private static final Regex SERVER_PATH_PATTERN;
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final JupyterConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    private final void initJupyterServer() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl = !application.isDispatchThread();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JupyterNotebookProcessHandler$initJupyterServer$22 = false;
            String $i$a$-assert-JupyterNotebookProcessHandler$initJupyterServer$22 = "Jupyter server initialization in EDT";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JupyterNotebookProcessHandler$initJupyterServer$22));
        }
        while (!this.serverInitLatch.await(500L, TimeUnit.MILLISECONDS)) {
            if (!this.isProcessTerminating() && !this.isProcessTerminated()) continue;
            throw (Throwable)new InterruptedException();
        }
        String urlString = this.urlString;
        String token = this.token;
        String serverPath = this.serverPath;
        if (urlString == null || serverPath == null) {
            throw (Throwable)new JupyterProcessException(this.getExitCode(), this.collectErrorData());
        }
        this.connectionParameters = new JupyterConnectionParameters(urlString, true, false, true, token, serverPath, null, 64, null);
    }

    private final boolean checkIfInterrupted(String errorData) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = CollectionsKt.asSequence((Iterable)StringsKt.lines((CharSequence)errorData));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)"KeyboardInterrupt")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String collectErrorData() {
        String string = this.stderrData.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stderrData.toString()");
        return string;
    }

    public void startNotify() {
        this.addProcessListener((ProcessListener)new JupyterProcessListener());
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ JupyterNotebookProcessHandler this$0;

            public final void run() {
                try {
                    JupyterNotebookProcessHandler.access$initJupyterServer(this.this$0);
                    JupyterNotebookProcessHandler.access$getOnServerInit$p(this.this$0).invoke((Object)((Object)this.this$0));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    JupyterNotebookProcessHandler.access$getOnServerError$p(this.this$0).invoke((Object)e, (Object)((Object)this.this$0));
                }
            }
            {
                this.this$0 = jupyterNotebookProcessHandler;
            }
        });
        super.startNotify();
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)options, (String)"BaseOutputReader.Options.forMostlySilentProcess()");
        return options;
    }

    public JupyterNotebookProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull Function1<? super JupyterNotebookProcessHandler, Unit> onServerInit, @NotNull Function2<? super JupyterNotebookProcessHandler, ? super ProcessEvent, Unit> onServerTerminated, @NotNull Function2<? super Exception, ? super JupyterNotebookProcessHandler, Unit> onServerError) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull(onServerInit, (String)"onServerInit");
        Intrinsics.checkParameterIsNotNull(onServerTerminated, (String)"onServerTerminated");
        Intrinsics.checkParameterIsNotNull(onServerError, (String)"onServerError");
        super(commandLine, true);
        this.onServerInit = onServerInit;
        this.onServerTerminated = onServerTerminated;
        this.onServerError = onServerError;
        this.STDERR_DATA_MAX_CAPACITY = 8192;
        this.stderrData = new StringBuilder();
        this.serverInitLatch = new CountDownLatch(2);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key<?> outputType) {
                Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
                Logger $this$debugOrInfoIfTestMode$iv = LOG;
                Exception e$iv = null;
                boolean $i$f$debugOrInfoIfTestMode = false;
                Application application = ApplicationManager.getApplication();
                if (application != null) {
                    if (application.isUnitTestMode()) {
                        Logger logger = $this$debugOrInfoIfTestMode$iv;
                        boolean bl = false;
                        String string = event2.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.text");
                        String string2 = string;
                        boolean bl2 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string4 = StringsKt.trimStart((String)((Object)StringsKt.trimEnd((CharSequence)string3)).toString(), (char[])new char[]{'\r', '\n'});
                        logger.info(string4);
                        return;
                    }
                }
                Logger $this$debug$iv$iv = $this$debugOrInfoIfTestMode$iv;
                boolean $i$f$debug = false;
                if (!$this$debug$iv$iv.isDebugEnabled()) return;
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                String string = event2.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.text");
                String string5 = string;
                boolean bl3 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string7 = StringsKt.trimStart((String)((Object)StringsKt.trimEnd((CharSequence)string6)).toString(), (char[])new char[]{'\r', '\n'});
                logger.debug(string7, (Throwable)e$iv);
            }
        });
    }

    public /* synthetic */ JupyterNotebookProcessHandler(GeneralCommandLine generalCommandLine, Function1 function1, Function2 function2, Function2 function22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function2 = 2.INSTANCE;
        }
        if ((n & 8) != 0) {
            function22 = 3.INSTANCE;
        }
        this(generalCommandLine, (Function1<? super JupyterNotebookProcessHandler, Unit>)function1, (Function2<? super JupyterNotebookProcessHandler, ? super ProcessEvent, Unit>)function2, (Function2<? super Exception, ? super JupyterNotebookProcessHandler, Unit>)function22);
    }

    static {
        Companion = new Companion(null);
        CONNECTION_PATTERN = Pattern.compile("(?<protocol>\\w+)://((?<host>[-.a-zA-Z0-9]+)|(\\([-.a-zA-Z0-9]+ or (?<localhost>[-.a-zA-Z0-9]+)\\))):(?<port>\\d*)(/(\\?token=((?<token>\\w+)|\\.\\.\\.))?)?$");
        SERVER_PATH_PATTERN = new Regex("Serving notebooks from local directory: (.*)$");
        Logger logger = Logger.getInstance(JupyterNotebookProcessHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Jupyt\u2026ocessHandler::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ String access$getToken$p(JupyterNotebookProcessHandler $this) {
        return $this.token;
    }

    public static final /* synthetic */ Function2 access$getOnServerTerminated$p(JupyterNotebookProcessHandler $this) {
        return $this.onServerTerminated;
    }

    public static final /* synthetic */ void access$initJupyterServer(JupyterNotebookProcessHandler $this) {
        $this.initJupyterServer();
    }

    public static final /* synthetic */ Function1 access$getOnServerInit$p(JupyterNotebookProcessHandler $this) {
        return $this.onServerInit;
    }

    public static final /* synthetic */ Function2 access$getOnServerError$p(JupyterNotebookProcessHandler $this) {
        return $this.onServerError;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler$JupyterProcessListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.python.jupyter"})
    private final class JupyterProcessListener
    extends ProcessAdapter {
        public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key<?> outputType) {
            Object object;
            Object it;
            boolean bl;
            boolean bl2;
            Object object2;
            Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
            Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
            if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR) ^ true) {
                return;
            }
            StringBuilder stringBuilder = JupyterNotebookProcessHandler.this.stderrData;
            String string = event2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.text");
            JupyterNotebookProcessHandlerKt.access$append(stringBuilder, string, JupyterNotebookProcessHandler.this.STDERR_DATA_MAX_CAPACITY);
            Object object3 = JupyterNotebookProcessHandler.this.serverPath;
            if (object3 == null) {
                Regex regex = SERVER_PATH_PATTERN;
                String string2 = event2.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"event.text");
                MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string2, (int)0, (int)2, null);
                if (matchResult != null) {
                    object2 = matchResult;
                    bl2 = false;
                    bl = false;
                    it = object2;
                    boolean bl3 = false;
                    JupyterNotebookProcessHandler.this.serverPath = (String)it.getGroupValues().get(1);
                    JupyterNotebookProcessHandler.this.serverInitLatch.countDown();
                    object3 = object2;
                } else {
                    object3 = null;
                }
            }
            if ((object = JupyterNotebookProcessHandler.this.urlString) == null) {
                String string3 = event2.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"event.text");
                ConnectionPatternMatchResult connectionPatternMatchResult = Companion.findConnectionPattern$intellij_python_jupyter(string3);
                if (connectionPatternMatchResult != null) {
                    object2 = connectionPatternMatchResult;
                    bl2 = false;
                    bl = false;
                    it = object2;
                    boolean bl4 = false;
                    URL url = new URL(((ConnectionPatternMatchResult)it).getProtocol(), ((ConnectionPatternMatchResult)it).getHost(), ((ConnectionPatternMatchResult)it).getPort(), "");
                    JupyterNotebookProcessHandler.this.urlString = url.toExternalForm();
                    JupyterNotebookProcessHandler.this.token = ((ConnectionPatternMatchResult)it).getToken();
                    JupyterNotebookProcessHandler.this.serverInitLatch.countDown();
                    object = object2;
                } else {
                    object = null;
                }
            }
        }

        public void processTerminated(@NotNull ProcessEvent event2) {
            Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, event2){
                final /* synthetic */ JupyterProcessListener this$0;
                final /* synthetic */ ProcessEvent $event;

                public final void run() {
                    JupyterNotebookProcessHandler.access$getOnServerTerminated$p(this.this$0.JupyterNotebookProcessHandler.this).invoke((Object)((Object)this.this$0.JupyterNotebookProcessHandler.this), (Object)this.$event);
                }
                {
                    this.this$0 = jupyterProcessListener;
                    this.$event = processEvent;
                }
            });
            JupyterNotebookProcessHandler.this.urlString = null;
            JupyterNotebookProcessHandler.this.token = null;
            JupyterNotebookProcessHandler.this.serverPath = null;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler$ConnectionPatternMatchResult;", "", "protocol", "", "host", "port", "", "token", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPort", "()I", "getProtocol", "getToken", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.python.jupyter"})
    public static final class ConnectionPatternMatchResult {
        @NotNull
        private final String protocol;
        @Nullable
        private final String host;
        private final int port;
        @Nullable
        private final String token;

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        @Nullable
        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        @Nullable
        public final String getToken() {
            return this.token;
        }

        public ConnectionPatternMatchResult(@NotNull String protocol, @Nullable String host, int port, @Nullable String token) {
            Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.token = token;
        }

        @NotNull
        public final String component1() {
            return this.protocol;
        }

        @Nullable
        public final String component2() {
            return this.host;
        }

        public final int component3() {
            return this.port;
        }

        @Nullable
        public final String component4() {
            return this.token;
        }

        @NotNull
        public final ConnectionPatternMatchResult copy(@NotNull String protocol, @Nullable String host, int port, @Nullable String token) {
            Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
            return new ConnectionPatternMatchResult(protocol, host, port, token);
        }

        public static /* synthetic */ ConnectionPatternMatchResult copy$default(ConnectionPatternMatchResult connectionPatternMatchResult, String string, String string2, int n, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = connectionPatternMatchResult.protocol;
            }
            if ((n2 & 2) != 0) {
                string2 = connectionPatternMatchResult.host;
            }
            if ((n2 & 4) != 0) {
                n = connectionPatternMatchResult.port;
            }
            if ((n2 & 8) != 0) {
                string3 = connectionPatternMatchResult.token;
            }
            return connectionPatternMatchResult.copy(string, string2, n, string3);
        }

        @NotNull
        public String toString() {
            return "ConnectionPatternMatchResult(protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", token=" + this.token + ")";
        }

        public int hashCode() {
            String string = this.protocol;
            String string2 = this.host;
            String string3 = this.token;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.port)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConnectionPatternMatchResult)) break block3;
                    ConnectionPatternMatchResult connectionPatternMatchResult = (ConnectionPatternMatchResult)object;
                    if (!Intrinsics.areEqual((Object)this.protocol, (Object)connectionPatternMatchResult.protocol) || !Intrinsics.areEqual((Object)this.host, (Object)connectionPatternMatchResult.host) || this.port != connectionPatternMatchResult.port || !Intrinsics.areEqual((Object)this.token, (Object)connectionPatternMatchResult.token)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler$Companion;", "", "()V", "CONNECTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SERVER_PATH_PATTERN", "Lkotlin/text/Regex;", "findConnectionPattern", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler$ConnectionPatternMatchResult;", "input", "", "findConnectionPattern$intellij_python_jupyter", "intellij.python.jupyter"})
    public static final class Companion {
        @Nullable
        public final ConnectionPatternMatchResult findConnectionPattern$intellij_python_jupyter(@NotNull CharSequence input) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Matcher matcher = CONNECTION_PATTERN.matcher(input);
            if (matcher.find()) {
                String string = matcher.group("protocol");
                if (string == null) {
                    return null;
                }
                String protocol = string;
                String string2 = matcher.group("host");
                if (string2 == null) {
                    string2 = matcher.group("localhost");
                }
                if (string2 == null) {
                    return null;
                }
                String host = string2;
                Object object = matcher.group("port");
                int port = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : -1;
                String token = matcher.group("token");
                return new ConnectionPatternMatchResult(protocol, host, port, token);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

