/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterExecutionException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSockerClientClosedException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSocketClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.BytesWebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.StringWebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.WebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 02\u00020\u0001:\u0003012B\u0097\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\b\u0002\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\u0007\u0012\"\b\u0002\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\n0\f\u0012\u001a\b\u0002\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u0007\u0012\"\b\u0002\u0010\u0011\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u0014J\b\u0010)\u001a\u00020\nH\u0002J\b\u0010*\u001a\u00020\nH\u0016J\b\u0010+\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0010H\u0002J\u0010\u0010.\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0010H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0010H\u0002R\u0016\u0010\u0015\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR+\u0010\u0011\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR%\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00060(R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClient;", "serverUri", "Ljava/net/URI;", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "onOpen", "Lkotlin/Function2;", "Lorg/java_websocket/client/WebSocketClient;", "Lorg/java_websocket/handshake/ServerHandshake;", "", "onClose", "Lkotlin/Function3;", "", "", "onMessage", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/WebSocketMessage;", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/net/URI;Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "exception", "getHttpSession", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getOnClose", "()Lkotlin/jvm/functions/Function3;", "getOnError", "()Lkotlin/jvm/functions/Function2;", "getOnMessage", "getOnOpen", "value", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl$ConnectionStatus;", "status", "setStatus", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl$ConnectionStatus;)V", "statusChanged", "Ljava/util/concurrent/locks/Condition;", "webSocketClient", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl$WebSocketClientImpl;", "checkStatusIsNotClosed", "close", "initiateWebSocketReconnection", "reconnectAndSend", "content", "send", "waitForConnectionAndSend", "Companion", "ConnectionStatus", "WebSocketClientImpl", "intellij.python.jupyter"})
public final class JupyterWebSocketClientImpl
implements JupyterWebSocketClient {
    private final ReentrantLock lock;
    private final Condition statusChanged;
    private ConnectionStatus status;
    private Exception exception;
    private WebSocketClientImpl webSocketClient;
    private final URI serverUri;
    @NotNull
    private final HttpSession httpSession;
    @NotNull
    private final Function2<WebSocketClient, ServerHandshake, Unit> onOpen;
    @NotNull
    private final Function3<WebSocketClient, Integer, String, Unit> onClose;
    @NotNull
    private final Function2<WebSocketClient, WebSocketMessage, Unit> onMessage;
    @NotNull
    private final Function2<WebSocketClient, Exception, Unit> onError;
    private static final Logger LOG;
    public static final Companion Companion;

    private final void setStatus(ConnectionStatus value2) {
        Logger $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Connection status changed from " + (Object)((Object)this.status) + " to " + (Object)((Object)value2) + " for " + this;
            logger.debug(string, (Throwable)e$iv);
        }
        this.status = value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@NotNull WebSocketMessage content2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        Logger $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Send " + content2 + " to websocket " + this.serverUri;
            logger.debug(string, (Throwable)e$iv);
        }
        Lock $this$withLockInterruptibly$iv = this.lock;
        Companion this_$iv = Companion;
        boolean $i$f$withLockInterruptibly = false;
        $this$withLockInterruptibly$iv.lockInterruptibly();
        try {
            boolean bl = false;
            this.checkStatusIsNotClosed();
            if (this.status == ConnectionStatus.DISCONNECTED) {
                this.setStatus(ConnectionStatus.CONNECTING);
                this.statusChanged.signalAll();
                this.initiateWebSocketReconnection();
            }
            try {
                this.waitForConnectionAndSend(content2);
            }
            catch (WebsocketNotConnectedException e) {
                this.reconnectAndSend(content2);
            }
            catch (NotYetConnectedException e) {
                this.reconnectAndSend(content2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withLockInterruptibly$iv.unlock();
        }
    }

    private final void waitForConnectionAndSend(WebSocketMessage content2) {
        Unit unit;
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "lock is not acquired";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.checkStatusIsNotClosed();
        while (this.status == ConnectionStatus.CONNECTING) {
            this.statusChanged.await();
        }
        this.checkStatusIsNotClosed();
        if (this.status == ConnectionStatus.DISCONNECTED) {
            Exception exception = this.exception;
            throw exception != null ? (Throwable)exception : (Throwable)new IllegalStateException("Connection failed");
        }
        WebSocketMessage webSocketMessage = content2;
        if (webSocketMessage instanceof StringWebSocketMessage) {
            this.webSocketClient.send(((StringWebSocketMessage)content2).getString());
            unit = Unit.INSTANCE;
        } else if (webSocketMessage instanceof BytesWebSocketMessage) {
            this.webSocketClient.send(((BytesWebSocketMessage)content2).getBytes());
            unit = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        webSocketMessage = unit;
        bl2 = false;
        boolean bl4 = false;
        WebSocketMessage $this$run = webSocketMessage;
        boolean bl5 = false;
    }

    private final void reconnectAndSend(WebSocketMessage content2) {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "lock is not acquired";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.checkStatusIsNotClosed();
        if (this.status != ConnectionStatus.CONNECTING) {
            this.setStatus(ConnectionStatus.CONNECTING);
            this.initiateWebSocketReconnection();
        }
        this.waitForConnectionAndSend(content2);
    }

    private final void initiateWebSocketReconnection() {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "lock is not acquired";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.webSocketClient.dispose();
        this.webSocketClient = new WebSocketClientImpl(this.serverUri);
        this.webSocketClient.connect();
    }

    private final void checkStatusIsNotClosed() {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "lock is not acquired";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.status == ConnectionStatus.CLOSED) {
            throw (Throwable)new JupyterWebSockerClientClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Logger $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Closing websocket to " + this.serverUri;
            logger.debug(string, (Throwable)e$iv);
        }
        Lock $this$withLockInterruptibly$iv = this.lock;
        Companion this_$iv = Companion;
        boolean $i$f$withLockInterruptibly = false;
        $this$withLockInterruptibly$iv.lockInterruptibly();
        try {
            boolean bl = false;
            this.setStatus(ConnectionStatus.CLOSED);
            this.statusChanged.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withLockInterruptibly$iv.unlock();
        }
        this.webSocketClient.close();
    }

    @NotNull
    public final HttpSession getHttpSession() {
        return this.httpSession;
    }

    @NotNull
    public final Function2<WebSocketClient, ServerHandshake, Unit> getOnOpen() {
        return this.onOpen;
    }

    @NotNull
    public final Function3<WebSocketClient, Integer, String, Unit> getOnClose() {
        return this.onClose;
    }

    @NotNull
    public final Function2<WebSocketClient, WebSocketMessage, Unit> getOnMessage() {
        return this.onMessage;
    }

    @NotNull
    public final Function2<WebSocketClient, Exception, Unit> getOnError() {
        return this.onError;
    }

    public JupyterWebSocketClientImpl(@NotNull URI serverUri, @NotNull HttpSession httpSession, @NotNull Function2<? super WebSocketClient, ? super ServerHandshake, Unit> onOpen, @NotNull Function3<? super WebSocketClient, ? super Integer, ? super String, Unit> onClose, @NotNull Function2<? super WebSocketClient, ? super WebSocketMessage, Unit> onMessage, @NotNull Function2<? super WebSocketClient, ? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)serverUri, (String)"serverUri");
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        Intrinsics.checkParameterIsNotNull(onOpen, (String)"onOpen");
        Intrinsics.checkParameterIsNotNull(onClose, (String)"onClose");
        Intrinsics.checkParameterIsNotNull(onMessage, (String)"onMessage");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.serverUri = serverUri;
        this.httpSession = httpSession;
        this.onOpen = onOpen;
        this.onClose = onClose;
        this.onMessage = onMessage;
        this.onError = onError;
        this.lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();
        Intrinsics.checkExpressionValueIsNotNull((Object)condition, (String)"lock.newCondition()");
        this.statusChanged = condition;
        this.status = ConnectionStatus.DISCONNECTED;
        this.webSocketClient = new WebSocketClientImpl(this.serverUri);
    }

    public /* synthetic */ JupyterWebSocketClientImpl(URI uRI, HttpSession httpSession, Function2 function2, Function3 function3, Function2 function22, Function2 function23, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function3 = 2.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = 3.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function23 = 4.INSTANCE;
        }
        this(uRI, httpSession, (Function2<? super WebSocketClient, ? super ServerHandshake, Unit>)function2, (Function3<? super WebSocketClient, ? super Integer, ? super String, Unit>)function3, (Function2<? super WebSocketClient, ? super WebSocketMessage, Unit>)function22, (Function2<? super WebSocketClient, ? super Exception, Unit>)function23);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    public static final /* synthetic */ Exception access$getException$p(JupyterWebSocketClientImpl $this) {
        return $this.exception;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u000e\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl$WebSocketClientImpl;", "Lorg/java_websocket/client/WebSocketClient;", "serverUri", "Ljava/net/URI;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl;Ljava/net/URI;)V", "isDisposed", "", "dispose", "", "onClose", "code", "", "reason", "", "remote", "onError", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMessage", "message", "Ljava/nio/ByteBuffer;", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "intellij.python.jupyter"})
    private final class WebSocketClientImpl
    extends WebSocketClient {
        private boolean isDisposed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(@Nullable ServerHandshake handshakedata) {
            Lock $this$withLockInterruptibly$iv = JupyterWebSocketClientImpl.this.lock;
            Companion this_$iv = Companion;
            boolean $i$f$withLockInterruptibly = false;
            $this$withLockInterruptibly$iv.lockInterruptibly();
            try {
                boolean bl = false;
                if (this.isDisposed) {
                    return;
                }
                if (JupyterWebSocketClientImpl.this.status != ConnectionStatus.CLOSED) {
                    JupyterWebSocketClientImpl.this.setStatus(ConnectionStatus.CONNECTED);
                    JupyterWebSocketClientImpl.this.statusChanged.signalAll();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withLockInterruptibly$iv.unlock();
            }
            Logger $this$debug$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Received onOpen() for " + (Object)((Object)this);
                logger.debug(string, (Throwable)e$iv);
            }
            JupyterWebSocketClientImpl.this.getOnOpen().invoke((Object)this, (Object)handshakedata);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void onClose(int code, @Nullable String reason, boolean remote) {
            void $this$withLockInterruptibly$iv;
            Lock lock = JupyterWebSocketClientImpl.this.lock;
            Companion this_$iv = Companion;
            boolean $i$f$withLockInterruptibly = false;
            $this$withLockInterruptibly$iv.lockInterruptibly();
            try {
                boolean bl = false;
                if (this.isDisposed) {
                    return;
                }
                if (JupyterWebSocketClientImpl.this.status != ConnectionStatus.CLOSED) {
                    JupyterWebSocketClientImpl.this.setStatus(ConnectionStatus.DISCONNECTED);
                    JupyterWebSocketClientImpl.this.exception = new JupyterExecutionException(Companion.buildOnCloseMessage(code, reason, remote));
                    JupyterWebSocketClientImpl.this.statusChanged.signalAll();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withLockInterruptibly$iv.unlock();
            }
            LOG.info("Received onClose(" + code + ", \"" + reason + "\", " + remote + ") for " + (Object)((Object)this));
            JupyterWebSocketClientImpl.this.getOnClose().invoke((Object)this, (Object)code, (Object)reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Lock $this$withLockInterruptibly$iv = JupyterWebSocketClientImpl.this.lock;
            Companion this_$iv = Companion;
            boolean $i$f$withLockInterruptibly = false;
            $this$withLockInterruptibly$iv.lockInterruptibly();
            try {
                boolean bl = false;
                if (this.isDisposed) {
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withLockInterruptibly$iv.unlock();
            }
            JupyterWebSocketClientImpl.this.getOnMessage().invoke((Object)this, (Object)new StringWebSocketMessage(message));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(@NotNull ByteBuffer message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Lock $this$withLockInterruptibly$iv = JupyterWebSocketClientImpl.this.lock;
            Companion this_$iv = Companion;
            boolean $i$f$withLockInterruptibly = false;
            $this$withLockInterruptibly$iv.lockInterruptibly();
            try {
                boolean bl = false;
                if (this.isDisposed) {
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withLockInterruptibly$iv.unlock();
            }
            JupyterWebSocketClientImpl.this.getOnMessage().invoke((Object)this, (Object)new BytesWebSocketMessage(message));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(@Nullable Exception exception) {
            Lock $this$withLockInterruptibly$iv = JupyterWebSocketClientImpl.this.lock;
            Companion this_$iv = Companion;
            boolean $i$f$withLockInterruptibly = false;
            $this$withLockInterruptibly$iv.lockInterruptibly();
            try {
                boolean bl = false;
                if (this.isDisposed) {
                    return;
                }
                if (JupyterWebSocketClientImpl.this.status == ConnectionStatus.CONNECTING) {
                    JupyterWebSocketClientImpl.this.setStatus(ConnectionStatus.DISCONNECTED);
                    JupyterWebSocketClientImpl.this.exception = exception;
                    JupyterWebSocketClientImpl.this.statusChanged.signalAll();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withLockInterruptibly$iv.unlock();
            }
            LOG.info("Received onError(" + exception + ") for " + (Object)((Object)this));
            JupyterWebSocketClientImpl.this.getOnError().invoke((Object)this, (Object)exception);
        }

        public final void dispose() {
            Logger $this$debug$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Dispose " + (Object)((Object)this);
                logger.debug(string, (Throwable)e$iv);
            }
            this.isDisposed = true;
            this.close();
        }

        public WebSocketClientImpl(URI serverUri) {
            Intrinsics.checkParameterIsNotNull((Object)serverUri, (String)"serverUri");
            super(serverUri, Companion.getHttpHeadersWithCookies(JupyterWebSocketClientImpl.this.getHttpSession()));
            if (Intrinsics.areEqual((Object)serverUri.getScheme(), (Object)"wss")) {
                CertificateManager certificateManager = CertificateManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)certificateManager, (String)"CertificateManager.getInstance()");
                SSLContext sSLContext = certificateManager.getSslContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"CertificateManager.getInstance().sslContext");
                SSLContext sslContext = sSLContext;
                try {
                    this.setSocket(sslContext.getSocketFactory().createSocket());
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage());
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl$ConnectionStatus;", "", "(Ljava/lang/String;I)V", "DISCONNECTED", "CONNECTING", "CONNECTED", "CLOSED", "intellij.python.jupyter"})
    private static final class ConnectionStatus
    extends Enum<ConnectionStatus> {
        public static final /* enum */ ConnectionStatus DISCONNECTED;
        public static final /* enum */ ConnectionStatus CONNECTING;
        public static final /* enum */ ConnectionStatus CONNECTED;
        public static final /* enum */ ConnectionStatus CLOSED;
        private static final /* synthetic */ ConnectionStatus[] $VALUES;

        static {
            ConnectionStatus[] connectionStatusArray = new ConnectionStatus[4];
            ConnectionStatus[] connectionStatusArray2 = connectionStatusArray;
            connectionStatusArray[0] = DISCONNECTED = new ConnectionStatus();
            connectionStatusArray[1] = CONNECTING = new ConnectionStatus();
            connectionStatusArray[2] = CONNECTED = new ConnectionStatus();
            connectionStatusArray[3] = CLOSED = new ConnectionStatus();
            $VALUES = connectionStatusArray;
        }

        public static ConnectionStatus[] values() {
            return (ConnectionStatus[])$VALUES.clone();
        }

        public static ConnectionStatus valueOf(String string) {
            return Enum.valueOf(ConnectionStatus.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u0007*\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010*\u00020\u000eH\u0002J&\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0082\b\u00a2\u0006\u0002\u0010\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClientImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildOnCloseMessage", "", "code", "", "reason", "remote", "", "buildCookieHeaderValue", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "getHttpHeadersWithCookies", "", "withLockInterruptibly", "T", "Ljava/util/concurrent/locks/Lock;", "action", "Lkotlin/Function0;", "(Ljava/util/concurrent/locks/Lock;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.python.jupyter"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T withLockInterruptibly(@NotNull Lock $this$withLockInterruptibly, Function0<? extends T> action) {
            int $i$f$withLockInterruptibly = 0;
            $this$withLockInterruptibly.lockInterruptibly();
            try {
                Object object = action.invoke();
                return (T)object;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this$withLockInterruptibly.unlock();
                InlineMarker.finallyEnd((int)1);
            }
        }

        private final String buildOnCloseMessage(int code, String reason, boolean remote) {
            String string = reason;
            if (string == null) {
                string = (remote ? "Remote" : "Local") + " side closed connection with exit code " + code + '.';
            }
            return string;
        }

        private final Map<String, String> getHttpHeadersWithCookies(@NotNull HttpSession $this$getHttpHeadersWithCookies) {
            Map map2 = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Cookie", (Object)this.buildCookieHeaderValue($this$getHttpHeadersWithCookies))});
            boolean bl = false;
            boolean bl2 = false;
            Map $this$apply = map2;
            boolean bl3 = false;
            $this$apply.putAll($this$getHttpHeadersWithCookies.getHttpHeaders());
            return map2;
        }

        /*
         * WARNING - void declaration
         */
        private final String buildCookieHeaderValue(@NotNull HttpSession $this$buildCookieHeaderValue) {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = $this$buildCookieHeaderValue.getCookies();
            boolean $i$f$map = false;
            Map<String, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_7.entrySet().iterator();
            while (iterator.hasNext()) {
                void name;
                void $dstr$name$value;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var13_13 = $dstr$name$value;
                boolean bl3 = false;
                String string = (String)var13_13.getKey();
                var13_13 = $dstr$name$value;
                bl3 = false;
                String value2 = (String)var13_13.getValue();
                String string2 = (String)name + '=' + value2;
                collection.add(string2);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ Object access$withLockInterruptibly(Companion $this, Lock $this$access_u24withLockInterruptibly, Function0 action) {
            return $this.withLockInterruptibly($this$access_u24withLockInterruptibly, action);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

