/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSocketClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSocketClientImpl;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterSessionData;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.WebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.HttpSessionFileContentsApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.TreeCachingFileContentsApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpecBase;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$H\u0016J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClientImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClient;", "connectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;)V", "getConnectionParameters", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "fileContentsApi", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/CachingFileContentsApi;", "getFileContentsApi", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/CachingFileContentsApi;", "restClient", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRestClient;", "urlString", "", "getUrlString", "()Ljava/lang/String;", "createSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterSessionData;", "kernelName", "notebookPath", "createWebSocketClientForKernel", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClient;", "kernelId", "onMessage", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/WebSocketMessage;", "", "deleteSession", "sessionId", "getKernelId", "getKernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "getKernelSpecs", "", "interrupt", "restart", "Companion", "intellij.python.jupyter"})
public final class JupyterClientImpl
implements JupyterClient {
    @NotNull
    private final String urlString;
    private final JupyterRestClient restClient;
    @NotNull
    private final CachingFileContentsApi fileContentsApi;
    @NotNull
    private final JupyterConnectionParameters connectionParameters;
    private final HttpSession httpSession;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getUrlString() {
        return this.urlString;
    }

    @Override
    @Nullable
    public String getKernelId(@NotNull String kernelName) {
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        JsonNode jsonNode = this.restClient.postKernel(kernelName).get("id");
        return jsonNode != null ? jsonNode.asText() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<JupyterKernelSpec> getKernelSpecs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.restClient.getKernelSpecs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JupyterKernelSpec jupyterKernelSpec;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonNode p1 = (JsonNode)element$iv$iv;
            boolean bl2 = false;
            if (JupyterKernelSpecBase.Companion.fromServerJson(p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            JupyterKernelSpec it$iv$iv = jupyterKernelSpec;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public JupyterKernelSpec getKernelSpec(@NotNull String kernelName) {
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        JupyterKernelSpec jupyterKernelSpec = JupyterKernelSpecBase.Companion.fromServerJson((JsonNode)this.restClient.getKernelSpec(kernelName));
        if (jupyterKernelSpec == null) {
            throw (Throwable)new IllegalStateException();
        }
        return jupyterKernelSpec;
    }

    @Override
    @NotNull
    public JupyterSessionData createSession(@NotNull String kernelName, @NotNull String notebookPath) {
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        Intrinsics.checkParameterIsNotNull((Object)notebookPath, (String)"notebookPath");
        ObjectNode objectNode = this.restClient.postSession(kernelName, notebookPath);
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$run = objectNode;
        boolean bl3 = false;
        String string = $this$run.get("id").asText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"get(\"id\").asText()");
        String string2 = $this$run.get("kernel").get("id").asText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"get(\"kernel\").get(\"id\").asText()");
        return new JupyterSessionData(string, string2);
    }

    @Override
    public void deleteSession(@NotNull String sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        this.restClient.deleteSession(sessionId);
    }

    @Override
    public void interrupt(@NotNull String kernelId) {
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        this.restClient.interruptKernel(kernelId);
    }

    @Override
    public void restart(@NotNull String kernelId) {
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        this.restClient.restartKernel(kernelId);
    }

    @Override
    @NotNull
    public JupyterWebSocketClient createWebSocketClientForKernel(@NotNull String kernelId, @NotNull Function1<? super WebSocketMessage, Unit> onMessage) {
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        Intrinsics.checkParameterIsNotNull(onMessage, (String)"onMessage");
        URI wsUri = Companion.getWebSocketUri$intellij_python_jupyter(new URL(this.getUrlString()), kernelId);
        return new JupyterWebSocketClientImpl(wsUri, this.httpSession, null, null, (Function2)new Function2<WebSocketClient, WebSocketMessage, Unit>(onMessage){
            final /* synthetic */ Function1 $onMessage;

            public final void invoke(@NotNull WebSocketClient $noName_0, @NotNull WebSocketMessage content2) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
                this.$onMessage.invoke((Object)content2);
            }
            {
                this.$onMessage = function1;
                super(2);
            }
        }, null, 44, null);
    }

    @Override
    @NotNull
    public CachingFileContentsApi getFileContentsApi() {
        return this.fileContentsApi;
    }

    @Override
    @NotNull
    public JupyterConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public JupyterClientImpl(@NotNull JupyterConnectionParameters connectionParameters, @NotNull HttpSession httpSession) {
        Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        this.connectionParameters = connectionParameters;
        this.httpSession = httpSession;
        this.urlString = this.getConnectionParameters().getUrlString();
        this.restClient = new JupyterRestClient(this.httpSession);
        this.fileContentsApi = new TreeCachingFileContentsApi(new HttpSessionFileContentsApi(this.httpSession));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClientImpl$Companion;", "", "()V", "getWebSocketUri", "Ljava/net/URI;", "url", "Ljava/net/URL;", "kernelId", "", "getWebSocketUri$intellij_python_jupyter", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final URI getWebSocketUri$intellij_python_jupyter(@NotNull URL url, @NotNull String kernelId) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
            String string = url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
            String kernelChannelPath = JupyterHttpSessionRestUtilsKt.resolveURIPath(string, "/api/kernels/" + kernelId + "/channels");
            return new URI("ws", url.getUserInfo(), url.getHost(), url.getPort(), kernelChannelPath, url.getQuery(), null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

