/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterWebFrontEndApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallback;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterKernelClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterNotebookSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServers;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B7\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n\u00a2\u0006\u0002\u0010\u000bB7\b\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010!\u001a\u00020\"H\u0016J4\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00062\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\"0&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u001a\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\b\u0010'\u001a\u0004\u0018\u00010(H\u0017J\u001a\u0010.\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010/\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020\u0006H\u0016R\u0016\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001b\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterNotebookSessionImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterNotebookSession;", "Lorg/jetbrains/plugins/notebooks/jupyter/JupyterWebFrontEndApi;", "connectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "kernelName", "", "kernelId", "sessionId", "frontEndProducer", "Lkotlin/Function0;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "jupyterServer", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "getJupyterServer", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "kernelClient", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterKernelClient;", "getKernelClient", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterKernelClient;", "getKernelName", "()Ljava/lang/String;", "kernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "getKernelSpec", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "getSessionId", "deleteSession", "", "execute", "code", "onMessageCreated", "Lkotlin/Function1;", "callback", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;", "silent", "", "sendMessage", "message", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "sendMessageOnPooledThread", "sendMessageToFrontEnd", "stopListeningMessageReply", "messageId", "intellij.python.jupyter"})
public final class JupyterNotebookSessionImpl
implements JupyterNotebookSession,
JupyterWebFrontEndApi {
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final JupyterKernelClient kernelClient;
    @NotNull
    private final JupyterKernelSpec kernelSpec;
    @NotNull
    private final JupyterServer jupyterServer;
    @NotNull
    private final String kernelName;
    private final String kernelId;
    @NotNull
    private final String sessionId;
    private final Function0<JupyterWebFrontEndApi> frontEndProducer;

    @NotNull
    public final ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    @NotNull
    public JupyterKernelClient getKernelClient() {
        return this.kernelClient;
    }

    @Override
    @NotNull
    public JupyterKernelSpec getKernelSpec() {
        return this.kernelSpec;
    }

    @Override
    public void execute(@NotNull String code, @NotNull Function1<? super String, Unit> onMessageCreated, @NotNull JupyterCellExecutionCallback callback2, boolean silent) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull(onMessageCreated, (String)"onMessageCreated");
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        this.getKernelClient().execute(code, this.getSessionId(), onMessageCreated, callback2, silent);
    }

    @Override
    @Deprecated(message="Should be encapsulated")
    public void sendMessage(@NotNull JupyterMessage message, @Nullable JupyterCellExecutionCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.getKernelClient().sendMessage(message, callback2);
    }

    @Override
    public void stopListeningMessageReply(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        this.getKernelClient().stopListeningMessageReply(messageId);
    }

    @Override
    public void deleteSession() {
        this.getKernelClient().deleteSession();
        this.executor.shutdown();
    }

    @Override
    public void sendMessageOnPooledThread(@NotNull JupyterMessage message, @Nullable JupyterCellExecutionCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (!this.executor.isShutdown()) {
            try {
                this.executor.execute(new Runnable(this, message, callback2){
                    final /* synthetic */ JupyterNotebookSessionImpl this$0;
                    final /* synthetic */ JupyterMessage $message;
                    final /* synthetic */ JupyterCellExecutionCallback $callback;

                    public final void run() {
                        this.this$0.sendMessage(this.$message, this.$callback);
                    }
                    {
                        this.this$0 = jupyterNotebookSessionImpl;
                        this.$message = jupyterMessage;
                        this.$callback = jupyterCellExecutionCallback;
                    }
                });
            }
            catch (RejectedExecutionException ex) {
                Logger.getInstance(JupyterNotebookSession.class).warn((Throwable)ex);
            }
        }
    }

    @Override
    public void sendMessageToFrontEnd(@NotNull JupyterMessage message) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            JupyterWebFrontEndApi jupyterWebFrontEndApi = (JupyterWebFrontEndApi)this.frontEndProducer.invoke();
            if (jupyterWebFrontEndApi == null) break block0;
            jupyterWebFrontEndApi.sendMessageToFrontEnd(message);
        }
    }

    @Override
    @NotNull
    public JupyterServer getJupyterServer() {
        return this.jupyterServer;
    }

    @Override
    @NotNull
    public String getKernelName() {
        return this.kernelName;
    }

    @Override
    @NotNull
    public String getSessionId() {
        return this.sessionId;
    }

    private JupyterNotebookSessionImpl(JupyterServer jupyterServer, String kernelName, String kernelId, String sessionId, Function0<? extends JupyterWebFrontEndApi> frontEndProducer) {
        this.jupyterServer = jupyterServer;
        this.kernelName = kernelName;
        this.kernelId = kernelId;
        this.sessionId = sessionId;
        this.frontEndProducer = frontEndProducer;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Jupyter", (int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"AppExecutorUtil.createBo\u2026oolExecutor(\"Jupyter\", 1)");
        this.executor = executorService;
        this.kernelClient = new JupyterKernelClient(this.getJupyterServer(), this.kernelId, this.getSessionId(), this);
        this.kernelSpec = this.getJupyterServer().getClient().getKernelSpec(this.getKernelName());
    }

    public JupyterNotebookSessionImpl(@NotNull JupyterConnectionParameters connectionParameters, @NotNull String kernelName, @NotNull String kernelId, @NotNull String sessionId, @NotNull Function0<? extends JupyterWebFrontEndApi> frontEndProducer) {
        Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull(frontEndProducer, (String)"frontEndProducer");
        this(JupyterServers.Companion.getInstance().getServer(connectionParameters), kernelName, kernelId, sessionId, frontEndProducer);
    }
}

