/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import java.io.OutputStream;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManager;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugProcess;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugSessionManager;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0014J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XDebugSession;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "destroyProcessImpl", "", "detachIsDefault", "", "detachProcessImpl", "getProcessInput", "Ljava/io/OutputStream;", "intellij.python.jupyter"})
public final class JupyterDebugProcessHandler
extends ProcessHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final XDebugSession session;

    protected void destroyProcessImpl() {
        JupyterCell jupyterCell;
        JupyterDebugProcess debugProcess;
        XDebugProcess xDebugProcess = this.session.getDebugProcess();
        if (!(xDebugProcess instanceof JupyterDebugProcess)) {
            xDebugProcess = null;
        }
        JupyterDebugProcess jupyterDebugProcess = debugProcess = (JupyterDebugProcess)xDebugProcess;
        JupyterCell jupyterCell2 = jupyterCell = jupyterDebugProcess != null ? jupyterDebugProcess.getLatestExecutedCell() : null;
        if (jupyterCell != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(this, jupyterCell){
                final /* synthetic */ JupyterDebugProcessHandler this$0;
                final /* synthetic */ JupyterCell $jupyterCell;

                public final void run() {
                    String sessionPath = JupyterCellExecutionManager.Companion.getSessionPath(this.$jupyterCell);
                    if (JupyterDebugSessionManager.Companion.getInstance(this.this$0.getProject()).isSessionUnderDebug(sessionPath)) {
                        try {
                            JupyterCellExecutionManager.Companion.getInstance(this.this$0.getProject()).interrupt(this.$jupyterCell);
                        }
                        catch (SocketException e) {
                            JupyterDebugProcess.Companion.getLOG().warn(e.getMessage());
                            this.this$0.getSession().stop();
                        }
                    }
                    JupyterDebugProcessHandler.access$notifyProcessTerminated(this.this$0, 0);
                    JupyterDebugSessionManager.Companion.getInstance(this.this$0.getProject()).debugInSessionFinished(sessionPath);
                }
                {
                    this.this$0 = jupyterDebugProcessHandler;
                    this.$jupyterCell = jupyterCell;
                }
            });
            debugProcess.printToConsole("Debugger disconnected\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    protected void detachProcessImpl() {
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    public JupyterDebugProcessHandler(@NotNull Project project, @NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.project = project;
        this.session = session;
    }

    public static final /* synthetic */ void access$notifyProcessTerminated(JupyterDebugProcessHandler $this, int p0) {
        $this.notifyProcessTerminated(p0);
    }
}

