/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.JupyterCustomizer;
import org.jetbrains.plugins.notebooks.jupyter.JupyterWebFrontEndApi;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterActionsUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterClearOutputsAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterConfigureShortcutsAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterInsertCellAboveAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterInsertCellBelowAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterRunAllAboveAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterRunAllAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterRunAllBelowAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterRunCellAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterRunCellSelectBelowAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterSelectCellAboveAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterSelectCellBelowAction;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterInterruptKernelAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterKernelManagementAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterRestartKernelAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterServerChooserAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTextEditorWithPreview$$special$;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTrustAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewFileEditor;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListenerKt;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterStartServerAction;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterStopServerAction;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;
import org.jetbrains.plugins.notebooks.jupyter.trust.JupyterTrustManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\r\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0016H\u0016J\u0006\u0010!\u001a\u00020\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020(H\u0002J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0007J\f\u0010,\u001a\u00020\u0014*\u00020-H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterTextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "Lorg/jetbrains/plugins/notebooks/jupyter/JupyterWebFrontEndApi;", "project", "Lcom/intellij/openapi/project/Project;", "fullFilePath", "", "sourceEditor", "previewFileEditor", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewFileEditor;", "editorName", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewFileEditor;Ljava/lang/String;)V", "kernelComboBoxAction", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterKernelManagementAction;", "canNavigateTo", "", "navigatable", "Lcom/intellij/pom/Navigatable;", "clearJupyterData", "", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createJupyterActionsPopup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "createLeftToolbarActionGroup", "createRightToolbarActionGroup", "createScrollingSyncActionGroup", "dispose", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/NotNull;", "getFile", "getSourceEditor", "navigateTo", "sendMessageToFrontEnd", "message", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "settingsChanged", "before", "Lorg/jetbrains/plugins/notebooks/jupyter/settings/JupyterSettings;", "after", "showErrorBalloonForKernelComboBoxAction", "text", "addJupyterFileActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Companion", "intellij.python.jupyter"})
public final class JupyterTextEditorWithPreview
extends TextEditorWithPreview
implements TextEditor,
JupyterWebFrontEndApi {
    private final JupyterKernelManagementAction kernelComboBoxAction;
    private final Project project;
    private final String fullFilePath;
    private final TextEditor sourceEditor;
    private final JupyterPreviewFileEditor previewFileEditor;
    public static final Companion Companion = new Companion(null);

    public final void showErrorBalloonForKernelComboBoxAction(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.kernelComboBoxAction.showWarning(text2);
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{(AnAction)this.createJupyterActionsPopup(), JupyterActionsUtilKt.getAction(JupyterRunAllAction.class), JupyterActionsUtilKt.getAction(JupyterInterruptKernelAction.class), JupyterActionsUtilKt.getAction(JupyterRestartKernelAction.class), (AnAction)Separator.create()});
        boolean bl = false;
        boolean bl2 = false;
        DefaultActionGroup $this$apply = defaultActionGroup;
        boolean bl3 = false;
        this.addJupyterFileActions($this$apply);
        $this$apply.addAll(new AnAction[]{(AnAction)new JupyterServerChooserAction(), (AnAction)this.kernelComboBoxAction});
        return (ActionGroup)defaultActionGroup;
    }

    private final void addJupyterFileActions(@NotNull DefaultActionGroup $this$addJupyterFileActions) {
        AnAction anAction = ActionManager.getInstance().getAction("JupyterFileActions");
        if (anAction == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        AnAction[] jupyterFileActions = ((ActionGroup)anAction).getChildren(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)jupyterFileActions, (String)"jupyterFileActions");
        AnAction[] anActionArray = jupyterFileActions;
        boolean bl = false;
        AnAction[] anActionArray2 = anActionArray;
        boolean bl2 = false;
        if (!(anActionArray2.length == 0)) {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread((Object)jupyterFileActions);
            spreadBuilder.add((Object)((AnAction)Separator.create()));
            $this$addJupyterFileActions.addAll((AnAction[])spreadBuilder.toArray((Object[])new AnAction[spreadBuilder.size()]));
        }
    }

    private final ActionGroup createJupyterActionsPopup() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{JupyterActionsUtilKt.getAction(JupyterRunCellAction.class), JupyterActionsUtilKt.getAction(JupyterRunAllAboveAction.class), JupyterActionsUtilKt.getAction(JupyterRunAllBelowAction.class), JupyterActionsUtilKt.getAction(JupyterRunCellSelectBelowAction.class), JupyterActionsUtilKt.getAction(JupyterDebugAction.class), (AnAction)Separator.create(), JupyterActionsUtilKt.getAction(JupyterInsertCellAboveAction.class), JupyterActionsUtilKt.getAction(JupyterInsertCellBelowAction.class), (AnAction)Separator.create(), JupyterActionsUtilKt.getAction(JupyterSelectCellAboveAction.class), JupyterActionsUtilKt.getAction(JupyterSelectCellBelowAction.class), (AnAction)Separator.create(), JupyterActionsUtilKt.getAction(JupyterClearOutputsAction.class), (AnAction)Separator.create(), JupyterActionsUtilKt.getAction(JupyterStartServerAction.class), JupyterActionsUtilKt.getAction(JupyterStopServerAction.class), (AnAction)Separator.create(), JupyterActionsUtilKt.getAction(JupyterConfigureShortcutsAction.class)});
        boolean bl = false;
        boolean bl2 = false;
        DefaultActionGroup $this$apply = defaultActionGroup;
        boolean bl3 = false;
        Presentation presentation = $this$apply.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
        presentation.setText(JupyterBundle.message("jupyter.actions", new Object[0]));
        Presentation presentation2 = $this$apply.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"templatePresentation");
        presentation2.setIcon(AllIcons.Actions.IntentionBulb);
        $this$apply.setPopup(true);
        return (ActionGroup)defaultActionGroup;
    }

    private final ActionGroup createScrollingSyncActionGroup() {
        return (ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)new ToggleAction(this, JupyterBundle.message("jupyter.autoscroll.from.source.title", new Object[0]), JupyterBundle.message("jupyter.autoscroll.from.source.description", new Object[0]), AllIcons.General.AutoscrollFromSource){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return JupyterSettings.Companion.getInstance().getAutoscrollFromSource();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                JupyterSettings before = JupyterSettings.copy$default(JupyterSettings.Companion.getInstance(), false, false, false, false, false, false, false, 0, false, false, 0, 2047, null);
                JupyterSettings.Companion.getInstance().setAutoscrollFromSource(state2);
                JupyterTextEditorWithPreview.settingsChanged$default(this.this$0, before, null, 2, null);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        }, (AnAction)new ToggleAction(this, JupyterBundle.message("jupyter.autoscroll.to.source.title", new Object[0]), JupyterBundle.message("jupyter.autoscroll.to.source.description", new Object[0]), AllIcons.General.AutoscrollToSource){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return JupyterSettings.Companion.getInstance().getAutoscrollToSource();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                JupyterSettings before = JupyterSettings.copy$default(JupyterSettings.Companion.getInstance(), false, false, false, false, false, false, false, 0, false, false, 0, 2047, null);
                JupyterSettings.Companion.getInstance().setAutoscrollToSource(state2);
                JupyterTextEditorWithPreview.settingsChanged$default(this.this$0, before, null, 2, null);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        }, (AnAction)new ToggleAction(this, JupyterBundle.message("jupyter.show.sources.in.preview.title", new Object[0]), JupyterBundle.message("jupyter.show.sources.in.preview.description", new Object[0]), AllIcons.Actions.ShowCode){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return JupyterSettings.Companion.getInstance().getShowSourcesInPreview();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                JupyterSettings before = JupyterSettings.copy$default(JupyterSettings.Companion.getInstance(), false, false, false, false, false, false, false, 0, false, false, 0, 2047, null);
                JupyterSettings.Companion.getInstance().setShowSourcesInPreview(state2);
                JupyterTextEditorWithPreview.settingsChanged$default(this.this$0, before, null, 2, null);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        }});
    }

    @Nullable
    protected ActionGroup createRightToolbarActionGroup() {
        JupyterTrustManager.FileSpecificView trustView = JupyterTrustManager.Companion.getTrustManager(this.project).asFileSpecificView(this.fullFilePath);
        return (ActionGroup)new DefaultActionGroup(new AnAction[]{JupyterTrustAction.Companion.create(trustView), (AnAction)this.createScrollingSyncActionGroup()});
    }

    private final void settingsChanged(JupyterSettings before, JupyterSettings after) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((JupyterSettingsChangeListener)application.getMessageBus().syncPublisher(JupyterSettingsChangeListenerKt.getJUPYTER_SETTINGS_TOPIC())).settingsChanged(before, after);
    }

    static /* synthetic */ void settingsChanged$default(JupyterTextEditorWithPreview jupyterTextEditorWithPreview, JupyterSettings jupyterSettings, JupyterSettings jupyterSettings2, int n, Object object) {
        if ((n & 2) != 0) {
            jupyterSettings2 = JupyterSettings.Companion.getInstance();
        }
        jupyterTextEditorWithPreview.settingsChanged(jupyterSettings, jupyterSettings2);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        return this.sourceEditor.canNavigateTo(navigatable);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        this.sourceEditor.navigateTo(navigatable);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.sourceEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"sourceEditor.editor");
        return editor2;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.sourceEditor.getFile();
    }

    @NotNull
    public final TextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    private final void clearJupyterData(VirtualFile originalFile) {
        if (originalFile.getUserData(JupyterCellUtilKt.getJUPYTER_EDITOR_KEY()) != null) {
            originalFile.putUserData(JupyterCellUtilKt.getJUPYTER_EDITOR_KEY(), null);
            originalFile.putUserData(JupyterCellUtilKt.getNOTEBOOK_VIRTUAL_FILE_KEY(), null);
        }
    }

    public void dispose() {
        VirtualFile virtualFile2 = this.sourceEditor.getFile();
        if (virtualFile2 instanceof NotebookVirtualFile) {
            this.clearJupyterData(((NotebookVirtualFile)virtualFile2).getOriginFile());
        }
        super.dispose();
    }

    @Override
    public void sendMessageToFrontEnd(@NotNull JupyterMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.previewFileEditor.sendMessageToFrontEnd(message);
    }

    public JupyterTextEditorWithPreview(@NotNull Project project, @NotNull String fullFilePath, @NotNull TextEditor sourceEditor, @NotNull JupyterPreviewFileEditor previewFileEditor, @NotNull String editorName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fullFilePath, (String)"fullFilePath");
        Intrinsics.checkParameterIsNotNull((Object)sourceEditor, (String)"sourceEditor");
        Intrinsics.checkParameterIsNotNull((Object)previewFileEditor, (String)"previewFileEditor");
        Intrinsics.checkParameterIsNotNull((Object)editorName, (String)"editorName");
        super(sourceEditor, (FileEditor)previewFileEditor, editorName, JupyterTextEditorWithPreview.Companion.defaultLayout());
        this.project = project;
        this.fullFilePath = fullFilePath;
        this.sourceEditor = sourceEditor;
        this.previewFileEditor = previewFileEditor;
        this.kernelComboBoxAction = new JupyterKernelManagementAction();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        boolean bl2 = false;
        MessageBusConnection $this$apply = messageBusConnection;
        boolean bl3 = false;
        $this$apply.subscribe(JupyterSettingsChangeListenerKt.getJUPYTER_SETTINGS_TOPIC(), (Object)new JupyterSettingsChangeListener(this){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;
            {
                this.this$0 = jupyterTextEditorWithPreview;
            }

            public void settingsChanged(@NotNull JupyterSettings before, @NotNull JupyterSettings after) {
                Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
                Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                    final /* synthetic */ $special$$inlined$apply$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        Editor editor2 = JupyterTextEditorWithPreview.access$getSourceEditor$p(this.this$0.this$0).getEditor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"sourceEditor.editor");
                        Editor editor3 = editor2;
                        VirtualFile virtualFile2 = JupyterTextEditorWithPreview.access$getSourceEditor$p(this.this$0.this$0).getFile();
                        if (!(virtualFile2 instanceof NotebookVirtualFile)) {
                            virtualFile2 = null;
                        }
                        NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)virtualFile2;
                        if (notebookVirtualFile == null) {
                            return;
                        }
                        NotebookVirtualFile jupyterFile = notebookVirtualFile;
                        editor3.getDocument().setText(jupyterFile.getNotebook().asSource());
                    }
                }));
            }
        });
    }

    public static final /* synthetic */ TextEditor access$getSourceEditor$p(JupyterTextEditorWithPreview $this) {
        return $this.sourceEditor;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterTextEditorWithPreview$Companion;", "", "()V", "defaultLayout", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "intellij.python.jupyter"})
    public static final class Companion {
        private final TextEditorWithPreview.Layout defaultLayout() {
            return JupyterCustomizer.Companion.getInstance().showHtmlPreviewPanelByDefault() ? TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW : TextEditorWithPreview.Layout.SHOW_EDITOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

