/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.messages.ProcessExecutionErrorDialogKt;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServersKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.inspections.JupyterInspectionBase;
import org.jetbrains.plugins.notebooks.jupyter.editor.inspections.JupyterInspectionBaseKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.inspections.JupyterKernelInspection;
import org.jetbrains.plugins.notebooks.jupyter.editor.inspections.JupyterKernelInspectionKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpecKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J1\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004H\u0002\u00a2\u0006\u0002\u0010\u0014J7\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0004\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J3\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001bH\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/inspections/JupyterKernelInspection;", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/inspections/JupyterInspectionBase;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;ZLcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createKernelInterpreterDescriptors", "quickFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiFile;[Lcom/intellij/codeInspection/LocalQuickFix;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createMissingNotebookKernelSpecDescriptors", "createTurnProjectInterpreterIntoKernelFix", "notebookVirtualFile", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "createUpdateNotebookKernelSpecFix", "serverKernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "createWrongNotebookKernelSpecDescriptors", "interpreterKernelSpec", "(Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiFile;Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getGroupDisplayName", "", "runInstallKernelProcess", "", "project", "Lcom/intellij/openapi/project/Project;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "updateKernelSpec", "kernelSpec", "Companion", "intellij.python.jupyter"})
public final class JupyterKernelInspection
extends JupyterInspectionBase {
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public String getGroupDisplayName() {
        return JupyterBundle.message("INSP.NAME.no.jupyter.package", new Object[0]);
    }

    @Override
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull Module module, @NotNull Sdk sdk) {
        boolean bl;
        JupyterKernelSpec interpreterKernelSpec;
        NotebookVirtualFile jupyterVirtualFile;
        block18: {
            Object v8;
            String projectInterpreterPath;
            JupyterServer jupyterServer;
            block17: {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
                if (PythonSdkUtil.isRemote(sdk) || PythonSdkUtil.isInvalid(sdk)) {
                    return new ProblemDescriptor[0];
                }
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk);
                Intrinsics.checkExpressionValueIsNotNull((Object)pyPackageManager, (String)"PyPackageManager.getInstance(sdk)");
                if (JupyterInspectionBaseKt.noPackage(pyPackageManager, "ipykernel")) {
                    return new ProblemDescriptor[0];
                }
                VirtualFile virtualFile2 = file2.getVirtualFile();
                if (!(virtualFile2 instanceof NotebookVirtualFile)) {
                    virtualFile2 = null;
                }
                NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)virtualFile2;
                if (notebookVirtualFile == null) {
                    return new ProblemDescriptor[0];
                }
                jupyterVirtualFile = notebookVirtualFile;
                JupyterNotebook notebook = jupyterVirtualFile.getNotebook();
                Project project = file2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                JupyterServer jupyterServer2 = JupyterConnectionSettingsUtilKt.getJupyterServer(project, file2.getVirtualFile());
                if (jupyterServer2 == null) {
                    return new ProblemDescriptor[0];
                }
                jupyterServer = jupyterServer2;
                if (!JupyterConnectionSettingsUtilKt.isLocal(jupyterServer.getConnectionParameters())) {
                    return new ProblemDescriptor[0];
                }
                String string = sdk.getHomePath();
                if (string == null) {
                    return new ProblemDescriptor[0];
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdk.homePath ?: return emptyArray()");
                projectInterpreterPath = string;
                List<JupyterKernelSpec> list = jupyterServer.getKernelSpecs();
                if (list == null) {
                    return JupyterKernelInspectionKt.access$getNO_PROBLEMS$p();
                }
                List<JupyterKernelSpec> kernelSpecs = list;
                Iterable $this$firstOrNull$iv = kernelSpecs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JupyterKernelSpec it = (JupyterKernelSpec)element$iv;
                    boolean bl2 = false;
                    JupyterKernelSpec jupyterKernelSpec = notebook.getKernelSpec();
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)(jupyterKernelSpec != null ? jupyterKernelSpec.getName() : null))) continue;
                    v8 = element$iv;
                    break block17;
                }
                v8 = null;
            }
            JupyterKernelSpec serverKernelSpec = v8;
            List<JupyterKernelSpec> interpreterKernelSpecs = JupyterServersKt.getProjectInterpreterKernelSpecs(jupyterServer, projectInterpreterPath);
            interpreterKernelSpec = (JupyterKernelSpec)CollectionsKt.firstOrNull(interpreterKernelSpecs);
            JupyterKernelSpec notebookKernelSpec = jupyterVirtualFile.getNotebook().getKernelSpec();
            if (interpreterKernelSpec == null) {
                if (notebookKernelSpec == null) {
                    return this.createMissingNotebookKernelSpecDescriptors(manager, file2, this.createTurnProjectInterpreterIntoKernelFix(module, sdk, jupyterVirtualFile));
                }
                if (serverKernelSpec == null) {
                    return this.createKernelInterpreterDescriptors(manager, file2, new LocalQuickFix[]{this.createTurnProjectInterpreterIntoKernelFix(module, sdk, jupyterVirtualFile)});
                }
                return this.createKernelInterpreterDescriptors(manager, file2, new LocalQuickFix[]{this.createTurnProjectInterpreterIntoKernelFix(module, sdk, jupyterVirtualFile), new PyInterpreterInspection.ConfigureInterpreterFix()});
            }
            if (notebookKernelSpec == null) {
                return this.createMissingNotebookKernelSpecDescriptors(manager, file2, this.createUpdateNotebookKernelSpecFix(jupyterVirtualFile, interpreterKernelSpec));
            }
            Iterable $this$all$iv = interpreterKernelSpecs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JupyterKernelSpec it = (JupyterKernelSpec)element$iv;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)notebookKernelSpec.getName(), (Object)it.getName()) ^ true) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            return this.createWrongNotebookKernelSpecDescriptors(manager, file2, jupyterVirtualFile, interpreterKernelSpec);
        }
        return JupyterKernelInspectionKt.access$getNO_PROBLEMS$p();
    }

    private final ProblemDescriptor[] createKernelInterpreterDescriptors(InspectionManager manager, PsiFile file2, LocalQuickFix[] quickFixes) {
        String string = "Notebook kernel doesn't match %s";
        Object[] objectArray = new Object[]{PlatformUtils.isPyCharm() ? "project interpreter" : "module SDK"};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        String description = string2;
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file2, description, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026_ERROR_OR_WARNING\n      )");
        problemDescriptorArray[0] = problemDescriptor;
        return problemDescriptorArray;
    }

    private final ProblemDescriptor[] createWrongNotebookKernelSpecDescriptors(InspectionManager manager, PsiFile file2, NotebookVirtualFile notebookVirtualFile, JupyterKernelSpec interpreterKernelSpec) {
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file2, JupyterBundle.message("jupyter.kernels.dont.match", new Object[0]), true, new LocalQuickFix[]{this.createUpdateNotebookKernelSpecFix(notebookVirtualFile, interpreterKernelSpec)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026_ERROR_OR_WARNING\n      )");
        problemDescriptorArray[0] = problemDescriptor;
        return problemDescriptorArray;
    }

    private final ProblemDescriptor[] createMissingNotebookKernelSpecDescriptors(InspectionManager manager, PsiFile file2, LocalQuickFix ... quickFixes) {
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file2, JupyterBundle.message("jupyter.kernel.spec.missing", new Object[0]), true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026_ERROR_OR_WARNING\n      )");
        problemDescriptorArray[0] = problemDescriptor;
        return problemDescriptorArray;
    }

    private final LocalQuickFix createUpdateNotebookKernelSpecFix(NotebookVirtualFile notebookVirtualFile, JupyterKernelSpec serverKernelSpec) {
        return new LocalQuickFix(this, notebookVirtualFile, serverKernelSpec){
            final /* synthetic */ JupyterKernelInspection this$0;
            final /* synthetic */ NotebookVirtualFile $notebookVirtualFile;
            final /* synthetic */ JupyterKernelSpec $serverKernelSpec;

            @NotNull
            public String getFamilyName() {
                return JupyterBundle.message("jupyter.quickfix.family.name", new Object[0]);
            }

            @NotNull
            public String getName() {
                return JupyterBundle.message("jupyter.update.kernel.fix", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                JupyterKernelInspection.access$updateKernelSpec(this.this$0, project, this.$notebookVirtualFile, this.$serverKernelSpec);
            }
            {
                this.this$0 = $outer;
                this.$notebookVirtualFile = $captured_local_variable$1;
                this.$serverKernelSpec = $captured_local_variable$2;
            }
        };
    }

    private final void updateKernelSpec(Project project, NotebookVirtualFile notebookVirtualFile, JupyterKernelSpec kernelSpec) {
        JupyterRuntimeService.Companion.getInstance(project).switchKernel(notebookVirtualFile.getOriginFile(), kernelSpec);
    }

    private final LocalQuickFix createTurnProjectInterpreterIntoKernelFix(Module module, Sdk sdk, NotebookVirtualFile notebookVirtualFile) {
        return new LocalQuickFix(this, module, sdk, notebookVirtualFile){
            final /* synthetic */ JupyterKernelInspection this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ NotebookVirtualFile $notebookVirtualFile;

            @NotNull
            public String getFamilyName() {
                return JupyterBundle.message("jupyter.quickfix.family.name", new Object[0]);
            }

            @NotNull
            public String getName() {
                return JupyterBundle.message("jupyter.interpreter.as.kernel.fix", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                JupyterKernelSpec kernelSpec = JupyterKernelSpecKt.createKernelSpec(this.$module);
                GeneralCommandLine commandLine = JupyterKernelInspectionKt.access$createInstallKernelCommandLine(project, this.$sdk, kernelSpec.getName(), kernelSpec.getDisplayName());
                new Task.Backgroundable(this, project, commandLine, kernelSpec, project, JupyterBundle.message("jupyter.interpreter.as.kernel.fix.title", new Object[0])){
                    final /* synthetic */ createTurnProjectInterpreterIntoKernelFix.1 this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GeneralCommandLine $commandLine;
                    final /* synthetic */ JupyterKernelSpec $kernelSpec;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        if (this.$project.isDisposed()) {
                            return;
                        }
                        JupyterKernelInspection.access$runInstallKernelProcess(this.this$0.this$0, this.$project, this.$commandLine);
                        JupyterKernelInspection.access$updateKernelSpec(this.this$0.this$0, this.$project, this.this$0.$notebookVirtualFile, this.$kernelSpec);
                    }
                    {
                        this.this$0 = $outer;
                        this.$project = $captured_local_variable$1;
                        this.$commandLine = $captured_local_variable$2;
                        this.$kernelSpec = $captured_local_variable$3;
                        super($super_call_param$4, $super_call_param$5);
                    }
                }.queue();
            }
            {
                this.this$0 = $outer;
                this.$module = $captured_local_variable$1;
                this.$sdk = $captured_local_variable$2;
                this.$notebookVirtualFile = $captured_local_variable$3;
            }
        };
    }

    private final void runInstallKernelProcess(Project project, GeneralCommandLine commandLine) {
        ProcessOutput output;
        ProcessOutput processOutput = output = PySdkUtil.getProcessOutput(commandLine, project.getBasePath(), null, 5000, null, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"output");
        if (processOutput.getExitCode() != 0) {
            String errorMessage = "IPython JupyterKernel installation error";
            LOG.error(errorMessage + " Output: " + output.getStderr());
            ApplicationManager.getApplication().invokeLater(new Runnable(project, commandLine, errorMessage, output){
                final /* synthetic */ Project $project;
                final /* synthetic */ GeneralCommandLine $commandLine;
                final /* synthetic */ String $errorMessage;
                final /* synthetic */ ProcessOutput $output;

                public final void run() {
                    if (this.$project.isDisposed()) {
                        return;
                    }
                    List list = this.$commandLine.getCommandLineList(null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"commandLine.getCommandLineList(null)");
                    List commandLineList = list;
                    String string = (String)CollectionsKt.firstOrNull((List)commandLineList);
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "";
                    }
                    String command = string2;
                    ProcessOutput processOutput = this.$output;
                    Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"output");
                    String string3 = processOutput.getStdout();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"output.stdout");
                    ProcessOutput processOutput2 = this.$output;
                    Intrinsics.checkExpressionValueIsNotNull((Object)processOutput2, (String)"output");
                    String string4 = processOutput2.getStderr();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"output.stderr");
                    ProcessOutput processOutput3 = this.$output;
                    Intrinsics.checkExpressionValueIsNotNull((Object)processOutput3, (String)"output");
                    ProcessExecutionErrorDialogKt.showProcessExecutionErrorDialog((Project)this.$project, (String)this.$errorMessage, (String)command, (String)string3, (String)string4, (int)processOutput3.getExitCode());
                }
                {
                    this.$project = project;
                    this.$commandLine = generalCommandLine;
                    this.$errorMessage = string;
                    this.$output = processOutput;
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    public static final /* synthetic */ void access$updateKernelSpec(JupyterKernelInspection $this, Project project, NotebookVirtualFile notebookVirtualFile, JupyterKernelSpec kernelSpec) {
        $this.updateKernelSpec(project, notebookVirtualFile, kernelSpec);
    }

    public static final /* synthetic */ void access$runInstallKernelProcess(JupyterKernelInspection $this, Project project, GeneralCommandLine commandLine) {
        $this.runInstallKernelProcess(project, commandLine);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/inspections/JupyterKernelInspection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

