/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.server.ui;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import icons.PythonJupyterIcons;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterNotebookProcessHandler;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerExecution;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterStartServerExecutionAction;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterStopServerExecutionAction;
import org.jetbrains.plugins.notebooks.jupyter.server.ui.JupyterServerContentCloseListener;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"EVENT_LOG_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "JUPYTER_NOTIFICATION_GROUP", "getJUPYTER_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "JUPYTER_SERVER_LOG_HELP_ID", "", "JUPYTER_TOOL_WINDOW_ID", "RUNNER_ID", "createJupyterNotification", "Lcom/intellij/notification/Notification;", "message", "getJupyterToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "getOrCreateJupyterToolWindow", "notifyJupyterServerStarted", "", "connectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "notifyJupyterServerTerminated", "showJupyterServerManagementToolWindow", "execution", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerExecution;", "handler", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterNotebookProcessHandler;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.python.jupyter"})
public final class JupyterServerToolWindowKt {
    private static final String RUNNER_ID = "JupyterServerRunner";
    private static final String JUPYTER_TOOL_WINDOW_ID = "Jupyter";
    @NotNull
    private static final NotificationGroup JUPYTER_NOTIFICATION_GROUP = NotificationGroup.Companion.toolWindowGroup("Jupyter Server (Tool Window)", "Jupyter", false);
    private static final NotificationGroup EVENT_LOG_NOTIFICATION_GROUP = NotificationGroup.Companion.logOnlyGroup("Jupyter Server (Event Log)");
    private static final String JUPYTER_SERVER_LOG_HELP_ID = "tool_window.jupyter_server_log";

    @NotNull
    public static final NotificationGroup getJUPYTER_NOTIFICATION_GROUP() {
        return JUPYTER_NOTIFICATION_GROUP;
    }

    @Nullable
    public static final ToolWindow getJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return ToolWindowManager.Companion.getInstance(project).getToolWindow(JUPYTER_TOOL_WINDOW_ID);
    }

    @NotNull
    public static final ToolWindow getOrCreateJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(JUPYTER_TOOL_WINDOW_ID);
        if (toolWindow == null) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkExpressionValueIsNotNull((Object)toolWindowAnchor, (String)"ToolWindowAnchor.BOTTOM");
            Supplier supplier = null;
            Icon icon = null;
            ToolWindowFactory toolWindowFactory = null;
            boolean bl = false;
            boolean bl2 = false;
            ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
            boolean bl3 = false;
            JComponent jComponent = null;
            boolean bl4 = true;
            toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(JUPYTER_TOOL_WINDOW_ID, toolWindowAnchor2, jComponent, bl3, bl4, bl2, bl, toolWindowFactory, icon, supplier, 1004, null));
        }
        ToolWindow toolWindow2 = toolWindow;
        toolWindow2.setIcon(PythonJupyterIcons.ToolWindowJupyter);
        return toolWindow2;
    }

    public static final void showJupyterServerManagementToolWindow(@NotNull JupyterServerExecution execution, @NotNull JupyterNotebookProcessHandler handler, @NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        Intrinsics.checkParameterIsNotNull((Object)((Object)handler), (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        Project project2 = project;
        Object[] objectArray = new Object[1];
        String string = module.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
        objectArray[0] = string;
        String serverContentTitle = JupyterBundle.message("Jupyter.toolwindow.server.title", objectArray);
        String logContentTitle = JupyterBundle.message("Jupyter.toolwindow.server.log.title", new Object[0]);
        ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow(project2);
        ConsoleViewImpl console = new ConsoleViewImpl(project2, GlobalSearchScope.allScope((Project)project2), true, true);
        console.setHelpId(JUPYTER_SERVER_LOG_HELP_ID);
        console.attachToProcess((ProcessHandler)handler);
        RunnerLayoutUi runnerLayoutUi = RunnerLayoutUi.Factory.getInstance((Project)project2).create(RUNNER_ID, serverContentTitle, serverContentTitle, (Disposable)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)runnerLayoutUi, (String)"RunnerLayoutUi.Factory.g\u2026verContentTitle, project)");
        RunnerLayoutUi ui2 = runnerLayoutUi;
        Content content2 = ui2.createContent(RUNNER_ID, console.getComponent(), logContentTitle, null, console.getPreferredFocusableComponent());
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"ui.createContent(RUNNER_\u2026ferredFocusableComponent)");
        Content consoleContent = content2;
        consoleContent.setCloseable(false);
        ui2.addContent(consoleContent);
        DefaultActionGroup group2 = new DefaultActionGroup(new AnAction[]{new JupyterStartServerExecutionAction(module), new JupyterStopServerExecutionAction(execution)});
        ui2.getOptions().setLeftToolbar((ActionGroup)group2, "unknown");
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager manager = contentManager;
        Content serverContent = manager.findContent(serverContentTitle);
        if (serverContent != null) {
            manager.removeContent(serverContent, true);
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content3 = contentFactory.createContent(ui2.getComponent(), serverContentTitle, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"contentFactory.createCon\u2026serverContentTitle, true)");
        Content newContent = content3;
        newContent.setCloseable(false);
        manager.addContent(newContent, 0);
        new JupyterServerContentCloseListener(newContent, module, (KillableProcessHandler)handler);
        JUPYTER_NOTIFICATION_GROUP.createNotification(JupyterBundle.message("jupyter.server.starting.notification", new Object[0]), NotificationType.INFORMATION).notify(project2);
    }

    public static final void notifyJupyterServerStarted(@NotNull Project project, @NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
        JupyterConnectionParameters jupyterConnectionParameters = connectionParameters;
        boolean bl = false;
        boolean bl2 = false;
        JupyterConnectionParameters $this$run = jupyterConnectionParameters;
        boolean bl3 = false;
        String url = $this$run.getUrlString() + "?token=" + $this$run.getToken();
        JupyterConnectionParameters jupyterConnectionParameters2 = connectionParameters;
        bl2 = false;
        boolean bl4 = false;
        JupyterConnectionParameters $this$run2 = jupyterConnectionParameters2;
        boolean bl5 = false;
        String message = "Jupyter Server started at " + $this$run2.getUrlString();
        JupyterConnectionParameters jupyterConnectionParameters3 = connectionParameters;
        bl4 = false;
        boolean bl6 = false;
        JupyterConnectionParameters $this$run3 = jupyterConnectionParameters3;
        boolean bl7 = false;
        String messageWithURL = "Jupyter Server started at <a href=\"" + url + "\">" + $this$run3.getUrlString() + "</a>";
        JUPYTER_NOTIFICATION_GROUP.createNotification("", messageWithURL, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).notify(project);
        JupyterServerToolWindowKt.createJupyterNotification(message).addAction((AnAction)new BrowseNotificationAction("Open in Browser", url)).notify(project);
    }

    @NotNull
    public static final Notification createJupyterNotification(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return EVENT_LOG_NOTIFICATION_GROUP.createNotification("", message, NotificationType.INFORMATION, null);
    }

    public static final void notifyJupyterServerTerminated(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new NotificationGroup[]{JUPYTER_NOTIFICATION_GROUP, EVENT_LOG_NOTIFICATION_GROUP});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationGroup it = (NotificationGroup)element$iv;
            boolean bl = false;
            it.createNotification("", JupyterBundle.message("jupyter.server.stopped", new Object[0]), NotificationType.INFORMATION, null).notify(project);
        }
    }
}

