/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteConnectionType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="SshConsoleOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SshConsoleOptionsProvider
implements PersistentStateComponent<State> {
    private final State myState = new State();
    private final Project myProject;

    public static SshConsoleOptionsProvider getInstance(Project project) {
        return (SshConsoleOptionsProvider)ServiceManager.getService((Project)project, SshConsoleOptionsProvider.class);
    }

    public SshConsoleOptionsProvider(Project project) {
        this.myProject = project;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SshConsoleOptionsProvider.$$$reportNull$$$0(0);
        }
        this.myState.myEncoding = state.myEncoding;
        this.myState.myConnectionType = state.myConnectionType;
        this.myState.myConnectionId = state.myConnectionId;
        this.myState.myAdditionalData = state.myAdditionalData;
        if (RemoteConnectionType.DEPLOYMENT_SERVER == RemoteConnectionType.findByName((String)this.myState.myConnectionType)) {
            PresentableId id;
            WebServerConfig server = GroupedServersConfigManager.getInstance((Project)this.myProject).findServer(this.myState.myConnectionId);
            this.myState.myConnectionType = RemoteConnectionType.SSH_CONFIG.name();
            this.myState.myConnectionId = null;
            this.myState.myAdditionalData = null;
            if (server != null && (id = server.getFileTransferConfig().getSshPresentableId()) != null) {
                this.myState.myConnectionId = id.getName();
                this.myState.myAdditionalData = id.getId();
            }
        }
    }

    public void setCharset(Charset charset) {
        this.myState.myEncoding = charset != null ? charset.name() : null;
    }

    public void setConnectByDefaultType(RemoteConnectionType connectionType) {
        this.myState.myConnectionType = connectionType.name();
    }

    public RemoteConnectionType getConnectionType() {
        return RemoteConnectionType.findByName((String)this.myState.myConnectionType);
    }

    public String getConnectionId() {
        return this.myState.myConnectionId;
    }

    public void setConnectionId(String id) {
        this.myState.myConnectionId = id;
    }

    public String getAdditionalData() {
        return this.myState.myAdditionalData;
    }

    public void setAdditionalData(String data) {
        this.myState.myAdditionalData = data;
    }

    public Charset getCharset() {
        Charset charset = this.myState.myEncoding != null ? CharsetToolkit.forName((String)this.myState.myEncoding) : null;
        return charset != null ? charset : Charset.defaultCharset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/plugins/remotesdk/console/SshConsoleOptionsProvider", "loadState"));
    }

    public static class State {
        public String myEncoding;
        public String myConnectionType;
        public String myConnectionId;
        public String myAdditionalData;
    }
}

