/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolActions {
    @NotNull
    public static JBIterable<PsiElement> getSelectedElements(@NotNull DataContext dataContext) {
        PsiElement element2;
        if (dataContext == null) {
            ToolActions.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiReference ref = editor == null || file == null ? null : file.findReferenceAt(editor.getCaretModel().getOffset());
        PsiElement psiElement = element2 = ref != null && ref.getElement() instanceof SqlElement ? ref.resolve() : null;
        if (element2 instanceof SqlElement) {
            JBIterable jBIterable = SqlPsiFacade.getInstance((Project)file.getProject()).findRelatedDbElements(element2, true).filter(PsiElement.class);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        if (element2 != null) {
            JBIterable jBIterable = JBIterable.of((Object)element2);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        Object[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            JBIterable jBIterable = JBIterable.of((Object[])elements);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        VirtualFile vfile = file == null ? null : file.getVirtualFile();
        DbElement fileElement = vfile == null ? null : DbSrcUtils.findDbElement(file.getProject(), vfile.getPath(), DbElement.class);
        JBIterable jBIterable = JBIterable.of(fileElement);
        if (jBIterable == null) {
            ToolActions.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToolActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToolActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefreshMatViewAction
    extends ScriptingActionBase {
        public RefreshMatViewAction() {
            super(DatabaseBundle.message((String)"action.DatabaseView.Tools.RefreshMatViewAction.title", (Object[])new Object[0]), DatabaseBundle.message((String)"action.DatabaseView.Tools.RefreshMatViewAction.text", (Object[])new Object[0]), DatabaseBundle.message((String)"action.DatabaseView.Tools.RefreshMatViewAction.description", (Object[])new Object[0]), AllIcons.Actions.ForceRefresh);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.REFRESH;
            if (scriptCategory == null) {
                RefreshMatViewAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$RefreshMatViewAction", "getCategory"));
        }
    }

    public static class TruncateTablesAction
    extends ScriptingActionBase {
        public TruncateTablesAction() {
            super(DatabaseBundle.message((String)"action.DatabaseView.Tools.TruncateTableAction.title", (Object[])new Object[0]), DatabaseBundle.message((String)"action.DatabaseView.Tools.TruncateTableAction.text", (Object[])new Object[0]), DatabaseBundle.message((String)"action.DatabaseView.Tools.TruncateTableAction.description", (Object[])new Object[0]), AllIcons.Actions.GC);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.TRUNCATE;
            if (scriptCategory == null) {
                TruncateTablesAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "getCategory"));
        }
    }

    public static abstract class ScriptingActionBase
    extends DumbAwareAction {
        private final String myTitle;

        public ScriptingActionBase(@NotNull String title, @Nullable String text2, @Nullable String description, @Nullable Icon icon) {
            if (title == null) {
                ScriptingActionBase.$$$reportNull$$$0(0);
            }
            super(text2, description, icon);
            this.myTitle = title;
        }

        @NotNull
        private JBIterable<DbElement> getSelectedDbElements(@NotNull AnActionEvent e) {
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(1);
            }
            JBIterable res2 = ToolActions.getSelectedElements(e.getDataContext()).flatten(ScriptingActionBase::expandIfNeeded).filter(DbElement.class);
            return this.filterOrExpandElements((JBIterable<DbElement>)res2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(2);
            }
            JBIterable<DbElement> objects2 = this.getSelectedDbElements(e);
            ActionStatus s = ScriptingActionBase.checkApplicabilityStatus(objects2);
            e.getPresentation().setVisible(s.visible);
            e.getPresentation().setEnabled(s.enabled);
        }

        @NotNull
        private static ActionStatus checkApplicabilityStatus(@NotNull JBIterable<DbElement> dbElements) {
            DbElement first2;
            if (dbElements == null) {
                ScriptingActionBase.$$$reportNull$$$0(3);
            }
            if ((first2 = (DbElement)dbElements.first()) == null) {
                ActionStatus actionStatus = ActionStatus.HIDDEN;
                if (actionStatus == null) {
                    ScriptingActionBase.$$$reportNull$$$0(4);
                }
                return actionStatus;
            }
            boolean en = DbImplUtil.canConnectTo(first2) && DbImplUtil.canModify(first2);
            ActionStatus actionStatus = en ? ActionStatus.ENABLED : ActionStatus.DISABLED;
            if (actionStatus == null) {
                ScriptingActionBase.$$$reportNull$$$0(5);
            }
            return actionStatus;
        }

        protected boolean isSupported(@NotNull ScriptGenerator service, @Nullable BasicElement e) {
            if (service == null) {
                ScriptingActionBase.$$$reportNull$$$0(6);
            }
            if (e == null) {
                return false;
            }
            return service.capabilities(e).get(this.getCategory()).get(null);
        }

        @NotNull
        protected abstract ScriptCategory getCategory();

        @NotNull
        private static Iterable<? extends PsiElement> expandIfNeeded(PsiElement x) {
            Set<Object> set = x instanceof DatabaseStructure.FamilyGroup ? ((DatabaseStructure.FamilyGroup)x).iterateChildren() : Collections.singleton(x);
            if (set == null) {
                ScriptingActionBase.$$$reportNull$$$0(7);
            }
            return set;
        }

        @NotNull
        private JBIterable<DbElement> filterOrExpandElements(@NotNull JBIterable<DbElement> dbElements) {
            BasicModel model;
            DbElement first2;
            if (dbElements == null) {
                ScriptingActionBase.$$$reportNull$$$0(8);
            }
            if ((first2 = (DbElement)dbElements.first()) == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(9);
                }
                return jBIterable;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            BasicElement fe = (BasicElement)ObjectUtils.tryCast((Object)first2.getDelegate(), BasicElement.class);
            BasicModel basicModel = model = fe == null ? null : fe.getModel();
            if (model == null || !this.getCategory().getApplicableDbs().value((Object)model.getDbms())) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(10);
                }
                return jBIterable;
            }
            ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            JBIterable dsElements = dbElements.filter(o -> o.getDataSource() == dataSource2).map(DbElement::getDelegate).filter(BasicElement.class);
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicMixinElement::getChildren).withRoots((Iterable)dsElements)).expandAndSkip(o -> !this.isSupported(service, (BasicElement)o))).unique()).bfsTraversal().map(o -> DbImplUtil.findElement(dataSource2, o));
            if (jBIterable == null) {
                ScriptingActionBase.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement first2;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(12);
            }
            if ((first2 = (DbElement)(selection = this.getSelectedDbElements(e)).first()) == null) {
                return;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch(first2)), BasicNamespace.class);
            ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(model, this.getCategory());
            builder.setCurrentNamespace(namespace);
            selection.filterMap(o -> (BasicElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)o), BasicElement.class)).addAllTo(builder.getElements());
            new MyDatabaseScriptDialog(dataSource2, namespace, builder, service).initAndShow();
        }

        protected void fillContext(@NotNull DatabaseRefactoringHandler handler, Collection<BasicElement> elements) {
            if (handler == null) {
                ScriptingActionBase.$$$reportNull$$$0(13);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: 
                case 2: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbElements";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkApplicabilityStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expandIfNeeded";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterOrExpandElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedDbElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "checkApplicabilityStatus";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "filterOrExpandElements";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "fillContext";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyDatabaseScriptDialog
        extends DatabaseScriptDialog {
            private final ScriptingSingleModelTaskBuilder myBuilder;
            private final ScriptGenerator myService;

            public MyDatabaseScriptDialog(DbDataSource dataSource2, BasicNamespace namespace, ScriptingSingleModelTaskBuilder builder, ScriptGenerator service) {
                super(dataSource2.getProject(), dataSource2, ObjectPaths.searchPathOf(namespace), ScriptingActionBase.this.myTitle);
                this.myBuilder = builder;
                this.myService = service;
            }

            @Override
            protected void init() {
                super.init();
                this.generate();
            }

            @Override
            protected ScriptingTask getTask() {
                return this.myBuilder.build();
            }

            @Override
            protected void settingsChanged(ScriptingOptions options) {
                this.myBuilder.setOptions(options);
                this.generate();
            }

            @Override
            protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
                if (handler == null) {
                    MyDatabaseScriptDialog.$$$reportNull$$$0(0);
                }
                Collection<BasicElement> elements = this.myBuilder.getElements();
                ScriptingActionBase.this.fillContext(handler, elements);
            }

            private void generate() {
                ScriptingResult script = this.myService.makeScript(this.myProject, this.getTask());
                this.updateText(script);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/ToolActions$ScriptingActionBase$MyDatabaseScriptDialog", "fillContext"));
            }
        }
    }
}

