/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JdbcDriverManager
extends SimpleModificationTracker {
    public static JdbcDriverManager getDriverManager(Project project) {
        return (JdbcDriverManager)((Object)ServiceManager.getService((Project)project, JdbcDriverManager.class));
    }

    public abstract Project getProject();

    public abstract ModificationTracker getModificationTracker();

    @NotNull
    public abstract ConsoleRunConfiguration getDefaultRunConfiguration(@NotNull LocalDataSource var1, @Nullable DatabaseCredentials var2);

    public abstract List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull LocalDataSource var1);

    public abstract RemoteDriver getDriver(@NotNull LocalDataSource var1, @NotNull ConsoleRunConfiguration var2) throws Exception;

    public abstract Future<?> releaseDriver(@NotNull LocalDataSource var1, @Nullable ConsoleRunConfiguration var2);

    public abstract void addModificationTrackerListener(ModificationTrackerListener<JdbcDriverManager> var1, Disposable var2);

    @Nullable
    public abstract Integer getLocalPort(@NotNull LocalDataSource var1);
}

