/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.DatabaseAccessController;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleGridDataHookUp
extends DatabaseGridDataHookUp
implements JdbcConsole.SearchPathReceiver,
DataRequest.CrossSessionOwner {
    private static final Logger LOG = Logger.getInstance(ConsoleGridDataHookUp.class);
    private volatile AtomicReference<SearchPath> mySearchPath;
    private volatile DatabaseAccessController myController;
    private volatile DataRequest.OwnerEx myParent;
    private volatile boolean myValid;
    private volatile MyPathAuditor myPathAuditor;
    private volatile Disposable myTxParent;

    ConsoleGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @NotNull JdbcConsole.SearchPathSender sender, @Nullable DataRequest.OwnerEx parent2) {
        if (project == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (department == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (sender == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(3);
        }
        super(project, session2, department);
        this.myParent = parent2;
        this.updateTxParent();
        this.updatePathAuditor(session2);
        sender.subscribe(this);
        this.createController(session2);
    }

    @Override
    @NotNull
    public Disposable getTxDisposable() {
        Disposable disposable2 = this.myTxParent;
        if (disposable2 == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(4);
        }
        return disposable2;
    }

    @Override
    @NotNull
    public DataRequest.Owner getParentOwner() {
        DatabaseSession databaseSession = this.getSession();
        if (databaseSession == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(5);
        }
        return databaseSession;
    }

    @Override
    public boolean isChildOf(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(6);
        }
        return this.myParent != null && this.myParent.isChildOf(owner) || super.isChildOf(owner);
    }

    @Override
    @NotNull
    protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
        return new MyLoader();
    }

    public void setParent(@Nullable DataRequest.OwnerEx parent2) {
        this.myParent = parent2;
        if (parent2 instanceof JdbcConsole) {
            ((JdbcConsole)parent2).addSearchPathReceiver(this, this);
        }
    }

    @Override
    public void setSession(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(7);
        }
        super.setSession(session2);
        Disposer.dispose((Disposable)this.myPathAuditor);
        this.updatePathAuditor(session2);
        this.updateTxParent();
        this.createController(session2);
    }

    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public void receive(@Nullable SearchPath path) {
        this.validate(path, false);
    }

    @Override
    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath == null ? null : this.mySearchPath.get();
    }

    @Override
    @NotNull
    protected DataAuditor createAuditor() {
        return new MyBusAuditor();
    }

    private void updatePathAuditor(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(8);
        }
        this.myPathAuditor = new MyPathAuditor();
        Disposer.register((Disposable)this, (Disposable)this.myPathAuditor);
        session2.getMessageBus().addAuditor(this.myPathAuditor);
    }

    private void createController(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(9);
        }
        this.myController = new DatabaseAccessController.PsiBasedReadOnly(this.getProject(), DbSqlUtil.getSqlDialect((LocalDataSource)session2.getTarget()), this.getDataSource(), () -> this.mySearchPath.get());
    }

    private void validate(@Nullable SearchPath path, boolean supportSavepoints) {
        this.myValid = this.isStateValid(path, supportSavepoints);
    }

    private boolean isStateValid(@Nullable SearchPath path, boolean supportsSavepoints) {
        ObjectPath needed;
        ObjectPath current;
        boolean readOnly;
        if (this.mySearchPath == null) {
            LOG.debug("My search path reference is null");
            return false;
        }
        if (Comparing.equal((Object)this.mySearchPath.get(), (Object)path)) {
            return true;
        }
        if (this.mySearchPath.get() == null || path == null) {
            LOG.debug(this.mySearchPath.get() == null ? "My path is null" : "Current path is null");
            return false;
        }
        DbDataSource dbDataSource = this.getDataSource();
        if (!(dbDataSource.getDelegate() instanceof DatabaseConnectionPoint)) {
            LOG.debug("Delegate is not instance of connection point: " + dbDataSource.getDelegate().getClass().getName());
            return false;
        }
        DatabaseConnectionPoint point = (DatabaseConnectionPoint)dbDataSource.getDelegate();
        DatabaseDriver driver = point.getDatabaseDriver();
        if (JdbcUrlParserUtil.outOfBounds(driver, readOnly = point.isReadOnly(), current = path.getCurrent(), needed = this.mySearchPath.get().getCurrent())) {
            LOG.debug("Database changed");
            return false;
        }
        DataRequest.TxMarker tx = this.getCurrentTx();
        return supportsSavepoints || !tx.isTransactionInProgress();
    }

    private void updateTxParent() {
        if (this.myTxParent != null) {
            Disposer.dispose((Disposable)this.myTxParent);
        }
        this.myTxParent = Disposer.newDisposable();
        Disposer.register((Disposable)this, (Disposable)this.myTxParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/ConsoleGridDataHookUp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/ConsoleGridDataHookUp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTxDisposable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isChildOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePathAuditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createController";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyBusAuditor
    extends DataBusGridDataHookUp.BusAuditor {
        private MyBusAuditor() {
            super(ConsoleGridDataHookUp.this);
        }

        @Override
        protected boolean reloadOnRollback() {
            DbDataSource source = ConsoleGridDataHookUp.this.getDataSource();
            if (!source.isWritable()) {
                return true;
            }
            String query = ConsoleGridDataHookUp.this.getQueryText();
            return StringUtil.isEmptyOrSpaces((String)query) || ((ConsoleGridDataHookUp)ConsoleGridDataHookUp.this).myController.requestAccess((String)query).success;
        }
    }

    private class MyPathAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private MyPathAuditor() {
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyPathAuditor.$$$reportNull$$$0(0);
            }
            Boolean supportSavepoints = (Boolean)JdbcEngine.SUPPORTS_SAVEPOINTS_KEY.get((UserDataHolder)context);
            ConsoleGridDataHookUp.this.validate(context.getSearchPath(), supportSavepoints != null && supportSavepoints != false);
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/ConsoleGridDataHookUp$MyPathAuditor", "requestFinished"));
        }
    }

    private class MyLoader
    extends DatabaseGridDataHookUp.DatabaseLoader {
        private MyLoader() {
            super(ConsoleGridDataHookUp.this);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                MyLoader.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                MyLoader.$$$reportNull$$$0(1);
            }
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
            ConsoleGridDataHookUp.this.mySearchPath = new AtomicReference<SearchPath>(context.getSearchPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columns";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/ConsoleGridDataHookUp$MyLoader";
            objectArray[2] = "setColumns";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

