/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GeoViewer;
import com.intellij.database.datagrid.GeoViewer$sam$java_lang_Runnable$0;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.dbimport.ObjectToTextConverter;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.Version;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0006\u0010\u0017\u001a\u00020\rJR\u0010\u0018\u001a\u00020\u00142\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\u0002\b\u00072\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001e2\u0017\u0010\u001f\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001e0 \u00a2\u0006\u0002\b\u00072\u0006\u0010!\u001a\u00020\"H\u0002J\r\u0010#\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0007H\u0002J\b\u0010$\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J&\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0014\u0010+\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00110,H\u0002J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0014H\u0002JG\u0010/\u001a\t\u0018\u000100\u00a2\u0006\u0002\b12\u0006\u0010!\u001a\u00020\"2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eH\u0002J\b\u00103\u001a\u00020\u0011H\u0002J\b\u00104\u001a\u00020\u0011H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/datagrid/GeoViewer;", "Lcom/intellij/openapi/Disposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "alarm", "Lcom/intellij/util/Alarm;", "bro", "Lcom/intellij/ui/jcef/JBCefBrowser;", "panel", "Ljavax/swing/JComponent;", "selecting", "Ljava/util/concurrent/atomic/AtomicInteger;", "dispose", "", "exec", "js", "", "getComponent", "getDefaultLayer", "getPreferableFocusComponent", "getRowData", "data", "Lcom/intellij/database/datagrid/GridModel;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "rIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "geoCols", "", "cvt", "Lcom/intellij/database/dbimport/ObjectToTextConverter;", "getStoredLayer", "loadViewer", "scheduleMapUpdate", "selectInTable", "idx", "", "simpleInject", "name", "action", "Lkotlin/Function1;", "str", "s", "strData", "", "Lorg/jetbrains/annotations/Nullable;", "cIdx", "updateMap", "updateSelection", "Companion", "intellij.database.impl"})
public final class GeoViewer
implements Disposable {
    private final Logger LOG;
    private final JBCefBrowser bro;
    private final JComponent panel;
    private final Alarm alarm;
    private final AtomicInteger selecting;
    private final DataGrid grid;
    private static final String GEO_VIEWER;
    private static final Regex LON_PATTERN;
    private static final Regex LAT_PATTERN;
    public static final Companion Companion;

    private final void loadViewer() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("resources/geo-viewer.html");
            if (inputStream == null) {
                throw (Throwable)((Object)new AssertionError((Object)"No geo-viewer"));
            }
            InputStream stream = inputStream;
            String string = FileUtil.loadTextAndClose((InputStream)stream);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.loadTextAndClose(stream)");
            CharSequence charSequence = string;
            Regex regex = new Regex("(?<=let defaultLayer = )null");
            String string2 = this.str(this.getStoredLayer());
            JBCefBrowser jBCefBrowser = this.bro;
            boolean bl = false;
            String string3 = regex.replace(charSequence, string2);
            jBCefBrowser.loadHTML(string3);
        }
        catch (Exception e) {
            this.bro.loadHTML("<html><body><h1>fail:" + e.getMessage() + "</h1></body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void selectInTable(int idx) {
        if (idx == -1) {
            return;
        }
        this.selecting.incrementAndGet();
        try {
            this.grid.getSelectionModel().setRowSelection(ModelIndex.forRow(this.grid, idx), true);
        }
        finally {
            this.selecting.decrementAndGet();
        }
    }

    private final String simpleInject(String name, Function1<? super String, Unit> action2) {
        JBCefJSQuery handler = JBCefJSQuery.create((JBCefBrowser)this.bro);
        handler.addHandler((Function)new Function<String, JBCefJSQuery.Response>(action2){
            final /* synthetic */ Function1 $action;

            @Nullable
            public final Void apply(String it2) {
                this.$action.invoke((Object)it2);
                return null;
            }
            {
                this.$action = function1;
            }
        });
        return name + ": function(arg) {" + handler.inject("arg") + '}';
    }

    private final String getDefaultLayer() {
        return "CartoDB." + (UIUtil.isUnderDarcula() ? "DarkMatter" : "Positron");
    }

    private final String getStoredLayer() {
        String string = PropertiesComponent.getInstance().getValue("GeoViewer.layer", this.getDefaultLayer());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PropertiesComponent.getI\u2026ayer\", getDefaultLayer())");
        return string;
    }

    private final void scheduleMapUpdate() {
        this.alarm.cancelAllRequests();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                GeoViewer.access$updateMap((GeoViewer)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GeoViewer.class);
            }

            public final String getName() {
                return "updateMap";
            }

            public final String getSignature() {
                return "updateMap()V";
            }
        };
        this.alarm.addRequest((Runnable)new GeoViewer$sam$java_lang_Runnable$0(function0), 300);
    }

    private final void exec(@Language(value="JavaScript") String js) {
        this.bro.getCefBrowser().executeJavaScript(js, this.getClass().getName(), 0);
    }

    private final void updateSelection() {
        StringBuilder stringBuilder = new StringBuilder().append("selectFeaturesFromTable([");
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull(selectionModel, (String)"grid.selectionModel");
        JBIterable jBIterable = selectionModel.getSelectedRows().asIterable();
        Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"grid.selectionModel.selectedRows.asIterable()");
        this.exec(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable), null, null, null, (int)0, null, (Function1)updateSelection.1.INSTANCE, (int)31, null)).append("])").toString());
    }

    private final void updateMap() {
        this.exec("clearFeatures()");
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.grid.getDataModel(DataAccessType.DATABASE_DATA);
        Intrinsics.checkExpressionValueIsNotNull(gridModel, (String)"grid.getDataModel(DataAccessType.DATABASE_DATA)");
        GridModel<DataConsumer.Row, DataConsumer.Column> data = gridModel;
        Dbms dbms = DataGridUtil.getDbms(this.grid);
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"DataGridUtil.getDbms(grid)");
        Dbms dbms2 = dbms;
        GeoHelper helper = (GeoHelper)GeoHelper.EP.forDbms(dbms2);
        ObjectToTextConverter cvt = new ObjectToTextConverter(dbms2);
        JBIterable jBIterable = Companion.collectGeoColumns(this.grid).collect();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"collectGeoColumns(grid).collect()");
        JBIterable geoCols = jBIterable;
        JBIterable jBIterable2 = Companion.collectCoordinateColumns(this.grid).collect();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"collectCoordinateColumns(grid).collect()");
        JBIterable coordCols = jBIterable2;
        Set set = geoCols.append((Iterable)coordCols.flatten((com.intellij.util.Function)updateMap.excludeFromData.1.INSTANCE)).toSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"geoCols.append(coordCols\u2026st, it.second) }).toSet()");
        Set excludeFromData2 = set;
        Collection collection = excludeFromData2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (ModelIndex rIdx : this.grid.getVisibleRows().asIterable()) {
                String rowData2 = this.getRowData(data, rIdx, excludeFromData2, cvt);
                for (ModelIndex cIdx : geoCols) {
                    String string;
                    DataConsumer.Column column;
                    if (data.getColumn(cIdx) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)column, (String)"data.getColumn(cIdx) ?: continue");
                    boolean geoColumn = helper.isGeoType(column.typeName);
                    Object cellVal = data.getValueAt(rIdx, cIdx);
                    if (geoColumn) {
                        GeoHelper geoHelper = helper;
                        Intrinsics.checkExpressionValueIsNotNull((Object)geoHelper, (String)"helper");
                        string = GeoViewer.Companion.toWkt(cellVal, geoHelper);
                    } else {
                        Object object = cvt.convert(cellVal, column);
                        string = object != null ? object.toString() : null;
                    }
                    if (string == null) continue;
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String wkt = string2;
                    boolean bl4 = false;
                    this.exec("addWktFeature(" + this.str(wkt) + ", " + rIdx.value + ", [" + rowData2 + "])");
                }
                for (Couple coords : Companion.collectCoordinateColumns(this.grid)) {
                    Object lat;
                    Object lon;
                    ModelIndex modelIndex = rIdx;
                    Intrinsics.checkExpressionValueIsNotNull((Object)modelIndex, (String)"rIdx");
                    Object object = coords.first;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"coords.first");
                    if (this.strData(cvt, data, modelIndex, (ModelIndex)object) == null) {
                        continue;
                    }
                    Object object2 = coords.second;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"coords.second");
                    if (this.strData(cvt, data, rIdx, (ModelIndex)object2) == null) {
                        continue;
                    }
                    this.exec("addWktFeature(" + this.str("POINT (" + lon + ' ' + lat + ')') + ", " + rIdx.value + ", [" + rowData2 + "])");
                }
            }
        }
        this.updateSelection();
    }

    private final Object strData(ObjectToTextConverter cvt, GridModel<DataConsumer.Row, DataConsumer.Column> data, ModelIndex<DataConsumer.Row> rIdx, ModelIndex<DataConsumer.Column> cIdx) {
        Object object;
        DataConsumer.Column column = data.getColumn(cIdx);
        if (column != null) {
            DataConsumer.Column column2 = column;
            boolean bl = false;
            boolean bl2 = false;
            DataConsumer.Column it2 = column2;
            boolean bl3 = false;
            object = cvt.convert(data.getValueAt(rIdx, cIdx), it2);
        } else {
            object = null;
        }
        return object;
    }

    private final String getRowData(GridModel<DataConsumer.Row, DataConsumer.Column> data, ModelIndex<DataConsumer.Row> rIdx, Set<? extends ModelIndex<DataConsumer.Column>> geoCols, ObjectToTextConverter cvt) {
        JBIterable jBIterable = this.grid.getVisibleColumns().asIterable().filter((Condition)new Condition<ModelIndex<DataConsumer.Column>>(geoCols){
            final /* synthetic */ Set $geoCols;

            public final boolean value(ModelIndex<DataConsumer.Column> it2) {
                return !this.$geoCols.contains(it2);
            }
            {
                this.$geoCols = set;
            }
        }).filterMap(new com.intellij.util.Function<E, T>(data, cvt, rIdx){
            final /* synthetic */ GridModel $data;
            final /* synthetic */ ObjectToTextConverter $cvt;
            final /* synthetic */ ModelIndex $rIdx;

            @Nullable
            public final Pair<String, String> fun(ModelIndex<DataConsumer.Column> it2) {
                Pair pair;
                DataConsumer.Column column = this.$data.getColumn(it2);
                if (column != null) {
                    DataConsumer.Column column2 = column;
                    boolean bl = false;
                    boolean bl2 = false;
                    DataConsumer.Column desc = column2;
                    boolean bl3 = false;
                    Object object = this.$cvt.convert(this.$data.getValueAt(this.$rIdx, it2), desc);
                    pair = new Pair((Object)desc.name, (Object)(object != null ? object.toString() : null));
                } else {
                    pair = null;
                }
                return pair;
            }
            {
                this.$data = gridModel;
                this.$cvt = objectToTextConverter;
                this.$rIdx = modelIndex;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"grid.visibleColumns.asIt\u2026toString())\n      }\n    }");
        String rowData2 = CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable), null, null, null, (int)0, null, (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, String>(this){
            final /* synthetic */ GeoViewer this$0;

            @NotNull
            public final String invoke(@Nullable Pair<String, String> it2) {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append('[');
                Object object = it2;
                if (object == null || (object = (String)object.getFirst()) == null) {
                    object = "";
                }
                StringBuilder stringBuilder2 = stringBuilder.append(GeoViewer.access$str(this.this$0, object)).append(", ");
                Object object2 = it2;
                if (object2 != null && (object2 = (String)object2.getSecond()) != null) {
                    Object object3 = object2;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object v = object3;
                    boolean bl3 = false;
                    String string2 = GeoViewer.access$str(this.this$0, v);
                    stringBuilder2 = stringBuilder3;
                    string = string2;
                } else {
                    string = null;
                }
                return stringBuilder2.append(string).append(']').toString();
            }
            {
                this.this$0 = geoViewer;
                super(1);
            }
        }), (int)31, null);
        return rowData2;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public final JComponent getPreferableFocusComponent() {
        return this.panel;
    }

    private final String str(String s) {
        String string = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)s));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.wrapWithDoubl\u2026scapeStringCharacters(s))");
        return string;
    }

    public void dispose() {
    }

    public GeoViewer(@NotNull DataGrid grid) {
        Intrinsics.checkParameterIsNotNull((Object)grid, (String)"grid");
        this.grid = grid;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        this.bro = new JBCefBrowser();
        Alarm alarm2 = AlarmFactory.getInstance().create(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)alarm2, (String)"AlarmFactory.getInstance\u2026ToUse.SWING_THREAD, this)");
        this.alarm = alarm2;
        this.selecting = new AtomicInteger(0);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.bro));
        this.bro.getJBCefClient().addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public boolean onConsoleMessage(@NotNull CefBrowser browser, @NotNull CefSettings.LogSeverity level, @NotNull String message2, @NotNull String source, int line) {
                Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
                Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                LOG.warn(message2);
                return true;
            }
        }, this.bro.getCefBrowser());
        JComponent jComponent = this.bro.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"bro.component");
        this.panel = jComponent;
        this.loadViewer();
        StringBuilder stringBuilder = new StringBuilder().append("\n      window.dg = {\n        ").append(this.simpleInject("selectInTable", (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ GeoViewer this$0;

            public final void invoke(@Nullable String it2) {
                GeoViewer.access$selectInTable(this.this$0, StringUtil.parseInt((String)it2, (int)-1));
            }
            {
                this.this$0 = geoViewer;
                super(1);
            }
        }))).append(",\n        ").append(this.simpleInject("storeLayer", (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ GeoViewer this$0;

            public final void invoke(@Nullable String it2) {
                PropertiesComponent.getInstance().setValue("GeoViewer.layer", it2, GeoViewer.access$getDefaultLayer(this.this$0));
            }
            {
                this.this$0 = geoViewer;
                super(1);
            }
        }))).append(",\n      };\n      document.getElementById(\"mapid\").style[\"background-color\"] = \"");
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        final String injection2 = StringsKt.trimIndent((String)stringBuilder.append(ColorUtil.toHtmlColor((Color)editorColorsScheme.getDefaultBackground())).append("\";\n    ").toString());
        this.bro.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(@NotNull CefBrowser browser, @NotNull CefFrame frame, int httpStatusCode) {
                Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
                Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
                this.exec(injection2);
                this.scheduleMapUpdate();
            }
        }, this.bro.getCefBrowser());
        this.grid.addDataGridListener(new DataGridListener(){

            @Override
            public void onSelectionChanged(@NotNull DataGrid dataGrid) {
                Intrinsics.checkParameterIsNotNull((Object)dataGrid, (String)"dataGrid");
                if (selecting.get() == 0) {
                    this.updateSelection();
                }
            }

            @Override
            public void onContentChanged(@NotNull DataGrid dataGrid) {
                Intrinsics.checkParameterIsNotNull((Object)dataGrid, (String)"dataGrid");
                this.scheduleMapUpdate();
            }
        }, this);
    }

    static {
        Companion = new Companion(null);
        GEO_VIEWER = GeoViewer.class.getSimpleName();
        LON_PATTERN = new Regex(".*(lon(?:g(?:itude)?)?|(?<=\\b|_)x(?=\\b|_)).*", RegexOption.IGNORE_CASE);
        LAT_PATTERN = new Regex(".*(lat(?:itude)?|(?<=\\b|_)y(?=\\b|_)).*", RegexOption.IGNORE_CASE);
    }

    public static final /* synthetic */ void access$updateMap(GeoViewer $this) {
        $this.updateMap();
    }

    public static final /* synthetic */ String access$str(GeoViewer $this, String s) {
        return $this.str(s);
    }

    public static final /* synthetic */ void access$selectInTable(GeoViewer $this, int idx) {
        $this.selectInTable(idx);
    }

    public static final /* synthetic */ String access$getDefaultLayer(GeoViewer $this) {
        return $this.getDefaultLayer();
    }

    @JvmStatic
    public static final void show(@NotNull AnActionEvent e) {
        Companion.show(e);
    }

    @JvmStatic
    @NotNull
    public static final JBIterable<ModelIndex<DataConsumer.Column>> collectGeoColumns(@NotNull DataGrid grid) {
        return Companion.collectGeoColumns(grid);
    }

    @JvmStatic
    @NotNull
    public static final JBIterable<Couple<ModelIndex<DataConsumer.Column>>> collectCoordinateColumns(@NotNull DataGrid grid) {
        return Companion.collectCoordinateColumns(grid);
    }

    @JvmStatic
    private static final boolean isGeoColumn(GeoHelper helper, DomainRegistry registry, ObjectToTextConverter cvt, GridModel<DataConsumer.Row, DataConsumer.Column> data, ModelIndex<DataConsumer.Column> cIdx) {
        return GeoViewer.Companion.isGeoColumn(helper, registry, cvt, data, cIdx);
    }

    @JvmStatic
    private static final boolean isPossiblyWkt(ObjectToTextConverter cvt, GridModel<DataConsumer.Row, DataConsumer.Column> data, ModelIndex<DataConsumer.Column> cIdx) {
        return GeoViewer.Companion.isPossiblyWkt(cvt, data, cIdx);
    }

    @JvmStatic
    @Nullable
    public static final String toWkt(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> cIdx, @NotNull ModelIndex<DataConsumer.Row> rIdx) {
        return Companion.toWkt(grid, cIdx, rIdx);
    }

    @JvmStatic
    private static final String toWkt(Object cellVal, GeoHelper helper) {
        return GeoViewer.Companion.toWkt(cellVal, helper);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\r0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0003J2\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\r0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0003J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J.\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0007J\u001c\u0010$\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0003R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/datagrid/GeoViewer$Companion;", "", "()V", "GEO_VIEWER", "", "kotlin.jvm.PlatformType", "LAT_PATTERN", "Lkotlin/text/Regex;", "LON_PATTERN", "collectCoordinateColumns", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/util/Couple;", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "collectGeoColumns", "getClient", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isGeoColumn", "", "helper", "Lcom/intellij/database/data/types/GeoHelper;", "registry", "Lcom/intellij/database/data/types/DomainRegistry;", "cvt", "Lcom/intellij/database/dbimport/ObjectToTextConverter;", "data", "Lcom/intellij/database/datagrid/GridModel;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "cIdx", "isPossiblyWkt", "show", "", "toWkt", "rIdx", "cellVal", "intellij.database.impl"})
    public static final class Companion {
        @JvmStatic
        public final void show(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
            if (dataGrid == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)dataGrid, (String)"DataGridUtil.getDataGrid(e.dataContext) ?: return");
            DataGrid grid = dataGrid;
            DatabaseSessionClientWithFile databaseSessionClientWithFile = this.getClient(grid, e);
            if (databaseSessionClientWithFile == null) {
                return;
            }
            DatabaseSessionClientWithFile client = databaseSessionClientWithFile;
            DatabaseClientLogView databaseClientLogView = client.getView();
            if (databaseClientLogView == null) {
                return;
            }
            DatabaseClientLogView view2 = databaseClientLogView;
            Content content = view2.getUi().findContent(GEO_VIEWER);
            if (content != null) {
                Content content2 = content;
                boolean bl = false;
                boolean bl2 = false;
                Content content3 = content2;
                boolean bl3 = false;
                view2.getUi().selectAndFocus(content3, false, false);
                return;
            }
            GeoViewer viewer = new GeoViewer(grid);
            Content content4 = view2.getUi().createContent(GEO_VIEWER, viewer.getComponent(), "Geo Viewer", AllIcons.Nodes.PpWeb, viewer.getPreferableFocusComponent());
            Intrinsics.checkExpressionValueIsNotNull((Object)content4, (String)"view.ui.createContent(\n \u2026eferableFocusComponent())");
            Content content5 = content4;
            Disposer.register((Disposable)((Disposable)content5), (Disposable)viewer);
            view2.getUi().addContent(content5, 0, PlaceInGrid.right, false);
            view2.show(true, false);
            view2.getUi().selectAndFocus(content5, false, false);
        }

        private final DatabaseSessionClientWithFile getClient(DataGrid grid, AnActionEvent e) {
            DataGridSessionClient dataGridSessionClient = DataGridUtil.getDataGridClient(grid);
            return dataGridSessionClient != null ? (DatabaseSessionClientWithFile)dataGridSessionClient : (DatabaseSessionClientWithFile)JdbcConsole.findConsole(e);
        }

        @JvmStatic
        @NotNull
        public final JBIterable<ModelIndex<DataConsumer.Column>> collectGeoColumns(@NotNull DataGrid grid) {
            Intrinsics.checkParameterIsNotNull((Object)grid, (String)"grid");
            GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
            Intrinsics.checkExpressionValueIsNotNull(gridModel, (String)"grid.getDataModel(DataAccessType.DATABASE_DATA)");
            GridModel data = gridModel;
            Dbms dbms = DataGridUtil.getDbms(grid);
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"DataGridUtil.getDbms(grid)");
            Dbms dbms2 = dbms;
            DbDataSource dbDataSource = DataGridUtil.getDatabaseSystem(grid);
            Intrinsics.checkExpressionValueIsNotNull((Object)dbDataSource, (String)"DataGridUtil.getDatabaseSystem(grid)");
            Version version = dbDataSource.getVersion();
            DomainRegistry registry = DomainRegistry.get(dbms2, version);
            ObjectToTextConverter cvt = new ObjectToTextConverter(dbms2);
            GeoHelper helper = (GeoHelper)GeoHelper.EP.forDbms(dbms2);
            JBIterable jBIterable = grid.getVisibleColumns().asIterable().filter((Condition)new Condition<ModelIndex<DataConsumer.Column>>(helper, registry, cvt, data){
                final /* synthetic */ GeoHelper $helper;
                final /* synthetic */ DomainRegistry $registry;
                final /* synthetic */ ObjectToTextConverter $cvt;
                final /* synthetic */ GridModel $data;

                public final boolean value(ModelIndex<DataConsumer.Column> cIdx) {
                    GeoHelper geoHelper = this.$helper;
                    Intrinsics.checkExpressionValueIsNotNull((Object)geoHelper, (String)"helper");
                    ModelIndex<DataConsumer.Column> modelIndex = cIdx;
                    Intrinsics.checkExpressionValueIsNotNull(modelIndex, (String)"cIdx");
                    return com.intellij.database.datagrid.GeoViewer$Companion.access$isGeoColumn(GeoViewer.Companion, geoHelper, this.$registry, this.$cvt, this.$data, modelIndex);
                }
                {
                    this.$helper = geoHelper;
                    this.$registry = domainRegistry;
                    this.$cvt = objectToTextConverter;
                    this.$data = gridModel;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"grid.visibleColumns.asIt\u2026 cvt, data, cIdx)\n      }");
            return jBIterable;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final JBIterable<Couple<ModelIndex<DataConsumer.Column>>> collectCoordinateColumns(@NotNull DataGrid grid) {
            Intrinsics.checkParameterIsNotNull((Object)grid, (String)"grid");
            GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
            Intrinsics.checkExpressionValueIsNotNull(gridModel, (String)"grid.getDataModel(DataAccessType.DATABASE_DATA)");
            GridModel data = gridModel;
            LinkedHashMap pairs = new LinkedHashMap();
            for (ModelIndex idx : grid.getVisibleColumns().asIterable()) {
                Object object;
                Object object2;
                block15: {
                    block14: {
                        void mr;
                        Pair pair;
                        MatchResult it2;
                        MatchResult matchResult;
                        boolean bl;
                        boolean bl2;
                        DataConsumer.Column column;
                        if ((DataConsumer.Column)data.getColumn(idx) == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)column, (String)"data.getColumn(idx) ?: continue");
                        Regex regex = LON_PATTERN;
                        String string = column.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"column.name");
                        if (regex.matchEntire((CharSequence)string) != null) {
                            bl2 = false;
                            bl = false;
                            it2 = matchResult;
                            boolean bl3 = false;
                            pair = new Pair((Object)it2, (Object)true);
                        } else {
                            Regex regex2 = LAT_PATTERN;
                            String string2 = column.name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"column.name");
                            if (regex2.matchEntire((CharSequence)string2) != null) {
                                bl2 = false;
                                boolean bl4 = false;
                                it2 = matchResult;
                                boolean bl5 = false;
                                pair = new Pair((Object)it2, (Object)false);
                            } else {
                                pair = null;
                            }
                        }
                        if (pair == null) {
                            continue;
                        }
                        Pair pair2 = pair;
                        MatchResult matchResult2 = (MatchResult)pair2.component1();
                        boolean lon = (Boolean)pair2.component2();
                        object2 = mr.getGroups().get(1);
                        if (object2 == null || (object2 = object2.getRange()) == null) break block14;
                        matchResult = object2;
                        bl2 = false;
                        bl = false;
                        it2 = matchResult;
                        boolean bl6 = false;
                        String string3 = column.name;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        String $this$run = string3;
                        boolean bl9 = false;
                        String string4 = $this$run;
                        int n = 0;
                        int n2 = it2.getFirst();
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl10 = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(n, n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string7 = string6;
                        string4 = $this$run;
                        n = it2.getLast() + 1;
                        stringBuilder = stringBuilder.append(string7);
                        n2 = 0;
                        String string8 = string4;
                        if (string8 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string9 = string8.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                        string7 = string9;
                        String string10 = stringBuilder.append(string7).toString();
                        object2 = string10;
                        if (string10 != null) break block15;
                    }
                    object2 = "coords";
                }
                Object group = object2;
                Map $this$getOrPut$iv = pairs;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(group);
                if (value$iv == null) {
                    boolean bl = false;
                    ModelIndex[] answer$iv = new ModelIndex[2];
                    $this$getOrPut$iv.put(group, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((ModelIndex[])object)[lon ? 0 : 1] = idx;
            }
            JBIterable jBIterable = JBIterable.from((Iterable)pairs.values()).filterMap((com.intellij.util.Function)collectCoordinateColumns.4.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(pairs.va\u2026Couple.of(lon, lat) } } }");
            return jBIterable;
        }

        @JvmStatic
        private final boolean isGeoColumn(GeoHelper helper, DomainRegistry registry, ObjectToTextConverter cvt, GridModel<DataConsumer.Row, DataConsumer.Column> data, ModelIndex<DataConsumer.Column> cIdx) {
            DataConsumer.Column column = data.getColumn(cIdx);
            if (column != null) {
                Domain domain;
                DataConsumer.Column column2 = column;
                boolean bl = false;
                boolean bl2 = false;
                DataConsumer.Column col = column2;
                boolean bl3 = false;
                if (helper.isGeoType(col.getTypeName())) {
                    return true;
                }
                DomainRegistry domainRegistry = registry;
                Domain domain2 = domain = domainRegistry != null ? domainRegistry.getDomain(col) : null;
                if (domain instanceof TextDomain) {
                    return Companion.isPossiblyWkt(cvt, data, cIdx);
                }
            }
            return false;
        }

        @JvmStatic
        private final boolean isPossiblyWkt(ObjectToTextConverter cvt, GridModel<DataConsumer.Row, DataConsumer.Column> data, ModelIndex<DataConsumer.Column> cIdx) {
            Regex checker = new Regex("^(?:SRID\\s*=\\s*\\d+\\s*;\\s*)?(?:EMPTY|(?:POINT|LINESTRING|LINEARRING|POLYGON|MULTIPOINT|MULTILINESTRING|MULTIPOLYGON|GEOMETRYCOLLECTION)Z?M?\\s*\\()");
            DataConsumer.Column column = data.getColumn(cIdx);
            if (column == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)column, (String)"data.getColumn(cIdx) ?: return false");
            DataConsumer.Column col = column;
            Object object = data.getRowIndices().asIterable().filter((Condition)isPossiblyWkt.value.1.INSTANCE).filterMap(new com.intellij.util.Function<E, T>(cvt, data, cIdx, col){
                final /* synthetic */ ObjectToTextConverter $cvt;
                final /* synthetic */ GridModel $data;
                final /* synthetic */ ModelIndex $cIdx;
                final /* synthetic */ DataConsumer.Column $col;

                @Nullable
                public final Object fun(ModelIndex<DataConsumer.Row> it2) {
                    return this.$cvt.convert(this.$data.getValueAt(it2, this.$cIdx), this.$col);
                }
                {
                    this.$cvt = objectToTextConverter;
                    this.$data = gridModel;
                    this.$cIdx = modelIndex;
                    this.$col = column;
                }
            }).first();
            if (object == null || (object = object.toString()) == null) {
                return false;
            }
            Object value2 = object;
            return Regex.find$default((Regex)checker, (CharSequence)((CharSequence)value2), (int)0, (int)2, null) != null;
        }

        @JvmStatic
        @Nullable
        public final String toWkt(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> cIdx, @NotNull ModelIndex<DataConsumer.Row> rIdx) {
            Intrinsics.checkParameterIsNotNull((Object)grid, (String)"grid");
            Intrinsics.checkParameterIsNotNull(cIdx, (String)"cIdx");
            Intrinsics.checkParameterIsNotNull(rIdx, (String)"rIdx");
            Dbms dbms = DataGridUtil.getDbms(grid);
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"DataGridUtil.getDbms(grid)");
            Dbms dbms2 = dbms;
            Object cellVal = grid.getDataModel(DataAccessType.DATABASE_DATA).getValueAt(rIdx, cIdx);
            Object object = GeoHelper.EP.forDbms(dbms2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GeoHelper.EP.forDbms(dbms)");
            return this.toWkt(cellVal, (GeoHelper)object);
        }

        @JvmStatic
        private final String toWkt(Object cellVal, GeoHelper helper) {
            Object object = cellVal;
            return object == null ? null : (object instanceof ObjectFormatter.TextInfo ? this.toWkt(((ObjectFormatter.TextInfo)cellVal).text, helper) : (object instanceof LobInfo.ClobInfo ? (((LobInfo.ClobInfo)cellVal).isTruncated() ? null : this.toWkt(((LobInfo.ClobInfo)cellVal).data, helper)) : (object instanceof LobInfo.BlobInfo ? (((LobInfo.BlobInfo)cellVal).isTruncated() ? null : this.toWkt(((LobInfo.BlobInfo)cellVal).data, helper)) : helper.extractGeometryAsWkt(cellVal))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

