/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.plan;

import com.intellij.database.diagram.plan.QueryPlanField;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredText;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryPlanElementManager
extends AbstractDiagramElementManager<PlanModel.GenericNode> {
    @Nullable
    public PlanModel.GenericNode findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            QueryPlanElementManager.$$$reportNull$$$0(0);
        }
        return PlanView.contextPlanNode(context);
    }

    @NotNull
    public Collection<PlanModel.GenericNode> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            QueryPlanElementManager.$$$reportNull$$$0(1);
        }
        List<PlanModel.GenericNode> list = Collections.emptyList();
        if (list == null) {
            QueryPlanElementManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isAcceptableAsNode(Object element2) {
        return QueryPlanElementManager.isAcceptedAsNodeImpl(element2);
    }

    public static boolean isAcceptedAsNodeImpl(Object element2) {
        return element2 instanceof PlanModel.GenericNode;
    }

    public Object @NotNull [] getNodeItems(@NotNull PlanModel.GenericNode node) {
        String index2;
        if (node == null) {
            QueryPlanElementManager.$$$reportNull$$$0(3);
        }
        ArrayList<QueryPlanField> items = new ArrayList<QueryPlanField>();
        if (node instanceof PlanModel.IndexScanNode && (index2 = ((PlanModel.IndexScanNode)node).getIndex()) != null) {
            items.add(new QueryPlanField(node, "Index", index2, DatabaseIcons.Index));
        }
        QueryPlanElementManager.addIfNotNull(node, items, node.getPlanNumRows(), "Rows", DatabaseIcons.SqlOtherStatement);
        QueryPlanElementManager.addIfNotNull(node, items, node.getActualNumRows(), "Actual Rows", DatabaseIcons.SqlOtherStatement);
        QueryPlanElementManager.addRangeIfNotNull(node, items, node.getStartupCost(), node.getTotalCost(), "Cost", DatabaseIcons.Dbms);
        QueryPlanElementManager.addRangeIfNotNull(node, items, node.getActualStartupTime(), node.getActualTotalTime(), "Actual Time", DatabaseIcons.Dbms);
        Object[] objectArray = items.toArray();
        if (objectArray == null) {
            QueryPlanElementManager.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static void addRangeIfNotNull(@NotNull PlanModel.GenericNode node, List<QueryPlanField> items, Double startup, Double total, String title, Icon icon) {
        if (node == null) {
            QueryPlanElementManager.$$$reportNull$$$0(5);
        }
        if (startup != null || total != null) {
            items.add(new QueryPlanField(node, title, (startup == null ? "" : startup.toString()) + ".." + (total == null ? "" : total.toString()), icon));
        }
    }

    private static void addIfNotNull(PlanModel.GenericNode node, List<QueryPlanField> items, Object val, String rows3, Icon icon) {
        if (val != null) {
            items.add(new QueryPlanField(node, rows3, val.toString(), icon));
        }
    }

    public Icon getItemIcon(Object element2, DiagramState presentation) {
        return element2 instanceof QueryPlanField ? ((QueryPlanField)element2).icon : super.getItemIcon(element2, presentation);
    }

    public boolean canCollapse(PlanModel.GenericNode element2) {
        return false;
    }

    public boolean isContainerFor(PlanModel.GenericNode parent2, PlanModel.GenericNode child) {
        return false;
    }

    public String getElementTitle(PlanModel.GenericNode element2) {
        return element2.getFullTitle();
    }

    public SimpleColoredText getItemName(Object element2, DiagramState presentation) {
        if (element2 instanceof PlanModel.GenericNode) {
            return new SimpleColoredText(((PlanModel.GenericNode)element2).getFullTitle(), DEFAULT_TITLE_ATTR);
        }
        if (element2 instanceof QueryPlanField) {
            return new SimpleColoredText(((QueryPlanField)element2).title, DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    public SimpleColoredText getItemType(Object element2) {
        if (element2 instanceof QueryPlanField) {
            String typeName = ((QueryPlanField)element2).value;
            return new SimpleColoredText(StringUtil.toLowerCase((String)typeName), DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    public String getNodeTooltip(PlanModel.GenericNode element2) {
        return element2.getRawDescription();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/plan/QueryPlanElementManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/plan/QueryPlanElementManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRangeIfNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

