/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.diff.GridScrollingModel;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.table.TableResultRowHeader;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.diff.DiffContext;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableDiffEditor
extends TableEditorBase {
    private final DiffTablePanel myDataGrid;
    private final GridScrollingModel myScrollingModel;

    public TableDiffEditor(@NotNull DiffContext context, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (context == null) {
            TableDiffEditor.$$$reportNull$$$0(0);
        }
        if (hookUp == null) {
            TableDiffEditor.$$$reportNull$$$0(1);
        }
        super(context.getProject());
        this.myDataGrid = new DiffTablePanel(this, context, hookUp);
        this.myScrollingModel = new GridScrollingModel(this.getDataGrid());
        Disposer.register((Disposable)this, (Disposable)this.myDataGrid);
    }

    @Override
    @NotNull
    public DiffTablePanel getDataGrid() {
        DiffTablePanel diffTablePanel = this.myDataGrid;
        if (diffTablePanel == null) {
            TableDiffEditor.$$$reportNull$$$0(2);
        }
        return diffTablePanel;
    }

    @NotNull
    public GridScrollingModel getScrollingModel() {
        GridScrollingModel gridScrollingModel = this.myScrollingModel;
        if (gridScrollingModel == null) {
            TableDiffEditor.$$$reportNull$$$0(3);
        }
        return gridScrollingModel;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myDataGrid.getDisplayName();
        if (string == null) {
            TableDiffEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static int[] range(int a, int b2) {
        assert (a < b2);
        int[] res2 = new int[b2 - a];
        for (int i2 = 0; i2 < res2.length; ++i2) {
            res2[i2] = i2 + a;
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/TableDiffEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/TableDiffEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollingModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DiffTablePanel
    extends TableResultPanel {
        public static final Function<ModelIndex<?>, Integer> MI_AS_INT = Index::asInteger;
        private final FileEditor myEditor;
        private final Alarm myAlarm;
        private final List<GridMarkupModel.Highlighting> myHighlightings;
        private final TIntObjectHashMap<InclusionState> myRowsInclusion;
        private final TIntObjectHashMap<InclusionState> myColumnsInclusion;
        private static final AnAction[] ROW_ACTIONS = new AnAction[]{new GenericControlAction("Include selected", true, null, InclusionState.ACTIVE), new GenericControlAction("Exclude selected", true, null, InclusionState.INACTIVE), new GenericControlAction("Remove selected", true, null, InclusionState.REMOVED)};
        private static final AnAction[] COL_ACTIONS = new AnAction[]{new GenericControlAction("Include selected", null, true, InclusionState.ACTIVE), new GenericControlAction("Exclude selected", null, true, InclusionState.INACTIVE), new GenericControlAction("Remove selected", null, true, InclusionState.REMOVED)};
        private static final AnAction[] CROSS_ACTIONS = new AnAction[]{new GenericControlAction("Include selected", true, true, InclusionState.ACTIVE), new GenericControlAction("Exclude unselected", false, false, InclusionState.INACTIVE), new GenericControlAction("Remove unselected", false, false, InclusionState.REMOVED)};

        DiffTablePanel(@NotNull FileEditor editor, @NotNull DiffContext context, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
            if (editor == null) {
                DiffTablePanel.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DiffTablePanel.$$$reportNull$$$0(1);
            }
            if (hookUp == null) {
                DiffTablePanel.$$$reportNull$$$0(2);
            }
            super(Objects.requireNonNull(context.getProject()), hookUp, DiffTablePanel.createTableActionGroup(), DiffTablePanel.createGutterActionGroup(), DiffTablePanel.createHeaderActionGroup(), DiffTablePanel.createHeaderActionGroup(), null, false);
            this.myHighlightings = ContainerUtil.createConcurrentList();
            this.myRowsInclusion = new TIntObjectHashMap();
            this.myColumnsInclusion = new TIntObjectHashMap();
            this.myAlarm = new Alarm((Disposable)this);
            this.myEditor = editor;
            ResultView resultView = this.getResultView();
            if (!(resultView instanceof TableResultView)) {
                return;
            }
            final TableResultView table = (TableResultView)resultView;
            table.getTableHeader().setDefaultRenderer(new TableResultView.MyCellRenderer(table){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.strikeColumn(g, this.getNameRect(), this.getModelIdx());
                }
            });
            table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (myAlarm.cancelAllRequests() != 0) {
                        table.tableChanged(null);
                    }
                }
            });
            table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                    if (e.getFromIndex() == e.getToIndex()) {
                        return;
                    }
                    myAlarm.cancelAllRequests();
                    myAlarm.addRequest(() -> table.tableChanged(null), 1000);
                }

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
        }

        private static Condition<Integer> skip(int[] vals) {
            TIntHashSet skip = new TIntHashSet(vals);
            return integer -> !skip.contains(integer.intValue());
        }

        private JBIterable<Integer> selectedColumns(boolean inverse) {
            if (!inverse) {
                return JBIterable.from(this.getSelectionModel().getSelectedColumns().asIterable()).transform(MI_AS_INT);
            }
            return JBIterable.from(this.getVisibleColumns().asIterable()).transform(MI_AS_INT).filter(DiffTablePanel.skip(this.getSelectionModel().getSelectedColumns().asArray()));
        }

        private JBIterable<Integer> selectedRows(boolean inverse) {
            if (!inverse) {
                return JBIterable.from(this.getSelectionModel().getSelectedRows().asIterable()).transform(MI_AS_INT);
            }
            return JBIterable.from(this.getVisibleRows().asIterable()).transform(MI_AS_INT).filter(DiffTablePanel.skip(this.getSelectionModel().getSelectedRows().asArray()));
        }

        private static ActionGroup createTableActionGroup() {
            DefaultActionGroup row = DefaultActionGroup.createPopupGroup(() -> "Rows");
            row.addAll(ROW_ACTIONS);
            DefaultActionGroup column = DefaultActionGroup.createPopupGroup(() -> "Columns");
            column.addAll(COL_ACTIONS);
            DefaultActionGroup cell = DefaultActionGroup.createPopupGroup(() -> "Cells");
            cell.addAll(CROSS_ACTIONS);
            return new DefaultActionGroup(new AnAction[]{DataGridUtil.getGridPopupActions(), row, column, cell});
        }

        private static ActionGroup createGutterActionGroup() {
            return new DefaultActionGroup(JBIterable.of((Object)DataGridUtil.getGridPopupActions()).append((Object[])ROW_ACTIONS).toList());
        }

        private static ActionGroup createHeaderActionGroup() {
            return new DefaultActionGroup(COL_ACTIONS);
        }

        public int getRowHeight(int row) {
            ResultView resultView = this.getResultView();
            return resultView instanceof TableResultView ? ((TableResultView)resultView).getRowHeight(row) : 0;
        }

        public void clearHighlighting() {
            this.getMarkupModel().removeAllHighlightings(this.myHighlightings);
            this.myHighlightings.clear();
        }

        public void highlightRowsOrCols(TIntArrayList ids, CellAttributesKey cellAttributes, boolean row) {
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                int idx = ids.get(i2);
                this.highlightRowOrCol(idx, idx + 1, cellAttributes, row);
            }
        }

        public void highlightRowOrCol(int begin, int end2, CellAttributesKey cellAttributes, boolean row) {
            if (this.getResultView().isTransposed() == row) {
                this.highlightColumns(begin, end2, cellAttributes);
            } else {
                this.highlightRows(begin, end2, cellAttributes);
            }
        }

        public void highlightRows(int begin, int end2, CellAttributesKey cellAttributes) {
            if (end2 == begin && end2 == 0) {
                return;
            }
            int[] range = TableDiffEditor.range(begin - (begin == end2 ? 1 : 0), end2);
            ModelIndexSet<DataConsumer.Row> rows = ViewIndexSet.forRows(this, range).toModel(this);
            this.myHighlightings.add(this.getMarkupModel().highlightCells(rows, this.getVisibleColumns(), cellAttributes, 1));
            this.myHighlightings.add(this.getMarkupModel().highlightRowHeaders(rows, cellAttributes, 1));
        }

        public void highlightColumns(int begin, int end2, CellAttributesKey cellAttributes) {
            if (end2 == begin && end2 == 0) {
                return;
            }
            ModelIndexSet<DataConsumer.Row> rows = this.getVisibleRows();
            int[] range = TableDiffEditor.range(begin - (begin == end2 ? 1 : 0), end2);
            ModelIndexSet<DataConsumer.Column> cols = ViewIndexSet.forColumns(this, range).toModel(this);
            this.myHighlightings.add(this.getMarkupModel().highlightCells(rows, cols, cellAttributes, 1));
            this.myHighlightings.add(this.getMarkupModel().highlightColumnHeaders(cols, cellAttributes, 1));
        }

        public void highlightCell(int row, int col, CellAttributesKey key) {
            ModelIndexSet<DataConsumer.Row> rows = ViewIndexSet.forRows(this, this.getResultView().isTransposed() ? col : row).toModel(this);
            ModelIndexSet<DataConsumer.Column> cols = ViewIndexSet.forColumns(this, this.getResultView().isTransposed() ? row : col).toModel(this);
            this.myHighlightings.add(this.getMarkupModel().highlightCells(rows, cols, key, 1));
        }

        @NotNull
        public JBIterable<ModelIndex<DataConsumer.Row>> getInactiveRows() {
            JBIterable jBIterable = JBIterable.from(this.getVisibleRows().asList()).filter(index2 -> DiffTablePanel.get(this.myRowsInclusion, index2.asInteger()) == InclusionState.INACTIVE);
            if (jBIterable == null) {
                DiffTablePanel.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @NotNull
        public JBIterable<ModelIndex<DataConsumer.Column>> getInactiveCols() {
            JBIterable jBIterable = JBIterable.from(this.getVisibleColumns().asList()).filter(index2 -> DiffTablePanel.get(this.myColumnsInclusion, index2.asInteger()) == InclusionState.INACTIVE);
            if (jBIterable == null) {
                DiffTablePanel.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public GridRowHeader createRowHeader(@NotNull TableResultView table) {
            if (table == null) {
                DiffTablePanel.$$$reportNull$$$0(5);
            }
            return new TableResultRowHeader(this, table, this.myGutterPopupActions){

                @Override
                @NotNull
                protected TableResultRowHeader.RowHeaderCellComponentBase createRegularRenderer() {
                    return new TableResultRowHeader.RowNumberRowHeaderCellComponent(){

                        @Override
                        protected void drawEffects(Graphics g, Rectangle r) {
                            this.strikeRow(g, r, ViewIndex.forRow(this, this.getRow()).toModel(this).asInteger());
                        }
                    };
                }

                @Override
                @NotNull
                protected TableResultRowHeader.RowHeaderCellComponentBase createTransposedRenderer() {
                    return new TableResultRowHeader.ColumnInfoRowHeaderCellComponent(){

                        @Override
                        protected void drawEffects(Graphics g, Rectangle r) {
                            this.strikeRow(g, r, ViewIndex.forColumn(this, this.getRow()).toModel(this).asInteger());
                        }
                    };
                }
            };
        }

        protected void strikeRow(Graphics g, Rectangle r, int row) {
            InclusionState state = DiffTablePanel.get(this.getResultView().isTransposed() ? this.myColumnsInclusion : this.myRowsInclusion, row);
            if (state == InclusionState.INACTIVE) {
                this.strikeText(g, r);
            }
        }

        protected void strikeColumn(Graphics g, Rectangle r, int col) {
            InclusionState state = DiffTablePanel.get(!this.getResultView().isTransposed() ? this.myColumnsInclusion : this.myRowsInclusion, col);
            if (state == InclusionState.INACTIVE) {
                this.strikeText(g, r);
            }
        }

        protected void strikeText(Graphics g, Rectangle r) {
            int y = r.y + r.height / 2;
            g.drawLine(r.x, y, r.x + r.width, y);
        }

        @Override
        public boolean isRowFilteredOut(@NotNull ModelIndex<?> rowIdx) {
            if (rowIdx == null) {
                DiffTablePanel.$$$reportNull$$$0(6);
            }
            return DiffTablePanel.get(this.myRowsInclusion, rowIdx.asInteger()) == InclusionState.REMOVED;
        }

        @Override
        public boolean isHeaderSelecting() {
            return true;
        }

        public void setState(int modelIdx, boolean row, InclusionState state) {
            DiffTablePanel.set(row ? this.myRowsInclusion : this.myColumnsInclusion, modelIdx, state);
            if (row) {
                if (this.getResultView().isTransposed()) {
                    this.updateRowState(modelIdx, state);
                } else {
                    this.getResultView().searchSessionUpdated();
                }
            } else {
                this.updateColumnState(modelIdx, state);
            }
        }

        public void updateStates() {
            int i2;
            GridModel<DataConsumer.Row, DataConsumer.Column> model = this.getDataModel(DataAccessType.DATABASE_DATA);
            if (this.getResultView().isTransposed()) {
                for (i2 = 0; i2 < model.getRowCount(); ++i2) {
                    this.updateRowState(i2, DiffTablePanel.get(this.myRowsInclusion, i2));
                }
            } else {
                this.getResultView().searchSessionUpdated();
            }
            for (i2 = 0; i2 < model.getColumnCount(); ++i2) {
                this.updateColumnState(i2, DiffTablePanel.get(this.myColumnsInclusion, i2));
            }
        }

        private void updateColumnState(int columnModelIdx, InclusionState state) {
            ModelIndex<DataConsumer.Column> index2 = ModelIndex.forColumn(this, columnModelIdx);
            boolean shouldBeEnabled = state != InclusionState.REMOVED;
            boolean enabled = this.isColumnEnabled(index2);
            if (enabled == shouldBeEnabled) {
                return;
            }
            this.setColumnEnabled(index2, shouldBeEnabled);
        }

        private void updateRowState(int rowModelIndex, InclusionState state) {
            ModelIndex<DataConsumer.Row> modelRow = ModelIndex.forRow(this, rowModelIndex);
            ViewIndex<DataConsumer.Row> viewRow = modelRow.toView(this);
            boolean shouldBeEnabled = state != InclusionState.REMOVED;
            boolean enabled = viewRow.isValid(this);
            if (enabled == shouldBeEnabled) {
                return;
            }
            this.setRowEnabled(modelRow, shouldBeEnabled);
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public boolean isCellEditingAllowed() {
            return false;
        }

        @NotNull
        public Point getCellPosition(int row, int column) {
            ResultView resultView = this.getResultView();
            if (!(resultView instanceof TableResultView)) {
                return new Point();
            }
            TableResultView table = (TableResultView)resultView;
            boolean rowLess = row < table.getRowCount();
            boolean columnLess = column < table.getColumnCount();
            row = Math.min(Math.max(row, 0), table.getRowCount() - 1);
            column = Math.min(Math.max(column, 0), table.getColumnCount() - 1);
            Rectangle cellRect = table.getCellRect(row, column, true);
            return new Point((int)(columnLess ? cellRect.getMinX() : cellRect.getMaxX()), (int)(rowLess ? cellRect.getMinY() : cellRect.getMaxY()));
        }

        public int getRowAtPosition(@NotNull Point position) {
            ResultView resultView;
            if (position == null) {
                DiffTablePanel.$$$reportNull$$$0(7);
            }
            return (resultView = this.getResultView()) instanceof TableResultView ? ((TableResultView)resultView).rowAtPoint(position) : 0;
        }

        public int getColumnAtPosition(@NotNull Point position) {
            ResultView resultView;
            if (position == null) {
                DiffTablePanel.$$$reportNull$$$0(8);
            }
            return (resultView = this.getResultView()) instanceof TableResultView ? ((TableResultView)resultView).columnAtPoint(position) : 0;
        }

        public int getHeaderOffset() {
            ResultView resultView = this.getResultView();
            return resultView instanceof TableResultView ? ((TableResultView)resultView).getTableHeader().getHeight() : 0;
        }

        @Override
        protected Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                DiffTablePanel.$$$reportNull$$$0(9);
            }
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return this.myEditor;
            }
            return super.getData(dataId);
        }

        private static InclusionState get(TIntObjectHashMap<InclusionState> states, int num) {
            return states.contains(num) ? (InclusionState)((Object)states.get(num)) : InclusionState.ACTIVE;
        }

        private static void set(TIntObjectHashMap<InclusionState> states, int num, InclusionState state) {
            if (state == InclusionState.ACTIVE) {
                states.remove(num);
            } else {
                states.put(num, (Object)state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/diff/TableDiffEditor$DiffTablePanel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/diff/TableDiffEditor$DiffTablePanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInactiveRows";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInactiveCols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createRowHeader";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isRowFilteredOut";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getRowAtPosition";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnAtPosition";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class GenericControlAction
        extends AnAction {
            private final Boolean myRowDir;
            private final Boolean myColDir;
            private final InclusionState myState;

            GenericControlAction(@NotNull String name, @Nullable Boolean rowDir, @Nullable Boolean colDir, @NotNull InclusionState state) {
                if (name == null) {
                    GenericControlAction.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    GenericControlAction.$$$reportNull$$$0(1);
                }
                super(name, "", state.toIcon());
                this.myRowDir = rowDir;
                this.myColDir = colDir;
                this.myState = state;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    GenericControlAction.$$$reportNull$$$0(2);
                }
                boolean enabled = false;
                DiffTablePanel panel2 = (DiffTablePanel)ObjectUtils.tryCast((Object)e.getData(DatabaseDataKeys.DATA_GRID_KEY), DiffTablePanel.class);
                if (panel2 != null) {
                    for (Integer row : this.getSelectedRows(panel2)) {
                        if (enabled) break;
                        enabled = DiffTablePanel.get((TIntObjectHashMap<InclusionState>)panel2.myRowsInclusion, row) != this.myState;
                    }
                    for (Integer col : this.getSelectedColumns(panel2)) {
                        if (enabled) break;
                        enabled = DiffTablePanel.get((TIntObjectHashMap<InclusionState>)panel2.myColumnsInclusion, col) != this.myState;
                    }
                }
                e.getPresentation().setEnabledAndVisible(enabled);
            }

            private Iterable<Integer> getSelected(@NotNull DiffTablePanel panel2, boolean row) {
                Boolean colDir;
                if (panel2 == null) {
                    GenericControlAction.$$$reportNull$$$0(3);
                }
                Boolean rowDir = panel2.getResultView().isTransposed() ? this.myColDir : this.myRowDir;
                Boolean bl = colDir = !panel2.getResultView().isTransposed() ? this.myColDir : this.myRowDir;
                if (row && rowDir != null) {
                    return panel2.selectedRows(rowDir == false);
                }
                if (!row && colDir != null) {
                    return panel2.selectedColumns(colDir == false);
                }
                return JBIterable.empty();
            }

            private Iterable<Integer> getSelectedColumns(@NotNull DiffTablePanel panel2) {
                if (panel2 == null) {
                    GenericControlAction.$$$reportNull$$$0(4);
                }
                return this.getSelected(panel2, false);
            }

            private Iterable<Integer> getSelectedRows(@NotNull DiffTablePanel panel2) {
                if (panel2 == null) {
                    GenericControlAction.$$$reportNull$$$0(5);
                }
                return this.getSelected(panel2, true);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DiffTablePanel panel2;
                if (e == null) {
                    GenericControlAction.$$$reportNull$$$0(6);
                }
                if ((panel2 = (DiffTablePanel)ObjectUtils.tryCast((Object)e.getData(DatabaseDataKeys.DATA_GRID_KEY), DiffTablePanel.class)) == null) {
                    return;
                }
                for (int idx : this.getSelectedColumns(panel2)) {
                    panel2.setState(idx, false, this.myState);
                }
                for (int idx : this.getSelectedRows(panel2)) {
                    panel2.setState(idx, true, this.myState);
                }
                ResultView view2 = panel2.getResultView();
                if (view2 instanceof TableResultView) {
                    ((TableResultView)view2).tableChanged(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSelected";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSelectedColumns";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSelectedRows";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static enum InclusionState {
            ACTIVE,
            INACTIVE,
            REMOVED;


            Icon toIcon() {
                if (this == ACTIVE) {
                    return AllIcons.General.Add;
                }
                if (this == INACTIVE) {
                    return AllIcons.General.Remove;
                }
                return AllIcons.Actions.Cancel;
            }
        }
    }
}

