/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpAction {
    private final ExtractionConfig myConfig;

    public DumpAction(@NotNull ExtractionConfig config) {
        if (config == null) {
            DumpAction.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        DumpSource source = DumpAction.getDumpSource(e);
        if (project == null || source == null) {
            return;
        }
        this.actionPerformed(project, source);
    }

    public void actionPerformed(@NotNull Project project, @NotNull DumpSource source) {
        DumpHandler<?> handler;
        if (project == null) {
            DumpAction.$$$reportNull$$$0(2);
        }
        if (source == null) {
            DumpAction.$$$reportNull$$$0(3);
        }
        if ((handler = DumpAction.createHandler(project, source, this.createHelper(), this.myConfig)) == null) {
            return;
        }
        handler.performDump(project);
    }

    @Nullable
    public static DumpHandler<?> createHandler(@NotNull Project project, @NotNull DumpSource source, ExtractionHelper manager, @NotNull ExtractionConfig config) {
        if (project == null) {
            DumpAction.$$$reportNull$$$0(4);
        }
        if (source == null) {
            DumpAction.$$$reportNull$$$0(5);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(6);
        }
        return source instanceof ConsoleSource ? DumpAction.createConsoleHandler((ConsoleSource)source, manager, config) : (source instanceof DataGridSource ? new DumpHandler.GridHandler(project, ((DataGridSource)source).getGrid(), manager, config) : new DumpHandler.DatabaseViewHandler(project, ((DbTablesSource)source).getTables(), manager, config));
    }

    @Nullable
    private static DumpHandler<?> createConsoleHandler(@NotNull ConsoleSource source, @NotNull ExtractionHelper manager, @NotNull ExtractionConfig config) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            DumpAction.$$$reportNull$$$0(8);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(9);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (!source.console.beforeExecuteQueries(source.model)) {
            return null;
        }
        List<String> queries = DumpAction.getQueries(source);
        Project project = source.console.getProject();
        return queries.isEmpty() ? null : new DumpHandler.ConsoleHandler(project, (JBIterable<String>)JBIterable.from(queries), source.console, manager, config);
    }

    @NotNull
    public static List<String> getQueries(@NotNull ConsoleSource source) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(10);
        }
        List list = source.model.statements().transform(it2 -> it2.text(source.console.getPStorage(), Conditions.alwaysFalse())).toList();
        if (list == null) {
            DumpAction.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public static DumpSource getDumpSource(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            DumpAction.$$$reportNull$$$0(12);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() ? new DataGridSource(dataGrid) : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        JdbcConsoleProvider.Info info = QueryActionBase.getInfoClassic(e, DatabaseSettings.getDefaultExecOption());
        if (console != null && info != null) {
            return new ConsoleSource(console, DumpAction.getAdjustedScriptModel(info));
        }
        JBIterable<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<? super DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup && DbImplUtil.isDataTable(((DatabaseStructure.FamilyGroup)((Object)o)).getChildrenKind())));
        JBIterable<DbTable> tables = DumpAction.getTables(elements);
        return tables.isEmpty() ? null : new DbTablesSource(tables);
    }

    @NotNull
    private static ScriptModel<?> getAdjustedScriptModel(@NotNull JdbcConsoleProvider.Info info) {
        if (info == null) {
            DumpAction.$$$reportNull$$$0(13);
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)info.editor, info.execOption);
        TextRange adjusted = ScriptModelUtil.adjustSelectionRange(info.model, (Document)info.editor.getDocument(), range, info.execOption);
        ScriptModel scriptModel = info.model.subModel(adjusted);
        if (scriptModel == null) {
            DumpAction.$$$reportNull$$$0(14);
        }
        return scriptModel;
    }

    @NotNull
    private static JBIterable<DbTable> getTables(@NotNull JBIterable<DbElement> elements) {
        if (elements == null) {
            DumpAction.$$$reportNull$$$0(15);
        }
        Set sources = elements.map(e -> e.getDataSource()).toSet();
        List canConnectSources = ContainerUtil.filter((Collection)sources, DbImplUtil::canConnectTo);
        JBIterable jBIterable = elements.filter(e -> canConnectSources.contains(e.getDataSource())).flatten(r -> ((JBTreeTraverser)((JBTreeTraverser)DbImplUtil.traverseVisibleObjects((DasDataSource)r.getDataSource()).withRoot(r)).expand(Conditions.not((Condition)DasUtil.byClass(DasSchemaChild.class)))).filter(DbTable.class));
        if (jBIterable == null) {
            DumpAction.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    public static int getSize(@Nullable DumpSource object) {
        if (object instanceof ConsoleSource) {
            return ((ConsoleSource)object).model.statements().skip(1).isEmpty() ? 1 : 2;
        }
        if (object instanceof DbTablesSource) {
            return ((DbTablesSource)object).getTables().skip(1).isEmpty() ? 1 : 2;
        }
        return 1;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DumpSource object) {
        if (object instanceof ConsoleSource) {
            Dbms dbms = DbImplUtil.getDbms(((ConsoleSource)object).console);
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(17);
            }
            return dbms;
        }
        if (object instanceof DbTablesSource) {
            Dbms dbms = DbImplUtil.getDbms((DbElement)((DbTablesSource)object).getTables().first());
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(18);
            }
            return dbms;
        }
        if (object instanceof DataGridSource) {
            Dbms dbms = DataGridUtil.getDbms(((DataGridSource)object).myGrid);
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(19);
            }
            return dbms;
        }
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            DumpAction.$$$reportNull$$$0(20);
        }
        return dbms;
    }

    @NotNull
    public abstract ExtractionHelper createHelper();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedScriptModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTables";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDumpSource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedScriptModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DbTablesSource
    implements DumpSource {
        private final JBIterable<DbTable> myTables;

        public DbTablesSource(JBIterable<DbTable> tables) {
            this.myTables = tables;
        }

        @NotNull
        public JBIterable<DbTable> getTables() {
            JBIterable<DbTable> jBIterable = this.myTables;
            if (jBIterable == null) {
                DbTablesSource.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$DbTablesSource", "getTables"));
        }
    }

    public static class DataGridSource
    implements DumpSource {
        private final DataGrid myGrid;

        public DataGridSource(DataGrid grid) {
            this.myGrid = grid;
        }

        @NotNull
        public DataGrid getGrid() {
            DataGrid dataGrid = this.myGrid;
            if (dataGrid == null) {
                DataGridSource.$$$reportNull$$$0(0);
            }
            return dataGrid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$DataGridSource", "getGrid"));
        }
    }

    public static class ConsoleSource
    implements DumpSource {
        final JdbcConsole console;
        final ScriptModel<?> model;

        public ConsoleSource(@NotNull JdbcConsole console, @NotNull ScriptModel<?> model) {
            if (console == null) {
                ConsoleSource.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ConsoleSource.$$$reportNull$$$0(1);
            }
            this.console = console;
            this.model = model;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ConsoleSource";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DumpSource {
    }

    public static class ToFile
    extends DumpAction {
        private final File myFile;

        public ToFile(@NotNull ExtractionConfig config, @NotNull File file) {
            if (config == null) {
                ToFile.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ToFile.$$$reportNull$$$0(1);
            }
            super(config);
            this.myFile = file;
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.FileExtractionHelper(this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ToFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToClipboard
    extends DumpAction {
        public ToClipboard(@NotNull ExtractionConfig config) {
            if (config == null) {
                ToClipboard.$$$reportNull$$$0(0);
            }
            super(config);
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.ClipboardExtractionHelper();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/run/actions/DumpAction$ToClipboard", "<init>"));
        }
    }
}

