/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.actions.PerformActionBase;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecuteRoutineActionBase
extends PerformActionBase {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        ActionData actionData = this.getActionData(e);
        BasicRoutine routine = actionData.routine;
        boolean available = actionData != ActionData.DISABLED && routine != null && this.isAvailable(e, actionData);
        presentation.setEnabledAndVisible(available);
        if (available) {
            this.updateActionText(presentation, this.getTemplatePresentation().getText(), routine);
            Icon icon = this.getIcon(e, routine);
            if (icon != null) {
                presentation.setIcon(icon);
            }
        }
    }

    @Nullable
    protected Icon getIcon(@NotNull AnActionEvent e, @Nullable BasicRoutine routine) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(1);
        }
        return null;
    }

    protected void updateActionText(@NotNull Presentation presentation, @NotNull String template, @Nullable BasicRoutine routine) {
        boolean isFunction;
        if (presentation == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(2);
        }
        if (template == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(3);
        }
        DasRoutine.Kind kind = routine != null ? routine.getRoutineKind() : null;
        boolean isProcedure = kind == DasRoutine.Kind.PROCEDURE;
        boolean bl = isFunction = kind == DasRoutine.Kind.FUNCTION;
        String text2 = isProcedure ? "Procedure" : (isFunction ? "Function" : "Routine");
        presentation.setText(template.replace("Routine", text2));
    }

    @Nullable
    protected static DbRoutine getDbRoutine(@NotNull AnActionEvent e) {
        Set<DbRoutine> elements;
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(4);
        }
        return (elements = DatabaseView.getSelectedElements(e.getDataContext(), DbRoutine.class)).size() == 1 ? (DbRoutine)ContainerUtil.getFirstItem(elements) : null;
    }

    protected boolean isAvailable(@NotNull AnActionEvent e, @NotNull ActionData data) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(5);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(6);
        }
        return data.routine != null && data.dataSource != null && RoutineExecutionHelper.EP.forDbms(data.dataSource.getDbms()) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(7);
        }
        this.doPerformAction(e, this.getActionData(e));
    }

    @NotNull
    protected RequestRunner getExecutor(@NotNull DataRequest.OwnerEx console, @NotNull ActionData actionData) {
        if (console == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(8);
        }
        if (actionData == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(9);
        }
        return new SimpleRequestRunner(console);
    }

    private void doPerformAction(@NotNull AnActionEvent e, @NotNull ActionData data) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(10);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(11);
        }
        if (data.dataSource == null || data.routine == null) {
            return;
        }
        Dbms dbms = data.dataSource.getDbms();
        BasicRoutine routine = data.routine;
        BasicModel model = routine.getModel();
        RoutineExecutionHelper provider = (RoutineExecutionHelper)RoutineExecutionHelper.EP.forDbms(dbms);
        if (provider == null) {
            return;
        }
        ExecuteRoutineActionBase.withOwner(e, data, (Consumer<DataRequest.CustomSearchPathOwner>)((Consumer)owner -> ExecuteRoutineActionBase.perform(routine, model, data.dataSource.getProject(), owner, owner.getSearchPath(), DbImplUtil.getLocalDataSource((DasDataSource)data.dataSource), data, true, this.getExecutor((DataRequest.OwnerEx)owner, data))));
    }

    public static void perform(@NotNull BasicRoutine routine, @NotNull BasicModel model, @NotNull Project project, @NotNull DataRequest.OwnerEx owner, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @Nullable ActionData data, boolean showPreviewDialog, @NotNull RequestRunner executor2) {
        RoutineExecutionHelper provider;
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(12);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(14);
        }
        if (owner == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(15);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(16);
        }
        if (executor2 == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(17);
        }
        if ((provider = (RoutineExecutionHelper)RoutineExecutionHelper.EP.forDbms(localDataSource.getDbms())) == null) {
            ExecuteRoutineActionBase.finish(owner, data);
            return;
        }
        DbDataSource dataSource2 = Objects.requireNonNull(DbImplUtil.getDbDataSource(project, localDataSource));
        ScriptingSingleModelTask task = ExecuteRoutineActionBase.makeTask(routine, model, searchPath, localDataSource, dataSource2);
        String statements2 = StringUtil.join((String[])ScriptGenerators.INSTANCE.makeScript(project, task).getScriptStatements(), (String)";\n");
        DasNamespace searchPathObject = DbImplUtil.getSearchPathObjectForSwitch(dataSource2, routine);
        SearchPath path = ObjectPaths.searchPathOf((DasObject)searchPathObject);
        String script = statements2;
        if (showPreviewDialog) {
            script = ExecuteRoutineActionBase.showPreviewDialog(dataSource2, script, "Execute Routine", path);
        }
        if (script == null || StringUtil.isEmptyOrSpaces((String)script)) {
            ExecuteRoutineActionBase.finish(owner, data);
            return;
        }
        DataRequest request = provider.makeRequest(project, localDataSource, owner, script, routine, path);
        if (request == null) {
            ExecuteRoutineActionBase.finish(owner, data);
            return;
        }
        request.getPromise().onProcessed(__ -> ExecuteRoutineActionBase.finish(owner, data));
        executor2.runRequest(request);
    }

    private static void finish(@NotNull DataRequest.OwnerEx owner, @Nullable ActionData data) {
        if (owner == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(18);
        }
        if (data != null) {
            data.onFinished(owner);
        }
    }

    @NotNull
    private static ScriptingSingleModelTask makeTask(@NotNull BasicRoutine routine, @NotNull BasicModel model, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull DbDataSource dataSource2) {
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(19);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(20);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(21);
        }
        if (dataSource2 == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(22);
        }
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.EXECUTE);
        ObjectPath path = (ObjectPath)ObjectUtils.doIfNotNull((Object)searchPath, p2 -> p2.getCurrent());
        ObjectPath databasePath = path == null ? null : path.findParent(ObjectKind.DATABASE, false);
        ObjectPath schemaPath = path == null ? null : path.findParent(ObjectKind.SCHEMA, false);
        BasicDatabase database = databasePath == null ? null : (BasicDatabase)DbSqlUtil.findObjects(dataSource2, databasePath).filter(BasicDatabase.class).first();
        BasicSchema schema = schemaPath == null ? null : (BasicSchema)DbSqlUtil.findObjects(dataSource2, schemaPath).filter(BasicSchema.class).first();
        taskBuilder.setCurrentSchema(schema);
        taskBuilder.setCurrentDatabase(database);
        taskBuilder.setVersion(localDataSource.getVersion());
        taskBuilder.setElements(Collections.singletonList(routine));
        taskBuilder.setOptions(new CustomScriptingOptions(ContainerUtil.map2Map(Collections.singletonList(Pair.create(ScriptingOptionStatic.CALL, (Object)true)))));
        ScriptingSingleModelTask scriptingSingleModelTask = taskBuilder.build();
        if (scriptingSingleModelTask == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(23);
        }
        return scriptingSingleModelTask;
    }

    private static void withOwner(@NotNull AnActionEvent e, @NotNull ActionData data, @NotNull Consumer<DataRequest.CustomSearchPathOwner> consumer2) {
        DataRequest.CustomSearchPathOwner owner;
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(24);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(25);
        }
        if (consumer2 == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(26);
        }
        if ((owner = data.owner()) != null) {
            consumer2.consume((Object)owner);
            return;
        }
        List<PersistenceConsoleProvider.Runner> runners = data.runners(consumer2);
        if (runners.isEmpty()) {
            return;
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, null, e);
    }

    @NotNull
    protected abstract ActionData getActionData(@NotNull AnActionEvent var1);

    @Nullable
    protected static String showPreviewDialog(@NotNull DbDataSource dbDataSource, @NotNull String script, @NotNull String title, @Nullable SearchPath path) {
        DatabasePreviewDialog previewDialog;
        if (dbDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(27);
        }
        if (script == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(28);
        }
        if (title == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(29);
        }
        return (previewDialog = new DatabasePreviewDialog(dbDataSource.getProject(), dbDataSource, path, title, "", script, ContainerUtil.emptyList(), false)).showAndGet() ? previewDialog.getStatement() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 6: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateActionText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDbRoutine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExecutor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "makeTask";
                break;
            }
            case 23: {
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "withOwner";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showPreviewDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MyData
    extends FilledData {
        MyData(@NotNull DbDataSource dataSource2, @NotNull BasicRoutine routine) {
            if (dataSource2 == null) {
                MyData.$$$reportNull$$$0(0);
            }
            if (routine == null) {
                MyData.$$$reportNull$$$0(1);
            }
            super(dataSource2, routine);
        }

        @Override
        @NotNull
        public List<PersistenceConsoleProvider.Runner> runners(@NotNull Consumer<DataRequest.CustomSearchPathOwner> consumer2) {
            if (consumer2 == null) {
                MyData.$$$reportNull$$$0(2);
            }
            BasicRoutine routine = Objects.requireNonNull(this.routine);
            DbDataSource dataSource2 = Objects.requireNonNull(this.dataSource);
            String title = routine.getName();
            List<PersistenceConsoleProvider.Runner> list = DatabaseRunners.getRunners((JBIterable<DbDataSource>)JBIterable.of((Object)dataSource2), dataSource2.getProject(), null, title, (Consumer<? super DatabaseSession>)((Consumer)s -> {
                LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DasDataSource)dataSource2);
                Project project = dataSource2.getProject();
                SearchPath searchPath = SearchPath.of((ObjectPath)ObjectPaths.of(routine));
                DGDepartment.RoutineRunner dep = new DGDepartment.RoutineRunner(routine);
                DatabaseSessionManager.Facade facade = DatabaseSessionManager.facade(project, localDataSource, null, searchPath, null, dep);
                VisibleDatabaseSessionClient client = facade.client((DatabaseSession)s);
                ScriptingClientDataConsumer.install(project, client);
                consumer2.consume((Object)client);
            }));
            if (list == null) {
                MyData.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void onFinished(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                MyData.$$$reportNull$$$0(4);
            }
            Disposer.dispose((Disposable)owner);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$MyData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$MyData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runners";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onFinished";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class FilledData
    extends ActionData {
        protected FilledData(@NotNull DbDataSource dataSource2, @NotNull BasicRoutine routine) {
            if (dataSource2 == null) {
                FilledData.$$$reportNull$$$0(0);
            }
            if (routine == null) {
                FilledData.$$$reportNull$$$0(1);
            }
            super(dataSource2, routine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$FilledData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class ActionData {
        public static final ActionData DISABLED = new ActionData(null, null){};
        public final DbDataSource dataSource;
        public final BasicRoutine routine;

        protected ActionData(@Nullable DbDataSource source, @Nullable BasicRoutine routine) {
            this.dataSource = source;
            this.routine = routine;
        }

        @Nullable
        public DataRequest.CustomSearchPathOwner owner() {
            return null;
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> runners(@NotNull Consumer<DataRequest.CustomSearchPathOwner> consumer2) {
            if (consumer2 == null) {
                ActionData.$$$reportNull$$$0(0);
            }
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                ActionData.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void onFinished(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                ActionData.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "runners";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onFinished";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SimpleRequestRunner
    implements RequestRunner {
        private final DataRequest.OwnerEx myOwner;

        SimpleRequestRunner(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                SimpleRequestRunner.$$$reportNull$$$0(0);
            }
            this.myOwner = owner;
        }

        @Override
        public void runRequest(@NotNull DataRequest request) {
            if (request == null) {
                SimpleRequestRunner.$$$reportNull$$$0(1);
            }
            this.myOwner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$SimpleRequestRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RequestRunner {
        public void runRequest(@NotNull DataRequest var1);
    }

    public static interface RoutineExecutionHelper {
        public static final DbmsExtension<RoutineExecutionHelper> EP = new DbmsExtension("com.intellij.database.routineExecutionHelper");

        @Nullable
        public DataRequest makeRequest(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull DataRequest.OwnerEx var3, @NotNull String var4, @NotNull BasicRoutine var5, @Nullable SearchPath var6);
    }
}

