/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.ChangeCellEditorLanguageAction;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.grid.editors.CellEditorScratchRootType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorTextField
extends EditorTextField
implements Disposable {
    private final DataGrid myGrid;

    public GridCellEditorTextField(Project project, @NotNull DataGrid grid, @NotNull Language language, @Nullable String text2, @Nullable byte[] bytes, boolean multiline, EventObject initiator, TextCompletionProvider provider, boolean autoPopup) {
        if (grid == null) {
            GridCellEditorTextField.$$$reportNull$$$0(0);
        }
        if (language == null) {
            GridCellEditorTextField.$$$reportNull$$$0(1);
        }
        super(GridCellEditorTextField.createDocument(project, language, text2, bytes, initiator instanceof KeyEvent && grid.isEditable()), project, (FileType)FileTypes.PLAIN_TEXT);
        this.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        this.myGrid = grid;
        this.installEditorSettingsProvider(multiline);
        GridCellEditorTextField.installCompletion(project, this.getDocument(), provider, autoPopup);
    }

    @NotNull
    public String getText() {
        String lineSeparator;
        Document document = this.getDocument();
        String text2 = document.getText();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile file = documentManager.getFile(document);
        if (file != null && !(lineSeparator = documentManager.getLineSeparator(file, this.getProject())).equals("\n")) {
            text2 = StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
        }
        String string = text2;
        if (string == null) {
            GridCellEditorTextField.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean shouldHaveBorder() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Editor editor = this.getEditor();
        if (editor instanceof EditorEx && !editor.isOneLineMode()) {
            JScrollBar horizontalScrollBar;
            JScrollPane scrollPane = ((EditorEx)editor).getScrollPane();
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                size.width += verticalScrollBar.getWidth();
            }
            if ((horizontalScrollBar = scrollPane.getHorizontalScrollBar()) != null) {
                size.height += horizontalScrollBar.getHeight();
            }
        }
        return size;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            GridCellEditorTextField.$$$reportNull$$$0(3);
        }
        if (ChangeCellEditorLanguageAction.ACTION_HANDLER_KEY.is(dataId)) {
            return new ChangeCellEditorLanguageAction.Handler(){

                @Override
                public void changeLanguage(AnActionEvent e) {
                    Consumer chosenLanguageConsumer = language -> {
                        VirtualFile scratch;
                        Document document = language != null ? GridCellEditorTextField.this.getDocument() : null;
                        VirtualFile virtualFile = scratch = document != null ? FileDocumentManager.getInstance().getFile(document) : null;
                        if (scratch != null) {
                            CellEditorScratchRootType.setLanguage(GridCellEditorTextField.this.getProject(), scratch, language);
                            GridCellEditorTextField.this.setDocument(document);
                            IdeFocusManager.getInstance((Project)GridCellEditorTextField.this.getProject()).requestFocus((Component)((Object)GridCellEditorTextField.this), true);
                        }
                    };
                    LRUPopupBuilder.forFileLanguages((Project)GridCellEditorTextField.this.getProject(), (String)"Edit As Language", null, (Consumer)chosenLanguageConsumer).showInBestPositionFor(e.getDataContext());
                }
            };
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return FileDocumentManager.getInstance().getFile(this.getDocument());
        }
        if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
            return this.getEditor();
        }
        if (AnActionEvent.injectedId((String)CommonDataKeys.CARET.getName()).equals(dataId)) {
            Editor editor = this.getEditor();
            return editor == null ? null : editor.getCaretModel().getCurrentCaret();
        }
        return super.getData(dataId);
    }

    public void dispose() {
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
            if (file == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    file.delete((Object)this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        });
    }

    protected boolean isEditable() {
        return this.myGrid.isEditable();
    }

    private void registerEnterAction(@NotNull Editor editor, final boolean multiline) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(4);
        }
        CustomShortcutSet enterAndControlEnter = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"ENTER"), KeyboardShortcut.fromString((String)"control ENTER")});
        DumbAwareAction action2 = new DumbAwareAction("insertNewLineOrStopEditing1"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)GridCellEditorTextField.this.getEditor()) == null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                boolean commitOnCtrlEnter;
                InputEvent inputEvent;
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                boolean isCtrlEnter = (inputEvent = e.getInputEvent()) instanceof KeyEvent && inputEvent.isControlDown();
                ResultView view2 = GridCellEditorTextField.this.myGrid.getResultView();
                boolean bl = commitOnCtrlEnter = view2 instanceof ResultViewWithCells && ((ResultViewWithCells)((Object)view2)).isEditingCellMaximized();
                if (!multiline || commitOnCtrlEnter == isCtrlEnter) {
                    GridCellEditorTextField.this.myGrid.stopEditing();
                } else {
                    this.performEditorEnter(e);
                }
            }

            private void performEditorEnter(@NotNull AnActionEvent e) {
                AnAction action2;
                if (e == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((action2 = ActionManager.getInstance().getAction("EditorEnter")) != null) {
                    action2.beforeActionPerformedUpdate(e);
                    if (e.getPresentation().isEnabled()) {
                        action2.actionPerformed(e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performEditorEnter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GridCellEditorTextField.registerAction(editor, (AnAction)action2, (ShortcutSet)enterAndControlEnter);
    }

    private void registerTabAction(@NotNull EditorEx editor) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(5);
        }
        CustomShortcutSet tabAndShiftTab = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"TAB"), KeyboardShortcut.fromString((String)"shift TAB")});
        DumbAwareAction action2 = new DumbAwareAction("insertTabOrStopEditing"){

            public void update(@NotNull AnActionEvent e) {
                ResultView view2;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean editingCellMaximized = (view2 = GridCellEditorTextField.this.myGrid.getResultView()) instanceof ResultViewWithCells && ((ResultViewWithCells)((Object)view2)).isEditingCellMaximized();
                KeyEvent keyEvent = !editingCellMaximized ? (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class) : null;
                e.getPresentation().setEnabledAndVisible(keyEvent != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                JComponent gridComponent = GridCellEditorTextField.this.myGrid.getPreferredFocusedComponent();
                KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                KeyStroke stroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                Object actionKey = gridComponent.getInputMap(1).get(stroke);
                Action tabAction = gridComponent.getActionMap().get(actionKey);
                if (tabAction != null) {
                    tabAction.actionPerformed(new ActionEvent(gridComponent, keyEvent.getID(), keyEvent.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GridCellEditorTextField.registerAction((Editor)editor, (AnAction)action2, (ShortcutSet)tabAndShiftTab);
    }

    private static void registerAction(@NotNull Editor editor, @NotNull AnAction action2, @NotNull ShortcutSet shortcutSet) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            GridCellEditorTextField.$$$reportNull$$$0(7);
        }
        if (shortcutSet == null) {
            GridCellEditorTextField.$$$reportNull$$$0(8);
        }
        action2.registerCustomShortcutSet(shortcutSet, editor.getComponent());
    }

    private void installEditorSettingsProvider(boolean multiline) {
        this.addSettingsProvider(editor -> {
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
            if (file != null) {
                EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file, editor.getColorsScheme(), this.getProject());
                editor.setHighlighter(highlighter);
            }
            editor.setRendererMode(!this.isEditable());
            EditorColorsScheme scheme = editor.createBoundColorSchemeDelegate((EditorColorsScheme)this.myGrid.getColorsScheme());
            if (UISettings.getInstance().getPresentationMode()) {
                scheme.setEditorFontSize(UISettings.getInstance().getPresentationModeFontSize());
            }
            editor.setColorsScheme(scheme);
            editor.setOneLineMode(!multiline);
            editor.setVerticalScrollbarVisible(multiline);
            editor.setHorizontalScrollbarVisible(multiline);
            editor.getSettings().setAdditionalColumnsCount(2);
            editor.getCaretModel().moveToOffset(0);
            if (this.isEditable() && (!multiline || this.getDocument().getLineCount() == 1)) {
                editor.getSelectionModel().setSelection(0, this.getDocument().getTextLength());
            }
            this.putReadOnlyText(editor);
            editor.installPopupHandler(new EditorPopupHandler(){

                public boolean handlePopup(@NotNull EditorMouseEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Component component = (Component)mouseEvent.getSource();
                    int x = mouseEvent.getX();
                    int y = mouseEvent.getY();
                    GridCellEditorsUtil.showCellEditorPopup(GridCellEditorTextField.this.myGrid, component, x, y);
                    event.consume();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$4", "handlePopup"));
                }
            });
            this.registerEnterAction((Editor)editor, multiline);
            this.registerTabAction(editor);
        });
    }

    private void putReadOnlyText(@NotNull EditorEx editor) {
        GridEditGuard guard;
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(9);
        }
        if ((guard = GridEditGuard.get(this.myGrid)) == null) {
            return;
        }
        EditorModificationUtil.setReadOnlyHint((Editor)editor, (String)guard.getReasonText(this.myGrid));
    }

    @NotNull
    private static Document createDocument(@NotNull Project project, @NotNull Language language, @Nullable String text2, @Nullable byte[] bytes, boolean clear2) {
        Document document;
        if (project == null) {
            GridCellEditorTextField.$$$reportNull$$$0(10);
        }
        if (language == null) {
            GridCellEditorTextField.$$$reportNull$$$0(11);
        }
        Document document2 = (document = (Document)WriteAction.compute(() -> {
            try {
                VirtualFile scratchFile = CellEditorScratchRootType.newScratch(project);
                if (bytes != null) {
                    scratchFile.setBinaryContent(bytes);
                } else if (text2 != null) {
                    scratchFile.setCharset(CharsetToolkit.UTF_16_CHARSET);
                    VfsUtil.saveText((VirtualFile)scratchFile, (String)text2);
                }
                VfsUtilCore.virtualToIoFile((VirtualFile)scratchFile).deleteOnExit();
                CellEditorScratchRootType.setLanguage(project, scratchFile, language);
                Document doc2 = FileDocumentManager.getInstance().getDocument(scratchFile);
                if (doc2 != null && clear2) {
                    doc2.setText((CharSequence)"");
                }
                return doc2;
            }
            catch (IOException ignore) {
                return null;
            }
        })) != null ? document : EditorFactory.getInstance().createDocument((CharSequence)StringUtil.notNullize((String)(clear2 ? null : text2)));
        if (document2 == null) {
            GridCellEditorTextField.$$$reportNull$$$0(12);
        }
        return document2;
    }

    private static void installCompletion(@NotNull Project project, @Nullable Document document, @Nullable TextCompletionProvider provider, boolean autoPopup) {
        if (project == null) {
            GridCellEditorTextField.$$$reportNull$$$0(13);
        }
        if (document == null || provider == null) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile != null) {
            TextCompletionUtil.installProvider((PsiFile)psiFile, (TextCompletionProvider)provider, (boolean)autoPopup);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerEnterAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerTabAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putReadOnlyText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

