/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorTextField;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GridTextCellEditorBase
extends GridCellEditor.Adapter
implements DataProvider,
GridCellEditor.EditorBased {
    protected final DataGrid myGrid;
    protected final DataConsumer.Column myColumn;
    protected final GridCellEditorTextField myTextField;
    protected Object myValue;
    protected String myInitialText;

    protected GridTextCellEditorBase(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object value2, EventObject initiator) {
        if (grid == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(0);
        }
        if (column == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        this.myColumn = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column);
        this.myValue = value2;
        this.myInitialText = this.getInitialText();
        TextCompletionProvider provider = GridCellEditorsUtil.createCompletionProvider(grid, column);
        this.myTextField = new MyGridCellEditorTextField(grid.getContentLanguage(column), initiator, this.myInitialText, this.getInitialBytes(), provider);
        Disposer.register((Disposable)this, (Disposable)this.myTextField);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(2);
        }
        return gridCellEditorTextField;
    }

    @Override
    public Editor getEditor() {
        return this.myTextField.getEditor();
    }

    @Override
    @Nullable
    public Object getValue() {
        boolean valueChanged = this.isValueEditable() && (this.myInitialText == null || !this.myInitialText.equals(this.myTextField.getText()));
        return valueChanged ? this.myTextField.getText() : this.myValue;
    }

    @Override
    public boolean isMaximizationAllowed() {
        return true;
    }

    @Nullable
    protected String getInitialText() {
        if (this.myValue == null || this.myValue instanceof ReservedCellValue) {
            return null;
        }
        Dbms dbms = DataGridUtil.getDbms(this.myGrid);
        return this.myGrid.getObjectFormatter().objectToString(this.myValue, this.myColumn, dbms, true);
    }

    @Nullable
    protected byte[] getInitialBytes() {
        return null;
    }

    protected abstract boolean isValueEditable();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyGridCellEditorTextField
    extends GridCellEditorTextField {
        MyGridCellEditorTextField(Language language, EventObject initiator, String initialText, @Nullable byte[] initialBytes, TextCompletionProvider provider) {
            if (language == null) {
                MyGridCellEditorTextField.$$$reportNull$$$0(0);
            }
            super(DataGridUtil.getProject(GridTextCellEditorBase.this.myGrid), GridTextCellEditorBase.this.myGrid, language, initialText, initialBytes, true, initiator, provider, false);
            this.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GridTextCellEditorBase.this.fireEditing(MyGridCellEditorTextField.this.getDocument().getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase$MyGridCellEditorTextField$1", "documentChanged"));
                }
            });
        }

        @Override
        public Object getData(@NotNull String dataId) {
            Object fromCellEditor;
            if (dataId == null) {
                MyGridCellEditorTextField.$$$reportNull$$$0(1);
            }
            return (fromCellEditor = GridTextCellEditorBase.this.getData(dataId)) != null ? fromCellEditor : super.getData(dataId);
        }

        @Override
        protected boolean isEditable() {
            return super.isEditable() && GridTextCellEditorBase.this.isValueEditable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase$MyGridCellEditorTextField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

