/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseToggleNotebookModeAction;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class GeneralSettingsComponent
implements ConfigurableUi<DatabaseSettings> {
    private static final BooleanFunction<JTextComponent> STATUS_VISIBILITY_PREDICATE = component -> component.isEnabled() && !component.isFocusOwner() && component.getText().isEmpty();
    private JPanel myPanel;
    private JCheckBox myShowQueryResultsInCheckBox;
    private JCheckBox myShowErrorBalloonCheckbox;
    private JBCheckBox myReviewParametersCheckBox;
    private JBCheckBox myUnsafeQueryWarningBox;
    private ComboBox<String> myInsideStatementCombo;
    private ComboBox<String> myOutsideStatementCombo;
    private ComboBox<String> mySelectionPresentCombo;
    private JCheckBox myPreviewRowsCheckBox;
    private JTextField myPreviewRowsTextField;
    private JBCheckBox myDdlConfirmOnClose;
    private JPanel myRunChooserPanel;
    private SwingActionLink myShortcutLink;
    private JBCheckBox myPreferSchemaNavigationCombo;
    private JBCheckBox myPreferDataNavigationCombo;
    private JBCheckBox myConsoleToolbarCheckBox;
    private JBCheckBox myQualifyNamesCheckBox;
    private JBTextField myResultsTitlePrefixField;
    private JBCheckBox myResultsTitlePrefixCheckBox;
    private JCheckBox myTrackNamespacesBox;
    private JBCheckBox mySkipRefactoringPreviewBox;
    private JBCheckBox myNotebookModeCheckBox;
    private final List<MyAction> myRunActions;
    private MyAction mySelectedRunAction;
    private final ActionToolbar myToolbar;

    public GeneralSettingsComponent() {
        this.$$$setupUI$$$();
        this.myInsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.ask.what.to.execute", (Object[])new Object[0]));
        this.myInsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.smallest.statement", (Object[])new Object[0]));
        this.myInsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.largest.statement", (Object[])new Object[0]));
        this.myInsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.largest.statement.or.batch", (Object[])new Object[0]));
        this.myInsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.whole.script", (Object[])new Object[0]));
        this.myInsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.everything.from.caret", (Object[])new Object[0]));
        this.myOutsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.nothing", (Object[])new Object[0]));
        this.myOutsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.whole.script.outside", (Object[])new Object[0]));
        this.myOutsideStatementCombo.addItem((Object)DatabaseBundle.message((String)"settings.everything.below.caret", (Object[])new Object[0]));
        this.mySelectionPresentCombo.addItem((Object)DatabaseBundle.message((String)"settings.exactly.as.one.statement", (Object[])new Object[0]));
        this.mySelectionPresentCombo.addItem((Object)DatabaseBundle.message((String)"settings.exactly.as.statements", (Object[])new Object[0]));
        this.mySelectionPresentCombo.addItem((Object)DatabaseBundle.message((String)"settings.smart.expand.to.script", (Object[])new Object[0]));
        this.myInsideStatementCombo.setMinLength(30);
        this.myOutsideStatementCombo.setMinLength(30);
        this.mySelectionPresentCombo.setMinLength(30);
        List<DatabaseSettings.ExecOption> options = DatabaseSettings.getSettings().execOptions;
        this.myRunActions = new ArrayList<MyAction>();
        for (int i2 = 0; i2 < options.size(); ++i2) {
            this.myRunActions.add(new MyAction(i2 + 1, options.get(i2)));
        }
        DefaultActionGroup group = new DefaultActionGroup(JBIterable.from(this.myRunActions).join((Object)Separator.create()).toList());
        this.myToolbar = ActionManager.getInstance().createActionToolbar("DB.RunChooser", (ActionGroup)group, true);
        this.myRunChooserPanel.add(this.myToolbar.getComponent());
        for (MyAction action2 : this.myRunActions) {
            action2.registerCustomShortcutSet(this.myPanel, null);
        }
        this.setSelectedRunAction(this.myRunActions.get(0));
        this.myResultsTitlePrefixCheckBox.addItemListener(e -> this.myResultsTitlePrefixField.setEnabled(this.myResultsTitlePrefixCheckBox.isSelected()));
        this.myResultsTitlePrefixField.getEmptyText().setText(DatabaseBundle.message((String)"settings.comment.beginning", (Object[])new Object[0]));
        this.myResultsTitlePrefixField.putClientProperty((Object)"StatusVisibleFunction", STATUS_VISIBILITY_PREDICATE);
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myShortcutLink = new SwingActionLink((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Configurable configurable;
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)GeneralSettingsComponent.this.myPanel);
                Settings settings = (Settings)dataContext.getData(Settings.KEY);
                Configurable configurable2 = configurable = settings != null ? settings.find("preferences.keymap") : null;
                if (configurable == null) {
                    this.setEnabled(false);
                    return;
                }
                settings.select(configurable).doWhenDone(() -> {
                    KeymapPanel keymap = (KeymapPanel)configurable;
                    keymap.selectAction(ActionManager.getInstance().getId(((GeneralSettingsComponent)GeneralSettingsComponent.this).mySelectedRunAction.executeAction));
                });
            }
        });
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(1);
        }
        this.myPreferSchemaNavigationCombo.setSelected(settings.navigateToSchema);
        this.myPreferDataNavigationCombo.setSelected(settings.navigateToData);
        this.myShowErrorBalloonCheckbox.setSelected(settings.isShowErrorInEditor());
        this.myReviewParametersCheckBox.setSelected(settings.alwaysReviewParameters);
        this.myUnsafeQueryWarningBox.setSelected(settings.warnAboutUnsafeQuery);
        this.myTrackNamespacesBox.setSelected(settings.trackNamespaces);
        this.mySkipRefactoringPreviewBox.setSelected(settings.skipRefactoringPreview);
        for (MyAction action2 : this.myRunActions) {
            action2.temp.copyFrom(action2.orig);
        }
        this.restoreMyAction(this.mySelectedRunAction);
        this.myPreviewRowsCheckBox.setSelected(settings.loadSlowDocumentation);
        this.myPreviewRowsTextField.setText(String.valueOf(settings.previewRows));
        this.myDdlConfirmOnClose.setSelected(settings.ddlConfirmLoss);
        this.myConsoleToolbarCheckBox.setSelected(settings.alwaysShowConsoleToolbar);
        this.myQualifyNamesCheckBox.setSelected(settings.alwaysQualifyNames);
        this.myResultsTitlePrefixCheckBox.setSelected(settings.resultsTitlePrefixEnabled);
        this.myResultsTitlePrefixField.setText(settings.resultsTitlePrefix);
        this.myResultsTitlePrefixField.setEnabled(settings.resultsTitlePrefixEnabled);
        this.myNotebookModeCheckBox.setSelected(settings.notebookMode);
    }

    public void apply(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(2);
        }
        boolean fireUiSettings = false;
        settings.navigateToSchema = this.myPreferSchemaNavigationCombo.isSelected();
        settings.navigateToData = this.myPreferDataNavigationCombo.isSelected();
        settings.setShowErrorInEditor(this.myShowErrorBalloonCheckbox.isSelected());
        settings.alwaysReviewParameters = this.myReviewParametersCheckBox.isSelected();
        settings.warnAboutUnsafeQuery = this.myUnsafeQueryWarningBox.isSelected();
        this.storeMyAction(this.mySelectedRunAction);
        for (MyAction action2 : this.myRunActions) {
            action2.orig.copyFrom(action2.temp);
        }
        this.restoreMyAction(this.mySelectedRunAction);
        settings.loadSlowDocumentation = this.myPreviewRowsCheckBox.isSelected();
        settings.previewRows = StringUtil.parseInt((String)this.myPreviewRowsTextField.getText(), (int)0);
        settings.ddlConfirmLoss = this.myDdlConfirmOnClose.isSelected();
        settings.alwaysShowConsoleToolbar = this.myConsoleToolbarCheckBox.isSelected();
        if (settings.alwaysQualifyNames != this.myQualifyNamesCheckBox.isSelected()) {
            fireUiSettings = true;
        }
        settings.alwaysQualifyNames = this.myQualifyNamesCheckBox.isSelected();
        settings.resultsTitlePrefix = StringUtil.nullize((String)this.myResultsTitlePrefixField.getText(), (boolean)true);
        settings.resultsTitlePrefixEnabled = this.myResultsTitlePrefixCheckBox.isSelected();
        settings.trackNamespaces = this.myTrackNamespacesBox.isSelected();
        settings.skipRefactoringPreview = this.mySkipRefactoringPreviewBox.isSelected();
        boolean notebookModeBefore = settings.notebookMode;
        settings.notebookMode = this.myNotebookModeCheckBox.isSelected();
        DatabaseSettings.fireSettingsChanged();
        if (fireUiSettings) {
            UISettings.getInstance().fireUISettingsChanged();
        }
        if (notebookModeBefore != this.myNotebookModeCheckBox.isSelected()) {
            Project[] projects;
            DatabaseToggleNotebookModeAction.forgetSavedState();
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                List<JdbcConsole> consoles = JdbcConsole.getActiveConsoles(project);
                for (JdbcConsole console : consoles) {
                    console.setNotebookMode(this.myNotebookModeCheckBox.isSelected(), false);
                }
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(3);
        }
        this.updateShortcutText();
        if (settings.navigateToSchema != this.myPreferSchemaNavigationCombo.isSelected()) {
            return true;
        }
        if (settings.navigateToData != this.myPreferDataNavigationCombo.isSelected()) {
            return true;
        }
        if (settings.isShowErrorInEditor() != this.myShowErrorBalloonCheckbox.isSelected()) {
            return true;
        }
        if (settings.alwaysReviewParameters != this.myReviewParametersCheckBox.isSelected()) {
            return true;
        }
        if (settings.warnAboutUnsafeQuery != this.myUnsafeQueryWarningBox.isSelected()) {
            return true;
        }
        if (settings.trackNamespaces != this.myTrackNamespacesBox.isSelected()) {
            return true;
        }
        if (settings.skipRefactoringPreview != this.mySkipRefactoringPreviewBox.isSelected()) {
            return true;
        }
        this.storeMyAction(this.mySelectedRunAction);
        for (MyAction action2 : this.myRunActions) {
            if (action2.orig.equals(action2.temp)) continue;
            return true;
        }
        if (settings.loadSlowDocumentation != this.myPreviewRowsCheckBox.isSelected()) {
            return true;
        }
        if (settings.previewRows != StringUtil.parseInt((String)this.myPreviewRowsTextField.getText(), (int)0)) {
            return true;
        }
        if (settings.ddlConfirmLoss != this.myDdlConfirmOnClose.isSelected()) {
            return true;
        }
        if (settings.alwaysShowConsoleToolbar != this.myConsoleToolbarCheckBox.isSelected()) {
            return true;
        }
        if (settings.alwaysQualifyNames != this.myQualifyNamesCheckBox.isSelected()) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)settings.resultsTitlePrefix, (CharSequence)StringUtil.nullize((String)this.myResultsTitlePrefixField.getText(), (boolean)true))) {
            return true;
        }
        if (settings.resultsTitlePrefixEnabled != this.myResultsTitlePrefixCheckBox.isSelected()) {
            return true;
        }
        return settings.notebookMode != this.myNotebookModeCheckBox.isSelected();
    }

    private void setSelectedRunAction(MyAction selected) {
        this.storeMyAction(this.mySelectedRunAction);
        this.mySelectedRunAction = selected;
        this.restoreMyAction(this.mySelectedRunAction);
        this.myToolbar.updateActionsImmediately();
    }

    private void updateShortcutText() {
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.mySelectedRunAction.executeAction);
        this.myShortcutLink.setText(shortcutText.isEmpty() ? "assign" : shortcutText);
    }

    private void storeMyAction(MyAction a) {
        if (a == null) {
            return;
        }
        a.temp.newTab = this.myShowQueryResultsInCheckBox.isSelected();
        a.temp.execInside = this.myInsideStatementCombo.getSelectedIndex() + 1;
        a.temp.execOutside = this.myOutsideStatementCombo.getSelectedIndex() + 1;
        a.temp.execSelection = this.mySelectionPresentCombo.getSelectedIndex() + 1;
    }

    private void restoreMyAction(MyAction a) {
        if (a == null) {
            return;
        }
        this.myInsideStatementCombo.setSelectedIndex(a.temp.execInside - 1);
        this.myOutsideStatementCombo.setSelectedIndex(a.temp.execOutside - 1);
        this.mySelectionPresentCombo.setSelectedIndex(a.temp.execSelection - 1);
        this.myShowQueryResultsInCheckBox.setSelected(a.temp.newTab);
        this.updateShortcutText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox3;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        JBCheckBox jBCheckBox8;
        JBCheckBox jBCheckBox9;
        JBCheckBox jBCheckBox10;
        JPanel jPanel;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(23, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(22, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.otherwise.execute"));
        jPanel2.add((Component)jBLabel, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myOutsideStatementCombo = comboBox3 = new ComboBox();
        jPanel2.add((Component)comboBox3, new GridConstraints(6, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.when.inside.statement.execute"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        this.myInsideStatementCombo = comboBox2 = new ComboBox();
        jPanel2.add((Component)comboBox2, new GridConstraints(5, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(5, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.for.selection.execute"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(7, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySelectionPresentCombo = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(7, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.other"));
        jPanel2.add((Component)titledSeparator, new GridConstraints(17, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        JBCheckBox jBCheckBox11 = new JBCheckBox();
        this.myShowQueryResultsInCheckBox = jBCheckBox11;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox11, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.open.results.in.new.tab"));
        jPanel2.add((Component)jBCheckBox11, new GridConstraints(8, 0, 1, 3, 4, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.execute.in.console"));
        jPanel2.add((Component)titledSeparator2, new GridConstraints(3, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        this.myRunChooserPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        SwingActionLink swingActionLink = this.myShortcutLink;
        jPanel2.add((Component)swingActionLink, new GridConstraints(4, 2, 1, 1, 8, 2, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.shortcut"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(4, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.navigation"));
        jPanel2.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        this.myPreferSchemaNavigationCombo = jBCheckBox10 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox10, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.prefer.database.view.over.ddl.editor"));
        jPanel2.add((Component)jBCheckBox10, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myPreferDataNavigationCombo = jBCheckBox9 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox9, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.prefer.data.editor.over.ddl.editor"));
        jPanel2.add((Component)jBCheckBox9, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBCheckBox jBCheckBox12 = new JBCheckBox();
        this.myShowErrorBalloonCheckbox = jBCheckBox12;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox12, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("jdbc.console.property.label.error.balloon"));
        jPanel2.add((Component)jBCheckBox12, new GridConstraints(10, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myReviewParametersCheckBox = jBCheckBox8 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox8, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.review.parameters.before.execution"));
        jPanel2.add((Component)jBCheckBox8, new GridConstraints(11, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 4, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(18, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBCheckBox jBCheckBox13 = new JBCheckBox();
        this.myPreviewRowsCheckBox = jBCheckBox13;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox13, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.show.first"));
        jPanel3.add((Component)jBCheckBox13, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBTextField jBTextField2 = new JBTextField();
        this.myPreviewRowsTextField = jBTextField2;
        jBTextField2.setColumns(4);
        jBTextField2.setHorizontalAlignment(4);
        jBTextField2.setText("");
        jPanel3.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.data.rows.in.documentation"));
        jPanel3.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConsoleToolbarCheckBox = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.always.show.console.toolbar.in.editor"));
        jPanel2.add((Component)jBCheckBox7, new GridConstraints(12, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myQualifyNamesCheckBox = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.always.show.qualified.names.for.database.objects"));
        jPanel2.add((Component)jBCheckBox6, new GridConstraints(19, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(336, 19), null));
        this.myUnsafeQueryWarningBox = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.show.warning.before.executing.potentially.unsafe.queries"));
        jPanel2.add((Component)jBCheckBox5, new GridConstraints(14, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myDdlConfirmOnClose = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.confirm.cancellation.for.dialogs.that.modify.schema"));
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(20, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(347, 19), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(16, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 4, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.treat.text.as.title.after"));
        jPanel5.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myResultsTitlePrefixField = jBTextField = new JBTextField();
        jPanel5.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myResultsTitlePrefixCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.create.title.for.results.from.comment.before.query"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(15, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTrackNamespacesBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.track.databases.schemas.creation.and.deletion"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySkipRefactoringPreviewBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.skip.database.refactoring.preview"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(21, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(347, 19), null));
        this.myNotebookModeCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", GeneralSettingsComponent.class).getString("settings.database.notebook.mode"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(9, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel3.setLabelFor((Component)comboBox);
        jBLabel5.setLabelFor((Component)jBTextField2);
        jBLabel6.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/GeneralSettingsComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/GeneralSettingsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyAction
    extends AlignedIconWithTextAction
    implements Toggleable,
    DumbAware {
        AnAction executeAction;
        final DatabaseSettings.ExecOption orig;
        final DatabaseSettings.ExecOption temp = new DatabaseSettings.ExecOption();

        MyAction(int index2, DatabaseSettings.ExecOption orig) {
            this.orig = orig;
            String actionId = "Console.Jdbc.Execute" + (index2 > 1 ? "." + index2 : "");
            this.executeAction = ActionManager.getInstance().getAction(actionId);
            String text2 = this.executeAction == null ? actionId : this.executeAction.getTemplatePresentation().getText();
            this.getTemplatePresentation().setText(text2);
            this.getTemplatePresentation().setDescription("Edit settings for '" + text2 + "'");
            this.setEnabledInModalContext(true);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke("alt " + index2), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(this.executeAction != null);
            Toggleable.setSelected((Presentation)e.getPresentation(), (this == GeneralSettingsComponent.this.mySelectedRunAction ? 1 : 0) != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            GeneralSettingsComponent.this.setSelectedRunAction(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/settings/GeneralSettingsComponent$MyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

