/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.JBIterable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntrospectionScopeUpdater {
    private final Set<ObjectPath> mySchemasToRemove = new LinkedHashSet<ObjectPath>();
    private final Set<ObjectPath> mySchemasToAdd = new LinkedHashSet<ObjectPath>();

    public IntrospectionScopeUpdater addAll(IntrospectionScopeUpdater other) {
        this.mySchemasToRemove.addAll(other.mySchemasToRemove);
        this.mySchemasToAdd.addAll(other.mySchemasToAdd);
        return this;
    }

    public IntrospectionScopeUpdater toRemove(@Nullable ObjectPath path) {
        if (path != null) {
            this.mySchemasToAdd.remove(path);
            this.mySchemasToRemove.add(path);
        }
        return this;
    }

    public IntrospectionScopeUpdater toAdd(@Nullable ObjectPath path) {
        if (path != null) {
            this.mySchemasToRemove.remove(path);
            this.mySchemasToAdd.add(path);
        }
        return this;
    }

    @NotNull
    public Iterable<ObjectPath> getSchemasToAdd() {
        Set<ObjectPath> set = this.mySchemasToAdd;
        if (set == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public TreePattern updateVisibleNamespaces(@NotNull TreePattern introspectionScope, @NotNull BasicModel model) {
        if (introspectionScope == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(1);
        }
        if (model == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(2);
        }
        if (this.mySchemasToRemove.isEmpty() && this.mySchemasToAdd.isEmpty()) {
            TreePattern treePattern = introspectionScope;
            if (treePattern == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(3);
            }
            return treePattern;
        }
        TreePattern toAdd = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(this.mySchemasToAdd).filterMap(p2 -> ObjectPaths.of((DasObject)QNameUtil.findByPath(model, p2).first())).map(n -> TreePatternUtils.create(n)));
        TreePattern toRemove = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(this.mySchemasToRemove).filter(p2 -> QNameUtil.findByPath(model, p2).isEmpty()).map(n -> TreePatternUtils.create(IntrospectionScopeUpdater.adjust(n, introspectionScope, (CasingProvider)model))));
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            TreePattern treePattern = introspectionScope;
            if (treePattern == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(4);
            }
            return treePattern;
        }
        TreePattern treePattern = TreePatternUtils.union(TreePatternUtils.minus(introspectionScope, toRemove), toAdd);
        if (treePattern == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(5);
        }
        return treePattern;
    }

    @NotNull
    private static ObjectPath adjust(@NotNull ObjectPath path, @NotNull TreePattern pattern, @NotNull CasingProvider casingProvider) {
        if (path == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(7);
        }
        if (casingProvider == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(8);
        }
        Ref res2 = Ref.create();
        IntrospectionScopeUpdater.adjust(path, pattern.root, casingProvider, (Ref<ObjectPath>)res2);
        ObjectPath objectPath = (ObjectPath)res2.get();
        if (objectPath == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(9);
        }
        return objectPath;
    }

    @Nullable
    private static TreePatternNode<?> adjust(@NotNull ObjectPath path, @NotNull TreePatternNode<?> root2, @NotNull CasingProvider casingProvider, @NotNull Ref<ObjectPath> res2) {
        TreePatternNode.Group group;
        if (path == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(10);
        }
        if (root2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(11);
        }
        if (casingProvider == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(12);
        }
        if (res2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(13);
        }
        TreePatternNode<?> parent2 = path.parent == null ? root2 : IntrospectionScopeUpdater.adjust(path.parent, root2, casingProvider, res2);
        TreePatternNode.Group group2 = group = parent2 == null ? null : parent2.getGroup(path.kind);
        if (group != null) {
            ObjectName correction;
            ObjectName name = ObjectName.create((String)path.name, (boolean)path.isQuoted());
            if (group.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                    ObjectName correction2 = ((TreePatternNode.PositiveNaming)child.naming).find(name, casingProvider.getCasing(path.kind, null));
                    if (correction2 == null) continue;
                    res2.set((Object)ObjectPath.create((String)correction2.name, (ObjectKind)path.kind, (boolean)correction2.quoted, null, (ObjectPath)((ObjectPath)res2.get())));
                    return child;
                }
            }
            if (group.negativeChild != null && (correction = ((TreePatternNode.NegativeNaming)group.negativeChild.naming).find(name, casingProvider.getCasing(path.kind, null))) != null) {
                res2.set((Object)ObjectPath.create((String)correction.name, (ObjectKind)path.kind, (boolean)correction.quoted, null, (ObjectPath)((ObjectPath)res2.get())));
                return null;
            }
        }
        res2.set((Object)ObjectPath.create((String)path.name, (ObjectKind)path.kind, (boolean)path.isQuoted(), null, (ObjectPath)((ObjectPath)res2.get())));
        return group == null ? null : group.negativeChild;
    }

    public void merge(@NotNull IntrospectionScopeUpdater updater) {
        if (updater == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(14);
        }
        this.mySchemasToAdd.addAll(updater.mySchemasToAdd);
        this.mySchemasToRemove.addAll(updater.mySchemasToRemove);
    }

    public boolean isRemoved(BasicNamespace nsp) {
        Casing casing = nsp.getCasing(nsp.getKind(), nsp);
        ObjectPath path = BasicPaths.of(nsp);
        for (ObjectPath removed : this.mySchemasToRemove) {
            if (!IntrospectionScopeUpdater.matches(path, removed, casing)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(@Nullable ObjectPath p1, @Nullable ObjectPath p2, @NotNull Casing casing) {
        if (casing == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(15);
        }
        if (p1 == null || p2 == null) {
            return p1 == p2;
        }
        if (!IntrospectionScopeUpdater.matches(p1.parent, p2.parent, casing)) {
            return false;
        }
        return ObjectPath.namesEqual((ObjectPath)p1, (ObjectPath)p2, (Casing)casing);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntrospectionScopeUpdater updater = (IntrospectionScopeUpdater)o;
        if (!this.mySchemasToRemove.equals(updater.mySchemasToRemove)) {
            return false;
        }
        return this.mySchemasToAdd.equals(updater.mySchemasToAdd);
    }

    public int hashCode() {
        int result = this.mySchemasToRemove.hashCode();
        result = 31 * result + this.mySchemasToAdd.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/IntrospectionScopeUpdater";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introspectionScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasToAdd";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/IntrospectionScopeUpdater";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "updateVisibleNamespaces";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "adjust";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateVisibleNamespaces";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjust";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

