/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStorageInspection
extends LocalInspectionTool {
    public static final Key<Boolean> IGNORE_UNSAVED = Key.create((String)"IGNORE_UNSAVED");
    private static final LocalQuickFix[] STAGING_CONFLICT_FIXES = new LocalQuickFix[]{new RevertFix(), new UseMyFix(), new MergeFix()};
    private static final LocalQuickFix[] INVALID_SOURCES_FIXES = new LocalQuickFix[]{new ReintrospectFix()};
    private static final LocalQuickFix[] OUTDATED_FIXES = new LocalQuickFix[]{new ReintrospectFix(), new DisableOutdatedCheckFix()};

    @NotNull
    public String getShortName() {
        return "SqlStorageInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(1);
        }
        VirtualFile vfile = file.getVirtualFile();
        if (!isOnTheFly || !DbSrcUtils.isDbSrcFile(vfile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList res2 = new ArrayList();
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkStagingConflict(file, manager, vfile));
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkInvalidSources(file, manager, vfile));
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkOutdated(file, manager, vfile));
        return res2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static ProblemDescriptor checkOutdated(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(3);
        }
        DbElement e = DbImplUtil.findElement(file.getProject(), vfile);
        BasicElement element2 = DbImplUtil.getMaybeBasicElement((DasObject)e);
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)(e == null ? null : e.getDataSource()));
        if (element2 == null || ds == null || !element2.isOutdated() || !ds.shouldCheckOutdated()) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, "Cached object differs from the object in the database ", true, OUTDATED_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkStagingConflict(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        DbSrcFileSystem fs;
        VirtualFile base;
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(5);
        }
        if ((base = (fs = DbSrcFileSystem.getInstance()).getSatelliteFile(vfile, DbSrcFileSystem.ItemType.USER_BASE, false)) == null) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, "Object has changed in database", true, STAGING_CONFLICT_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkInvalidSources(final @NotNull PsiFile file, final @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(7);
        }
        return DbSrcFileSystem.processPath(vfile, new DbSrcFileSystem.ItemProcessor<ProblemDescriptor>(){

            @Override
            public ProblemDescriptor processFile(@Nullable Project p2, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystem.ItemType type) {
                BasicModel model;
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                Project project = file.getProject();
                if (p2 != null && p2 != project) {
                    return null;
                }
                DbSrcStorage layout = DbSrcStorageManager.getInstance(p2).getStorage(dataSourceId, true);
                DbSrcStorageDsMetadata.MetaData res2 = layout.getMetaData(path);
                if (res2 == null) {
                    return null;
                }
                DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
                if (dataSource2 == null) {
                    return null;
                }
                BasicSourceAware object = (BasicSourceAware)DbSqlUtil.findObjects(dataSource2, path).filter(BasicSourceAware.class).first();
                BasicModel basicModel = model = object == null ? null : object.getModel();
                if (model == null) {
                    return null;
                }
                int version = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getDbms(), object.getKind());
                if (res2.introContentVersion == version) {
                    return null;
                }
                return manager.createProblemDescriptor((PsiElement)file, "Object source code may be invalid.", true, INVALID_SOURCES_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isUnsaved(VirtualFile vfile) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(vfile);
        return documentManager.isFileModified(vfile) && !Boolean.TRUE.equals(IGNORE_UNSAVED.get((UserDataHolder)document));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOutdated";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStagingConflict";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInvalidSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MergeFix
    extends IntentionAndQuickFixAction {
        private MergeFix() {
        }

        @NotNull
        public String getName() {
            return "Merge";
        }

        @NotNull
        public String getFamilyName() {
            return "Merge";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                MergeFix.$$$reportNull$$$0(0);
            }
            if (!DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.merge(project, vfile);
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to merge " + vfile.getUrl(), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/configuration/SqlStorageInspection$MergeFix", "applyFix"));
        }
    }

    private static class UseMyFix
    extends IntentionAndQuickFixAction {
        private UseMyFix() {
        }

        @NotNull
        public String getName() {
            return "Keep local changes";
        }

        @NotNull
        public String getFamilyName() {
            return "Keep local changes";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                UseMyFix.$$$reportNull$$$0(0);
            }
            if (!DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.resolveMy((Iterable<VirtualFile>)JBIterable.of((Object)vfile));
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to merge " + vfile.getUrl(), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/configuration/SqlStorageInspection$UseMyFix", "applyFix"));
        }
    }

    private static class RevertFix
    extends IntentionAndQuickFixAction {
        private RevertFix() {
        }

        @NotNull
        public String getName() {
            return "Revert local changes";
        }

        @NotNull
        public String getFamilyName() {
            return "Revert local changes";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                RevertFix.$$$reportNull$$$0(0);
            }
            if (!DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.revert((Iterable<VirtualFile>)JBIterable.of((Object)vfile));
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to revert " + vfile.getUrl(), MessageType.INFO).notify(file.getProject());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/configuration/SqlStorageInspection$RevertFix", "applyFix"));
        }
    }

    private static class DisableOutdatedCheckFix
    extends IntentionAndQuickFixAction {
        private DisableOutdatedCheckFix() {
        }

        @NotNull
        public String getName() {
            return "Disable check";
        }

        @NotNull
        public String getFamilyName() {
            return "Disable check";
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
            VirtualFile vfile;
            if (project == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(0);
            }
            LocalDataSource dataSource2 = DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtils.findDataSource(vfile) : null;
            return dataSource2 != null && dataSource2.shouldCheckOutdated();
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            LocalDataSource dataSource2;
            if (project == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(1);
            }
            LocalDataSource localDataSource = dataSource2 = DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtils.findDataSource(vfile) : null;
            if (dataSource2 == null) {
                return;
            }
            dataSource2.setCheckOutdated(false);
            DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$DisableOutdatedCheckFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReintrospectFix
    extends IntentionAndQuickFixAction {
        private ReintrospectFix() {
        }

        @NotNull
        public String getName() {
            return "Synchronize";
        }

        @NotNull
        public String getFamilyName() {
            return "Synchronize";
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
            VirtualFile vfile;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(0);
            }
            LocalDataSource dataSource2 = DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtils.findDataSource(vfile) : null;
            return dataSource2 != null && DbImplUtil.canConnectTo(dataSource2) && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource2);
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            LocalDataSource dataSource2;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(1);
            }
            LocalDataSource localDataSource = dataSource2 = DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtils.findDataSource(vfile) : null;
            if (dataSource2 == null) {
                return;
            }
            DasObject object = DbSrcUtils.findObject(file.getProject(), vfile.getPath(), DasObject.class);
            LoaderContext context = new LoaderContext(project, dataSource2);
            if (object == null) {
                context.includeAllSchemas();
            } else {
                context.include(object);
            }
            DataSourceUiUtil.performManualSyncTask(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$ReintrospectFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

