/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectName;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.intentions.SqlQualificationIntentionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQualifyIdentifierIntention
extends SqlQualificationIntentionBase {
    @NotNull
    public String getFamilyName() {
        return "Qualify identifier";
    }

    @NotNull
    private static JBIterable<ObjectName> getParentObjectNames(@Nullable SqlIdentifier identifier) {
        JBIterable jBIterable = JBIterable.from(SqlQualifyIdentifierIntention.getParentObjects(identifier)).filterMap(o -> SqlQualifyIdentifierIntention.getName(o));
        if (jBIterable == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    @Nullable
    private static PsiElement getQualifierElement(@NotNull ResolveResult result) {
        PomTarget immediateTarget;
        if (result == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(1);
        }
        PsiElement qualifier = (immediateTarget = SqlImplUtil.getPomTarget(SqlImplUtil.getImmediateTarget(result))) instanceof SqlColumnSymbol ? ((SqlColumnSymbol)immediateTarget).getQualifier() : null;
        return qualifier != null ? qualifier : SqlImplUtil.getQualifier(result);
    }

    @NotNull
    private static Collection<Object> getParentObjects(@Nullable SqlIdentifier identifier) {
        DasObject res2;
        if (identifier == null) {
            List<Object> list = Collections.emptyList();
            if (list == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(2);
            }
            return list;
        }
        LinkedHashSet<Object> parents2 = new LinkedHashSet<Object>();
        PsiElement parent2 = identifier.getParent();
        PsiPolyVariantReference ref = (PsiPolyVariantReference)ObjectUtils.tryCast((Object)parent2.getReference(), PsiPolyVariantReference.class);
        if (ref != null) {
            ResolveResult[] results2;
            for (ResolveResult result : results2 = ref.multiResolve(false)) {
                PsiElement qualifier = SqlQualifyIdentifierIntention.getQualifierElement(result);
                if (qualifier != null) {
                    ContainerUtil.addIfNotNull(parents2, (Object)qualifier);
                    continue;
                }
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)result.getElement(), DasObject.class);
                if (object != null) {
                    object = object.getDasParent();
                }
                ContainerUtil.addIfNotNull(parents2, (Object)object);
            }
        }
        if ((res2 = (DasObject)ObjectUtils.tryCast((Object)parent2, DasObject.class)) != null) {
            res2 = res2.getDasParent();
        }
        if (res2 != null) {
            ContainerUtil.addIfNotNull(parents2, (Object)res2);
        }
        LinkedHashSet<Object> linkedHashSet = parents2;
        if (linkedHashSet == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(4);
        }
        if (!(file instanceof SqlFile)) {
            return false;
        }
        return !JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).flatten(c2 -> SqlQualifyIdentifierIntention.getTopmostIdentifiers(file, c2)).flatten(id -> SqlQualifyIdentifierIntention.getParentObjectNames(id)).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(5);
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        int depth = 0;
        MultiMap names = MultiMap.createLinkedSet();
        for (SqlIdentifier identifier : JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).flatten(c2 -> SqlQualifyIdentifierIntention.getTopmostIdentifiers(file, c2))) {
            for (Object p2 : SqlQualifyIdentifierIntention.getParentObjects(identifier)) {
                ObjectName name;
                int d2 = SqlQualifyIdentifierIntention.getDepth(language, SqlQualifyIdentifierIntention.getKind(p2));
                if (depth > d2) continue;
                if (depth < d2) {
                    depth = d2;
                    names.clear();
                }
                if ((name = SqlQualifyIdentifierIntention.getName(p2)) == null) continue;
                names.putValue((Object)identifier, (Object)name);
            }
        }
        if (!names.isEmpty()) {
            this.performQualification((MultiMap<SqlIdentifier, ObjectName>)names, editor, file, language);
        }
    }

    protected void performQualification(MultiMap<SqlIdentifier, ObjectName> names, Editor editor, PsiFile file, SqlLanguageDialectEx language) {
        Document document = editor.getDocument();
        ArrayList<Pair> unique = new ArrayList<Pair>();
        ArrayList<Pair<RangeMarker, Collection<ObjectName>>> nonUnique = new ArrayList<Pair<RangeMarker, Collection<ObjectName>>>();
        for (Map.Entry entry : names.entrySet()) {
            RangeMarker marker = document.createRangeMarker(((SqlIdentifier)entry.getKey()).getTextRange());
            Collection variants = (Collection)entry.getValue();
            if (variants.size() == 1) {
                unique.add(Pair.create((Object)marker, (Object)variants));
                continue;
            }
            if (variants.size() <= 1) continue;
            nonUnique.add((Pair<RangeMarker, Collection<ObjectName>>)Pair.create((Object)marker, (Object)variants));
        }
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(file);
        Dbms dbms = SqlImplUtil.getDbms((PsiElement)file);
        if (!unique.isEmpty()) {
            this.runCommand(file.getProject(), editor, () -> {
                for (Pair pair : unique) {
                    SqlIntentionUtil.qualifyReference((RangeMarker)pair.first, (Iterable)pair.second, NamingServices.getNamingService(dbms), settings);
                }
            });
        }
        if (!nonUnique.isEmpty()) {
            this.qualifyWithChooser(file.getProject(), editor, language, settings, nonUnique, 0, dbms);
        }
    }

    private void runCommand(Project project, Editor editor, Runnable runnable) {
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)this.getText(), (String)this.getText(), (Runnable)runnable, (PsiFile[])new PsiFile[]{PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())});
    }

    private void qualifyWithChooser(Project project, Editor editor, SqlLanguageDialectEx language, SqlCodeStyleSettings settings, List<Pair<RangeMarker, Collection<ObjectName>>> nonUnique, int i2, @NotNull Dbms dbms) {
        if (dbms == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(6);
        }
        RangeMarker identifier = (RangeMarker)nonUnique.get((int)i2).first;
        List variants = JBIterable.from((Iterable)((Iterable)nonUnique.get((int)i2).second)).transform(Collections::singletonList).toList();
        NamingService namingService = NamingServices.getNamingService(dbms);
        SqlIntentionUtil.chooseQualifier(editor, identifier, variants, namingService, settings, language, (Consumer<? super Iterable<ObjectName>>)((Consumer)v -> {
            this.runCommand(project, editor, () -> SqlIntentionUtil.qualifyReference(identifier, v, namingService, settings));
            if (i2 + 1 < nonUnique.size()) {
                this.qualifyWithChooser(project, editor, language, settings, nonUnique, i2 + 1, dbms);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentObjectNames";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "qualifyWithChooser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

