/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0096\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceGroupByWithDistinctIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "createDistinctOption", "Lcom/intellij/sql/psi/SqlSelectOption;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "findApplicableGroupBy", "Lcom/intellij/sql/psi/SqlGroupByClause;", "context", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlReplaceGroupByWithDistinctIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace GROUP BY with DISTINCT";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.findApplicableGroupBy(element2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        SqlSelectOption optionToReplace;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        SqlGroupByClause sqlGroupByClause = this.findApplicableGroupBy(element2);
        if (sqlGroupByClause == null) {
            return;
        }
        SqlGroupByClause groupBy = sqlGroupByClause;
        SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)groupBy), SqlQueryExpression.class);
        if (sqlQueryExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQueryExpression, (String)"PsiTreeUtil.getParentOfT\u2026on::class.java) ?: return");
        SqlQueryExpression query = sqlQueryExpression;
        SqlSelectClause sqlSelectClause = query.getSelectClause();
        if (sqlSelectClause == null) {
            return;
        }
        SqlSelectClause selectClause = sqlSelectClause;
        List list = selectClause.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"selectClause.options");
        List options = list;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)query);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(query)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        SqlSelectOption distinctOption = this.createDistinctOption(dialect, project);
        SqlSelectOption sqlSelectOption = optionToReplace = dbms2.isCassandra() || dbms2.isClickHouse() ? null : (SqlSelectOption)CollectionsKt.firstOrNull((List)options);
        if (optionToReplace != null) {
            optionToReplace.replace((PsiElement)distinctOption);
        } else {
            SqlSelectOption sqlSelectOption2 = (SqlSelectOption)CollectionsKt.lastOrNull((List)options);
            PsiElement anchor = sqlSelectOption2 != null ? (PsiElement)sqlSelectOption2 : selectClause.getFirstChild();
            PsiElement newOption = selectClause.addAfter((PsiElement)distinctOption, anchor);
            CodeStyleManager.getInstance((Project)project).reformat(newOption);
        }
        groupBy.delete();
    }

    /*
     * WARNING - void declaration
     */
    private final SqlGroupByClause findApplicableGroupBy(PsiElement context) {
        void $this$mapTo$iv;
        void $this$mapTo$iv2;
        Collection destination$iv$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        SqlSelectClause selectClause;
        SqlGroupByClause groupBy;
        block23: {
            if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)context), (Object)SqlCommonKeywords.SQL_GROUP) ^ true) {
                return null;
            }
            PsiElement psiElement = context.getParent();
            if (!(psiElement instanceof SqlGroupByClause)) {
                psiElement = null;
            }
            SqlGroupByClause sqlGroupByClause = (SqlGroupByClause)psiElement;
            if (sqlGroupByClause == null) {
                return null;
            }
            groupBy = sqlGroupByClause;
            SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)groupBy), SqlQueryExpression.class);
            if (sqlQueryExpression == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlQueryExpression, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
            SqlQueryExpression query = sqlQueryExpression;
            SqlSelectClause sqlSelectClause = query.getSelectClause();
            if (sqlSelectClause == null) {
                return null;
            }
            selectClause = sqlSelectClause;
            List list = selectClause.getOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"selectClause.options");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    SqlSelectOption it2 = (SqlSelectOption)element$iv2;
                    boolean bl2 = false;
                    SqlSelectOption sqlSelectOption = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlSelectOption, (String)"it");
                    if (!(StringsKt.equals((String)sqlSelectOption.getName(), (String)"distinct", (boolean)true) || StringsKt.equals((String)it2.getName(), (String)"distinctrow", (boolean)true))) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        List list = selectClause.getExpressions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"selectClause.expressions");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        SqlExpression[] destination$iv$iv2 = (SqlExpression[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            SqlExpression sqlExpression = (SqlExpression)item$iv$iv;
            object2 = destination$iv$iv2;
            int n = 0;
            Object v8 = it3;
            if (!(v8 instanceof SqlReferenceExpression)) {
                v8 = null;
            }
            if ((SqlReferenceExpression)v8 == null) {
                return null;
            }
            object2.add(object);
        }
        List outputRefs = (List)destination$iv$iv2;
        SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupBy), SqlExpression.class);
        if (sqlExpressionArray != null) {
            void $this$mapTo$iv$iv2;
            SqlExpression[] $this$map$iv2 = sqlExpressionArray;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it4;
                Object t = item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl3 = false;
                Object v10 = it4;
                if (!(v10 instanceof SqlReferenceExpression)) {
                    v10 = null;
                }
                if ((SqlReferenceExpression)v10 == null) {
                    return null;
                }
                object2.add(object);
            }
        } else {
            return null;
        }
        List groupRefs = (List)destination$iv$iv;
        Iterable $i$f$map2 = outputRefs;
        Iterable destination$iv = new HashSet();
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            Object object3;
            Object item$iv$iv;
            SqlReferenceExpression it3 = (SqlReferenceExpression)item$iv;
            object2 = destination$iv;
            boolean bl4 = false;
            item$iv$iv = SqlImplUtil.resolveQualified(it3);
            boolean bl5 = false;
            if (item$iv$iv.isEmpty()) {
                boolean bl6 = false;
                object3 = it3.getText();
            } else {
                object3 = item$iv$iv;
            }
            object = object3;
            object2.add(object);
        }
        HashSet outputTargets = (HashSet)destination$iv;
        destination$iv = groupRefs;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo3 = false;
        for (Object item$iv : $this$mapTo$iv) {
            Object object4;
            void it5;
            SqlReferenceExpression bl4 = (SqlReferenceExpression)item$iv;
            object2 = destination$iv2;
            boolean bl7 = false;
            Collection collection = SqlImplUtil.resolveQualified((SqlReferenceExpression)it5);
            boolean bl8 = false;
            if (collection.isEmpty()) {
                boolean bl9 = false;
                object4 = it5.getText();
            } else {
                object4 = collection;
            }
            object = object4;
            object2.add(object);
        }
        HashSet groupTargets = (HashSet)destination$iv2;
        SqlGroupByClause sqlGroupByClause = groupBy;
        boolean bl10 = false;
        boolean bl11 = false;
        SqlGroupByClause it6 = sqlGroupByClause;
        boolean bl12 = false;
        return Intrinsics.areEqual((Object)outputTargets, (Object)groupTargets) ? sqlGroupByClause : null;
    }

    private final SqlSelectOption createDistinctOption(SqlLanguageDialect dialect, Project project) {
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).keyword("distinct");
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"DdlBuilder().configureBu\u2026lect).keyword(\"distinct\")");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DdlBuilder().configureBu\u2026ord(\"distinct\").statement");
        String text2 = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText("select " + text2 + " id from foo", dialect, project);
        if (sqlQueryExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQueryExpression, (String)"createQueryExpressionFro\u2026foo\", dialect, project)!!");
        SqlQueryExpression query = sqlQueryExpression;
        SqlSelectClause sqlSelectClause = query.getSelectClause();
        if (sqlSelectClause == null) {
            Intrinsics.throwNpe();
        }
        List list = sqlSelectClause.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"query.selectClause!!.options");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"query.selectClause!!.options.first()");
        return (SqlSelectOption)object;
    }
}

