/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.util.DbImplUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlAllNameIndex;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlDefinitionStubElementType;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDefinitionExStubElementType<S extends SqlDefinitionStub<T>, T extends SqlDefinition>
extends SqlDefinitionStubElementType<S, T> {
    public SqlDefinitionExStubElementType(@NonNls @NotNull String debugName, @Nullable SqlReferenceElementType refType) {
        if (debugName == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, refType);
    }

    @Override
    public void indexStub(@NotNull S stub, @NotNull IndexSink sink) {
        if (stub == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(2);
        }
        SqlDefinitionExStubElementType.indexNamedStub(stub, SqlAllNameIndex.KEY, sink);
    }

    @Override
    public void serialize(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(4);
        }
        super.serialize(stub, dataStream);
        SqlDefinitionExStubElementType.saveProperties(dataStream, ((SqlDefinitionStub)((Object)stub)).myElement, ((SqlDefinitionStub)((Object)stub)).myProperties);
    }

    @Override
    @NotNull
    public S deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(5);
        }
        return (S)((Object)new SqlDefinitionStub(parentStub, this, dataStream.readName(), SqlDefinitionExStubElementType.loadProperties(parentStub, dataStream)));
    }

    @Override
    @NotNull
    public S createStub(@NotNull T psi, StubElement parentStub) {
        if (psi == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(6);
        }
        return (S)((Object)new SqlDefinitionStub(parentStub, this, SqlDefinitionExStubElementType.asStringRef((PsiElement)psi.getNameElement()), SqlDefinitionExStubElementType.buildProperties(psi)));
    }

    public static void saveProperties(@NotNull StubOutputStream dataStream, @NotNull BasicElement element2, @NotNull Map<String, String> properties) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(9);
        }
        SqlDefinitionExStubElementType.saveMetaObject(dataStream, element2.getMetaObject());
        ArrayList objProps = new ArrayList();
        element2.exportProperties((n, v) -> objProps.add(new NameValue(n, (String)v)));
        dataStream.writeVarInt(properties.size() + objProps.size());
        for (NameValue nameValue : objProps) {
            dataStream.writeName(nameValue.getName());
            dataStream.writeUTFFast(nameValue.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            dataStream.writeName((String)entry.getKey());
            dataStream.writeUTFFast((String)entry.getValue());
        }
    }

    protected static void saveMetaObject(@NotNull StubOutputStream dataStream, BasicMetaObject<?> meta) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(10);
        }
        for (BasicMetaObject<?> tmp = meta; tmp != null; tmp = tmp.getParent()) {
            dataStream.writeName(tmp.kind.code());
        }
    }

    @NotNull
    public static SqlDefinitionStub.ModelInfo loadProperties(@Nullable StubElement<?> parent2, @NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(11);
        }
        BasicMetaModel metaModel = DbImplUtil.getMetaModel(SqlDefinitionExStubElementType.getDbms(parent2));
        BasicMetaObject<?> meta = SqlDefinitionExStubElementType.loadMetaObject(metaModel, dataStream);
        Object element2 = meta.newDataObject();
        int cnt = dataStream.readVarInt();
        if (cnt == 0) {
            return new SqlDefinitionStub.ModelInfo((BasicElement)element2, Collections.emptyMap());
        }
        HashMap<String, String> objectProps = new HashMap<String, String>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i2 = 0; i2 < cnt; ++i2) {
            String prop = dataStream.readNameString();
            if (prop == null) {
                throw new IOException("Prop name is null");
            }
            String value2 = dataStream.readUTFFast();
            BasicMetaProperty<?> property = BasicMetaUtils.findProperty(meta.properties, prop);
            if (property == null) {
                builder.put((Object)prop, (Object)value2);
                continue;
            }
            objectProps.put(prop, value2);
        }
        element2.importProperties(objectProps);
        return new SqlDefinitionStub.ModelInfo((BasicElement)element2, (Map<String, String>)builder.build());
    }

    @NotNull
    protected static Dbms getDbms(@Nullable StubElement<?> parent2) throws IOException {
        SqlLanguageDialect dialect;
        while (parent2 != null && !(parent2 instanceof PsiFileStub)) {
            parent2 = parent2.getParentStub();
        }
        PsiFileStub fileStub = (PsiFileStub)ObjectUtils.tryCast(parent2, PsiFileStub.class);
        SqlLanguageDialect sqlLanguageDialect = dialect = fileStub == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)fileStub.getType().getLanguage(), SqlLanguageDialect.class);
        if (dialect == null) {
            throw new IOException("No sql language");
        }
        Dbms dbms = dialect.getDbms();
        if (dbms == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(12);
        }
        return dbms;
    }

    private static BasicMetaObject<?> loadMetaObject(BasicMetaModel metaModel, StubInputStream dataStream) throws IOException {
        ArrayList<ObjectKind> path = new ArrayList<ObjectKind>(6);
        while (true) {
            String code;
            ObjectKind kind;
            if ((kind = (ObjectKind)ObjectKind.ourKinds.get(code = dataStream.readNameString())) == null) {
                throw new IOException("No kind " + code);
            }
            if (kind == ObjectKind.ROOT) break;
            path.add(kind);
        }
        BasicMetaObject<Object> meta = metaModel.root;
        for (int i2 = path.size() - 1; i2 >= 0; --i2) {
            ObjectKind kind = (ObjectKind)path.get(i2);
            BasicMetaObject next = BasicMetaUtils.findChild(meta, kind);
            if (next == null) {
                throw new IOException("No " + kind.code() + " in " + meta.toString());
            }
            meta = next;
        }
        return meta;
    }

    @NotNull
    public static SqlDefinitionStub.ModelInfo buildProperties(@NotNull SqlDefinition def) {
        BasicMetaObject<?> meta;
        if (def == null) {
            SqlDefinitionExStubElementType.$$$reportNull$$$0(13);
        }
        if ((meta = SqlImplUtil.getMetaObject((DasObject)def)) == null) {
            Object stub = DbImplUtil.getMetaModel((Dbms)Dbms.UNKNOWN).root.newDataObject();
            return new SqlDefinitionStub.ModelInfo((BasicElement)stub, Collections.emptyMap());
        }
        Dbms dbms = DbImplUtil.getDbms((PsiElement)def);
        Object element2 = meta.newDataObject();
        ((SqlObjectBuilder)SqlObjectBuilder.EP.forDbms(dbms)).build(element2, (DasObject)def, SqlObjectBuilder.Context.STUB);
        return new SqlDefinitionStub.ModelInfo((BasicElement)element2, Collections.emptyMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlDefinitionExStubElementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlDefinitionExStubElementType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveMetaObject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadProperties";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

