/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.extractFunction.RefInfo;
import com.intellij.sql.refactoring.extractFunction.SqlDelegatingParameterInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b*\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\n\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u000b\u001a \u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0014H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00060\u00060\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"PARAM_OCCURRENCE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "REF_INFO", "Lcom/intellij/sql/refactoring/extractFunction/RefInfo;", "analyzeConflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "copy", "name", "createBuilder", "Lcom/intellij/database/util/DdlBuilder;", "processReferences", "", "Lcom/intellij/sql/psi/SqlExpression;", "action", "Lkotlin/Function1;", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "intellij.database.sql.impl"})
public final class SqlExtractableCodeInfoKt {
    private static final Key<RefInfo> REF_INFO;
    private static final Key<SqlExtractableParameterInfo> PARAM_OCCURRENCE;

    @NotNull
    public static final SqlExtractableParameterInfo copy(@NotNull SqlExtractableParameterInfo $this$copy, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$this$copy");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new SqlDelegatingParameterInfo($this$copy.getOriginal(), name);
    }

    private static final void processReferences(@NotNull SqlExpression $this$processReferences, Function1<? super SqlReferenceExpression, Unit> action2) {
        $this$processReferences.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(action2){
            final /* synthetic */ Function1 $action;

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                if (element2 instanceof SqlReferenceExpression) {
                    this.$action.invoke((Object)element2);
                } else {
                    super.visitElement(element2);
                }
            }
            {
                this.$action = $captured_local_variable$0;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MultiMap<PsiElement, String> analyzeConflicts(@NotNull SqlExtractFunctionInfo $this$analyzeConflicts) {
        DataType dataType;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$analyzeConflicts, (String)"$this$analyzeConflicts");
        MultiMap conflicts = new MultiMap();
        DdlBuilder ddlBuilder = SqlExtractableCodeInfoKt.createBuilder($this$analyzeConflicts).identifier($this$analyzeConflicts.getName(), ObjectKind.ROUTINE);
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"createBuilder().identifi\u2026name, ObjectKind.ROUTINE)");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"createBuilder().identifi\u2026ctKind.ROUTINE).statement");
        String name = string;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(name + "()", $this$analyzeConflicts.getCodeInfo().getDialect(), (PsiElement)$this$analyzeConflicts.getCodeInfo().getContainer());
        if (sqlExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlFunctionCallExpression");
        }
        SqlFunctionCallExpression call = (SqlFunctionCallExpression)sqlExpression;
        ResolveResult[] $this$map$iv = (ResolveResult[])$this$analyzeConflicts.getParameters();
        boolean $i$f$map = false;
        ResolveResult[] resolveResultArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            dataType = it2.getSqlType().getDataType();
            collection.add(dataType);
        }
        List newSignature = (List)destination$iv$iv;
        ResolveResult[] resolveResultArray2 = call.getNameElement();
        if (resolveResultArray2 == null || (resolveResultArray2 = resolveResultArray2.multiResolve(true)) == null) {
            resolveResultArray2 = ResolveResult.EMPTY_ARRAY;
        }
        resolveResultArray = resolveResultArray2;
        int n = resolveResultArray.length;
        for (int j = 0; j < n; ++j) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            PomTarget target;
            ResolveResult result;
            ResolveResult resolveResult = result = resolveResultArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResult, (String)"result");
            if (!resolveResult.isValidResult()) continue;
            PsiElement element2 = result.getElement();
            PomTarget pomTarget = SqlImplUtil.getPomTarget(element2);
            if (pomTarget == null) {
                pomTarget = target = element2;
            }
            if (!(target instanceof DasRoutine)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)((DasRoutine)target).getArguments(), (String)"target.arguments");
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                DasArgument dasArgument = (DasArgument)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                void v6 = it3;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                dataType = v6.getDataType();
                collection.add(dataType);
            }
            List existingSignature = (List)destination$iv$iv2;
            if (!Intrinsics.areEqual((Object)existingSignature, (Object)newSignature)) continue;
            String identity = ModelUtil.calculateRoutineIdentityByType(((DasRoutine)target).getName(), existingSignature);
            conflicts.putValue((Object)element2, (Object)("New function might conflict with " + identity));
        }
        return conflicts;
    }

    @NotNull
    public static final DdlBuilder createBuilder(@NotNull SqlExtractFunctionInfo $this$createBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createBuilder, (String)"$this$createBuilder");
        SqlLanguageDialectEx dialect = $this$createBuilder.getCodeInfo().getDialect();
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder($this$createBuilder.getCodeInfo().getProject(), dialect).withDialect(dialect.getDatabaseDialect()).suppressQuoteIdentifiers(true);
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"DdlBuilder()\n    .config\u2026essQuoteIdentifiers(true)");
        return ddlBuilder;
    }

    static {
        Key key = Key.create((String)"REF_INFO");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<RefInfo>(\"REF_INFO\")");
        REF_INFO = key;
        Key key2 = Key.create((String)"PARAM_OCCURRENCE");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<SqlExtractabl\u2026Info>(\"PARAM_OCCURRENCE\")");
        PARAM_OCCURRENCE = key2;
    }

    public static final /* synthetic */ void access$processReferences(SqlExpression $this$access_u24processReferences, Function1 action2) {
        SqlExtractableCodeInfoKt.processReferences($this$access_u24processReferences, (Function1<? super SqlReferenceExpression, Unit>)action2);
    }

    public static final /* synthetic */ Key access$getREF_INFO$p() {
        return REF_INFO;
    }

    public static final /* synthetic */ Key access$getPARAM_OCCURRENCE$p() {
        return PARAM_OCCURRENCE;
    }
}

