/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    public static boolean isDebugDisposerOn() {
        return "on".equals(System.getProperty("idea.disposer.debug"));
    }

    private Disposer() {
    }

    @NotNull
    public static Disposable newDisposable() {
        return Disposer.newDisposable(null);
    }

    @NotNull
    public static Disposable newDisposable(final @Nullable String debugName) {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName == null ? super.toString() : debugName;
            }
        };
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(0);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(1);
        }
        ourTree.register(parent, child);
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, @NonNls @NotNull String key) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(2);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(3);
        }
        if (key == null) {
            Disposer.$$$reportNull$$$0(4);
        }
        Disposer.register(parent, child);
        Disposable v = Disposer.get(key);
        if (v != null) {
            throw new IllegalArgumentException("Key " + key + " already registered: " + v);
        }
        ourKeyDisposables.put(key, child);
        Disposer.register(child, new KeyDisposable(key));
    }

    public static boolean isDisposed(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(5);
        }
        return ourTree.getDisposalInfo(disposable) != null;
    }

    public static boolean isDisposing(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(6);
        }
        return ourTree.isDisposing(disposable);
    }

    public static Disposable get(@NotNull String key) {
        if (key == null) {
            Disposer.$$$reportNull$$$0(7);
        }
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(8);
        }
        Disposer.dispose(disposable, true);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void disposeChildren(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(9);
        }
        ourTree.executeAll(disposable, false, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(10);
        }
        ourTree.executeAll(disposable, processUnregistered, false);
    }

    @NotNull
    public static ObjectTree getTree() {
        ObjectTree objectTree = ourTree;
        if (objectTree == null) {
            Disposer.$$$reportNull$$$0(11);
        }
        return objectTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean setDebugMode(boolean debugMode) {
        if (debugMode) {
            debugMode = !"off".equals(System.getProperty("idea.disposer.debug"));
        }
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(12);
        }
        if (object == null) {
            Disposer.$$$reportNull$$$0(13);
        }
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(14);
        }
        return ObjectUtils.tryCast(Disposer.getTree().getDisposalInfo(disposable), Throwable.class);
    }

    public static void clearDisposalTraces() {
        ourTree.clearDisposedObjectTraces();
    }

    static {
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disposeChildren";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalTrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class KeyDisposable
    implements Disposable {
        @NotNull
        private final String myKey;

        KeyDisposable(@NotNull String key) {
            if (key == null) {
                KeyDisposable.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Override
        public void dispose() {
            ourKeyDisposables.remove(this.myKey);
        }

        public String toString() {
            return "KeyDisposable (" + this.myKey + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/Disposer$KeyDisposable", "<init>"));
        }
    }
}

