/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentMultiMap<K, V>
extends MultiMap<K, V> {
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_CONCURRENCY_LEVEL = ConcurrentIntObjectHashMap.NCPU;

    public ConcurrentMultiMap() {
    }

    public ConcurrentMultiMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    @NotNull
    protected ConcurrentMap<K, Collection<V>> createMap() {
        Map map = this.createMap(16, 0.75f);
        if (map == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Override
    @NotNull
    protected ConcurrentMap<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, DEFAULT_CONCURRENCY_LEVEL);
        if (concurrentMap == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    @Override
    @NotNull
    protected Collection<V> createCollection() {
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        if (list == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void putValue(@NotNull K key, V value) {
        Collection<V> collection;
        if (key == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(3);
        }
        if ((collection = (Collection<V>)this.myMap.get(key)) == null) {
            Collection<V> newCollection = this.createCollection();
            collection = ConcurrencyUtil.cacheOrGet((ConcurrentMap)this.myMap, key, newCollection);
        }
        collection.add(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentMultiMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentMultiMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

