/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangedFileLinesMapper;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangedFileLinesMapperImpl;
import org.jetbrains.plugins.github.util.GHPatchHunkUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 #2\u00020\u0001:\u0004\"#$%B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\b\u001a\u001a\u0004\b\u0019\u0010\fR\u001b\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0013\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002&'\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData;", "", "commitSha", "", "filePath", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "cumulativePatch", "fileHistory", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;)V", "getCommitSha", "()Ljava/lang/String;", "diffRanges", "", "Lcom/intellij/diff/util/Range;", "getDiffRanges", "()Ljava/util/List;", "diffRanges$delegate", "Lkotlin/Lazy;", "diffRangesWithoutContext", "getDiffRangesWithoutContext", "diffRangesWithoutContext$delegate", "getFileHistory", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;", "getFilePath", "filePath$1", "linesMapper", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangedFileLinesMapper;", "getLinesMapper", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangedFileLinesMapper;", "linesMapper$delegate", "contains", "", "Commit", "Companion", "Cumulative", "FileHistory", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$Commit;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$Cumulative;", "intellij.vcs.github"})
public abstract class GHPRChangeDiffData {
    @NotNull
    private final Lazy diffRanges$delegate;
    @NotNull
    private final Lazy diffRangesWithoutContext$delegate;
    @NotNull
    private final Lazy linesMapper$delegate;
    @NotNull
    private final String commitSha;
    @NotNull
    private final String filePath$1;
    private final TextFilePatch patch;
    private final TextFilePatch cumulativePatch;
    @NotNull
    private final FileHistory fileHistory;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Range> getDiffRanges() {
        Lazy lazy = this.diffRanges$delegate;
        GHPRChangeDiffData gHPRChangeDiffData = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<Range> getDiffRangesWithoutContext() {
        Lazy lazy = this.diffRangesWithoutContext$delegate;
        GHPRChangeDiffData gHPRChangeDiffData = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final GHPRChangedFileLinesMapper getLinesMapper() {
        Lazy lazy = this.linesMapper$delegate;
        GHPRChangeDiffData gHPRChangeDiffData = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GHPRChangedFileLinesMapper)lazy.getValue();
    }

    public final boolean contains(@NotNull String commitSha, @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)commitSha, (String)"commitSha");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return this.fileHistory.contains(commitSha, filePath);
    }

    @NotNull
    public final String getCommitSha() {
        return this.commitSha;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath$1;
    }

    @NotNull
    protected final FileHistory getFileHistory() {
        return this.fileHistory;
    }

    private GHPRChangeDiffData(String commitSha, String filePath, TextFilePatch patch, TextFilePatch cumulativePatch, FileHistory fileHistory) {
        this.commitSha = commitSha;
        this.filePath$1 = filePath;
        this.patch = patch;
        this.cumulativePatch = cumulativePatch;
        this.fileHistory = fileHistory;
        this.diffRanges$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends Range>>(this){
            final /* synthetic */ GHPRChangeDiffData this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Range> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2 = GHPRChangeDiffData.access$getPatch$p(this.this$0).getHunks();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"patch.hunks");
                Iterable iterable = list2;
                GHPatchHunkUtil gHPatchHunkUtil = GHPatchHunkUtil.INSTANCE;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    PatchHunk patchHunk = (PatchHunk)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Range range = gHPatchHunkUtil.getRange((PatchHunk)p1);
                    collection.add(range);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = gHPRChangeDiffData;
                super(0);
            }
        }));
        this.diffRangesWithoutContext$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends Range>>(this){
            final /* synthetic */ GHPRChangeDiffData this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Range> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2 = GHPRChangeDiffData.access$getPatch$p(this.this$0).getHunks();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"patch.hunks");
                Iterable iterable = list2;
                GHPatchHunkUtil gHPatchHunkUtil = GHPatchHunkUtil.INSTANCE;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    PatchHunk patchHunk = (PatchHunk)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List<Range> list3 = gHPatchHunkUtil.getChangeOnlyRanges((PatchHunk)p1);
                    collection.add(list3);
                }
                return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            }
            {
                this.this$0 = gHPRChangeDiffData;
                super(0);
            }
        }));
        this.linesMapper$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<GHPRChangedFileLinesMapperImpl>(this){
            final /* synthetic */ GHPRChangeDiffData this$0;

            @NotNull
            public final GHPRChangedFileLinesMapperImpl invoke() {
                return new GHPRChangedFileLinesMapperImpl(GHPRChangeDiffData.access$getCumulativePatch$p(this.this$0));
            }
            {
                this.this$0 = gHPRChangeDiffData;
                super(0);
            }
        }));
    }

    public /* synthetic */ GHPRChangeDiffData(String commitSha, String filePath, TextFilePatch patch, TextFilePatch cumulativePatch, FileHistory fileHistory, DefaultConstructorMarker $constructor_marker) {
        this(commitSha, filePath, patch, cumulativePatch, fileHistory);
    }

    public static final /* synthetic */ TextFilePatch access$getPatch$p(GHPRChangeDiffData $this) {
        return $this.patch;
    }

    public static final /* synthetic */ TextFilePatch access$getCumulativePatch$p(GHPRChangeDiffData $this) {
        return $this.cumulativePatch;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u001fB\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "commitHashes", "", "(Ljava/util/List;)V", "filePath", "getFilePath", "()Ljava/lang/String;", "history", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory$Entry;", "initialFilePath", "getInitialFilePath", "append", "", "commitSha", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "compare", "", "commitSha1", "commitSha2", "contains", "", "getPatches", "fromCommit", "toCommit", "dropHead", "dropTail", "Entry", "intellij.vcs.github"})
    public static final class FileHistory
    implements Comparator<String> {
        private final Map<String, Entry> history;

        @Nullable
        public final String getInitialFilePath() {
            Entry entry;
            Object v0;
            boolean bl;
            Object object;
            block2: {
                object = this.history.values();
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    Entry it = (Entry)t;
                    boolean bl3 = false;
                    if (!(it.getPatch() != null)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((entry = (Entry)v0) == null || (entry = entry.getPatch()) == null) {
                object = "Empty history";
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            return entry.getBeforeName();
        }

        @Nullable
        public final String getFilePath() {
            Object object = this.history.values();
            boolean bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            Object var6_5 = null;
            for (Object t : iterable) {
                Entry it = (Entry)t;
                boolean bl3 = false;
                if (!(it.getPatch() != null)) continue;
                var6_5 = t;
            }
            Entry entry = var6_5;
            if (entry == null || (entry = entry.getPatch()) == null) {
                object = "Empty history";
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            String lastFilePath = entry.getAfterName();
            String string = lastFilePath;
            if (string == null) {
                string = this.getInitialFilePath();
            }
            return string;
        }

        public final void append(@NotNull String commitSha, @NotNull TextFilePatch patch) {
            Intrinsics.checkParameterIsNotNull((Object)commitSha, (String)"commitSha");
            Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
            Entry entry = this.history.get(commitSha);
            boolean bl = entry != null && entry.getPatch() == null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.history.put(commitSha, new Entry(patch));
        }

        /*
         * WARNING - void declaration
         */
        public final boolean contains(@NotNull String commitSha, @NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)commitSha, (String)"commitSha");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            String lastPath = null;
            Object object = this.history;
            boolean bl = false;
            Iterator<Map.Entry<String, Entry>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void sha;
                Map.Entry<String, Entry> entry;
                Map.Entry<String, Entry> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Entry entry3 = entry2.getValue();
                String entryPath = entry3.getFilePath();
                if (entryPath != null) {
                    lastPath = entryPath;
                }
                if (!Intrinsics.areEqual((Object)sha, (Object)commitSha) || !Intrinsics.areEqual((Object)lastPath, (Object)filePath)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(@NotNull String commitSha1, @NotNull String commitSha2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)commitSha1, (String)"commitSha1");
            Intrinsics.checkParameterIsNotNull((Object)commitSha2, (String)"commitSha2");
            if (Intrinsics.areEqual((Object)commitSha1, (Object)commitSha2)) {
                return 0;
            }
            Map<String, Entry> map2 = this.history;
            boolean bl = false;
            Iterator<Map.Entry<String, Entry>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                String sha = (String)object2.getKey();
                if (Intrinsics.areEqual((Object)sha, (Object)commitSha1)) {
                    return -1;
                }
                if (!Intrinsics.areEqual((Object)sha, (Object)commitSha2)) continue;
                return 1;
            }
            object = "Unknown commit sha";
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<TextFilePatch> getPatches(@NotNull String fromCommit, @NotNull String toCommit, boolean dropHead, boolean dropTail) {
            Intrinsics.checkParameterIsNotNull((Object)fromCommit, (String)"fromCommit");
            Intrinsics.checkParameterIsNotNull((Object)toCommit, (String)"toCommit");
            boolean bl = false;
            List patches = new ArrayList();
            boolean foundFrom = false;
            TextFilePatch lastFound = null;
            Object object = this.history;
            boolean bl2 = false;
            Iterator<Map.Entry<String, Entry>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                TextFilePatch it;
                boolean bl3;
                void sha;
                TextFilePatch textFilePatch;
                TextFilePatch textFilePatch2 = textFilePatch = iterator.next();
                boolean bl4 = false;
                object = textFilePatch2.getKey();
                textFilePatch2 = textFilePatch;
                bl4 = false;
                Entry entry = textFilePatch2.getValue();
                if (!foundFrom) {
                    if (entry.getPatch() != null) {
                        lastFound = entry.getPatch();
                    }
                    if (!Intrinsics.areEqual((Object)sha, (Object)fromCommit)) continue;
                    foundFrom = true;
                    if (dropHead) continue;
                    TextFilePatch textFilePatch3 = entry.getPatch();
                    if (textFilePatch3 == null) {
                        textFilePatch3 = lastFound;
                    }
                    if (textFilePatch3 == null) {
                        String string = "Original patch was not found";
                        bl3 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    TextFilePatch patchToAdd = textFilePatch3;
                    patches.add(patchToAdd);
                    continue;
                }
                if (dropTail) {
                    if (Intrinsics.areEqual((Object)sha, (Object)toCommit)) break;
                    TextFilePatch textFilePatch4 = entry.getPatch();
                    if (textFilePatch4 != null) {
                        textFilePatch2 = textFilePatch4;
                        bl4 = false;
                        bl3 = false;
                        it = textFilePatch2;
                        boolean bl5 = false;
                        patches.add(it);
                    }
                    continue;
                }
                TextFilePatch textFilePatch5 = entry.getPatch();
                if (textFilePatch5 != null) {
                    textFilePatch2 = textFilePatch5;
                    bl4 = false;
                    bl3 = false;
                    it = textFilePatch2;
                    boolean bl6 = false;
                    patches.add(it);
                }
                if (!Intrinsics.areEqual((Object)sha, (Object)toCommit)) continue;
                break;
            }
            return patches;
        }

        public FileHistory(@NotNull List<String> commitHashes) {
            Intrinsics.checkParameterIsNotNull(commitHashes, (String)"commitHashes");
            this.history = new LinkedHashMap();
            for (String sha : commitHashes) {
                this.history.put(sha, new Entry(null));
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory$Entry;", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)V", "filePath", "", "getFilePath", "()Ljava/lang/String;", "getPatch", "()Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "intellij.vcs.github"})
        private static final class Entry {
            @Nullable
            private final String filePath;
            @Nullable
            private final TextFilePatch patch;

            @Nullable
            public final String getFilePath() {
                return this.filePath;
            }

            @Nullable
            public final TextFilePatch getPatch() {
                return this.patch;
            }

            public Entry(@Nullable TextFilePatch patch) {
                TextFilePatch textFilePatch = this.patch = patch;
                this.filePath = textFilePatch != null ? Companion.getFilePath(textFilePatch) : null;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J<\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$Commit;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData;", "commitSha", "", "filePath", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "cumulativePatch", "fileHistory", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;)V", "mapPosition", "Lkotlin/Pair;", "Lcom/intellij/diff/util/Side;", "", "fromCommitSha", "side", "line", "reverseRange", "Lcom/intellij/diff/util/Range;", "range", "transferLine", "patchChain", "", "rightToLeft", "", "intellij.vcs.github"})
    public static final class Commit
    extends GHPRChangeDiffData {
        @Nullable
        public final Pair<Side, Integer> mapPosition(@NotNull String fromCommitSha, @NotNull Side side, int line) {
            Intrinsics.checkParameterIsNotNull((Object)fromCommitSha, (String)"fromCommitSha");
            Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
            int comparison = this.getFileHistory().compare(fromCommitSha, this.getCommitSha());
            if (comparison == 0) {
                return TuplesKt.to((Object)side, (Object)line);
            }
            if (comparison < 0) {
                List<TextFilePatch> patches = this.getFileHistory().getPatches(fromCommitSha, this.getCommitSha(), false, true);
                return this.transferLine(patches, side, line, false);
            }
            List<TextFilePatch> patches = this.getFileHistory().getPatches(this.getCommitSha(), fromCommitSha, true, false);
            return this.transferLine(patches, side, line, true);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Side, Integer> transferLine(List<? extends TextFilePatch> patchChain, Side side, int line, boolean rightToLeft) {
            if (patchChain.isEmpty()) {
                return TuplesKt.to((Object)side, (Object)line);
            }
            List patches = rightToLeft ? CollectionsKt.asReversed(patchChain) : patchChain;
            Side transferFrom = rightToLeft ? Side.RIGHT : Side.LEFT;
            Side currentSide = side;
            int currentLine = line;
            for (TextFilePatch patch : patches) {
                if (currentSide == transferFrom) {
                    void $this$mapTo$iv$iv;
                    List list2 = patch.getHunks();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"patch.hunks");
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        List list3;
                        void hunk;
                        PatchHunk patchHunk = (PatchHunk)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        void v1 = hunk;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"hunk");
                        List ranges = GHPatchHunkUtil.INSTANCE.getChangeOnlyRanges((PatchHunk)v1);
                        if (rightToLeft) {
                            void $this$mapTo$iv$iv2;
                            Iterable $this$map$iv2 = ranges;
                            boolean $i$f$map2 = false;
                            Iterable iterable2 = $this$map$iv2;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                void it;
                                Range range = (Range)item$iv$iv2;
                                Collection collection2 = destination$iv$iv2;
                                boolean bl2 = false;
                                Range range2 = this.reverseRange((Range)it);
                                collection2.add(range2);
                            }
                            list3 = (List)destination$iv$iv2;
                        } else {
                            list3 = ranges;
                        }
                        List list4 = list3;
                        collection.add(list4);
                    }
                    List changeOnlyRanges = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    int offset = 0;
                    for (Range range : changeOnlyRanges) {
                        if (currentLine < range.start1) break;
                        int n = currentLine;
                        if (range.start1 <= n && range.end1 > n) {
                            return null;
                        }
                        if (currentLine < range.end1) continue;
                        offset += range.end2 - range.start2 - (range.end1 - range.start1);
                    }
                    currentLine += offset;
                    continue;
                }
                currentSide = transferFrom;
            }
            return TuplesKt.to((Object)currentSide, (Object)currentLine);
        }

        private final Range reverseRange(Range range) {
            return new Range(range.start2, range.end2, range.start1, range.end1);
        }

        public Commit(@NotNull String commitSha, @NotNull String filePath, @NotNull TextFilePatch patch, @NotNull TextFilePatch cumulativePatch, @NotNull FileHistory fileHistory) {
            Intrinsics.checkParameterIsNotNull((Object)commitSha, (String)"commitSha");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
            Intrinsics.checkParameterIsNotNull((Object)cumulativePatch, (String)"cumulativePatch");
            Intrinsics.checkParameterIsNotNull((Object)fileHistory, (String)"fileHistory");
            super(commitSha, filePath, patch, cumulativePatch, fileHistory, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$Cumulative;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData;", "commitSha", "", "filePath", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "fileHistory", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$FileHistory;)V", "intellij.vcs.github"})
    public static final class Cumulative
    extends GHPRChangeDiffData {
        public Cumulative(@NotNull String commitSha, @NotNull String filePath, @NotNull TextFilePatch patch, @NotNull FileHistory fileHistory) {
            Intrinsics.checkParameterIsNotNull((Object)commitSha, (String)"commitSha");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
            Intrinsics.checkParameterIsNotNull((Object)fileHistory, (String)"fileHistory");
            super(commitSha, filePath, patch, patch, fileHistory, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData$Companion;", "", "()V", "filePath", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getFilePath", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)Ljava/lang/String;", "intellij.vcs.github"})
    public static final class Companion {
        private final String getFilePath(@NotNull TextFilePatch $this$filePath) {
            String string = $this$filePath.getAfterName();
            if (string == null) {
                string = $this$filePath.getBeforeName();
            }
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

