/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.RedshiftExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.RedshiftIntermediateFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsJdbcHelper
extends PgBaseJdbcHelper {
    private static final Pattern RS_VERSION_PATTERN = Pattern.compile("redshift\\s+" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN, 2);

    public RsJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("REDSHIFT", version, connection);
    }

    public RsJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return RsJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            RsJdbcHelper.$$$reportNull$$$0(0);
        }
        return new RedshiftIntermediateFacade(ds, 1, false, RedshiftExceptionRecognizer.INSTANCE);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.SELECTS_ONLY;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            RsJdbcHelper.$$$reportNull$$$0(1);
        }
        if ("bpchar".equals(e.typeName)) {
            e.typeName = "char";
            return;
        }
        super.adjustType(e);
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            RsJdbcHelper.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            RsJdbcHelper.$$$reportNull$$$0(3);
        }
        if (sslMode == null) {
            RsJdbcHelper.$$$reportNull$$$0(4);
        }
        RsJdbcHelper.setIfEmpty(properties, "ssl", "true");
        if (sslMode != JdbcSettings.SslMode.REQUIRE) {
            RsJdbcHelper.setIfEmpty(properties, "sslmode", RsJdbcHelper.getSslMode(sslMode));
        }
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            RsJdbcHelper.$$$reportNull$$$0(5);
        }
        return RsJdbcHelper.classNameContains(driver, "redshift");
    }

    @NotNull
    protected static RsJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = RsJdbcHelper.extractVersion(versionStr);
        return new RsJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, RS_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/RsJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

