/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveRedundantElseIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new RemoveRedundantElsePredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(0);
        }
        JSIfStatement ifStatement = (JSIfStatement)element;
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        assert (thenBranch != null);
        assert (elseBranch != null);
        String newIfText = IF_STATEMENT_PREFIX + Objects.requireNonNull(ifStatement.getCondition()).getText() + ')' + thenBranch.getText();
        JSIfStatement anchor = ifStatement;
        while (anchor.getParent() instanceof JSIfStatement) {
            anchor = anchor.getParent();
        }
        if (elseBranch instanceof JSBlockStatement) {
            int finalIndex;
            PsiElement[] children = elseBranch.getChildren();
            for (finalIndex = children.length - 2; finalIndex >= 0 && children[finalIndex] instanceof PsiWhiteSpace; --finalIndex) {
            }
            for (int i = 1; i <= finalIndex; ++i) {
                PsiElement psiElement = children[i];
                anchor = anchor.getParent().addAfter(psiElement, (PsiElement)anchor);
            }
        } else {
            anchor = anchor.getParent().addAfter((PsiElement)elseBranch, (PsiElement)anchor);
        }
        boolean isTheOnlyStatement = anchor == ifStatement;
        JSIfStatement newIfStatement = (JSIfStatement)JSPsiElementFactory.createJSStatement((String)newIfText, (PsiElement)element, JSIfStatement.class);
        SmartPsiElementPointer anchorPointer = SmartPointerManager.createPointer((PsiElement)anchor);
        Document document = PsiDocumentManager.getInstance((Project)(ifStatement = (JSIfStatement)ifStatement.replace((JSStatement)newIfStatement)).getProject()).getDocument(ifStatement.getContainingFile());
        if (document != null) {
            FormatFixer.create((PsiElement)ifStatement, (PsiElement)(isTheOnlyStatement ? ifStatement : (PsiElement)ObjectUtils.coalesce((Object)anchorPointer.getElement(), (Object)ifStatement)), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention", "processIntention"));
    }

    private static class RemoveRedundantElsePredicate
    implements JSElementPredicate {
        private RemoveRedundantElsePredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                RemoveRedundantElsePredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)element;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement elseBranch = ifStatement.getElse();
            JSStatement thenBranch = ifStatement.getThen();
            if (elseBranch == null) {
                return false;
            }
            while (thenBranch instanceof JSBlockStatement) {
                Object[] thenStatements = ((JSBlockStatement)thenBranch).getStatementListItems();
                JSSourceElement lastStatement = (JSSourceElement)ArrayUtil.getLastElement((Object[])thenStatements);
                if (lastStatement instanceof JSFunctionExitPoint || lastStatement instanceof JSBreakStatement || lastStatement instanceof JSContinueStatement) {
                    return true;
                }
                thenBranch = lastStatement;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention$RemoveRedundantElsePredicate", "satisfiedBy"));
        }
    }
}

