/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpClientDataKeys;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestFileUtils;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AddHttpRequestAction
extends AnAction {
    private static final List<String> requestsDescriptions = ContainerUtil.newArrayList((Object[])new String[]{RestClientBundle.message("http.request.add.request.action.get", new Object[0]), RestClientBundle.message("http.request.add.request.action.post.text.body", new Object[0]), RestClientBundle.message("http.request.add.request.action.post.parameters.body", new Object[0]), RestClientBundle.message("http.request.add.request.action.form.text.field", new Object[0]), RestClientBundle.message("http.request.add.request.action.form.file.field", new Object[0])});
    private static final List<String> liveTemplatesNames = ContainerUtil.newArrayList((Object[])new String[]{"gtrp", "ptr", "ptrp", "mptr", "fptr"});
    private static final Map<String, String> templateToDescriptionMap = ContainerUtil.newHashMap(requestsDescriptions, liveTemplatesNames);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddHttpRequestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            AddHttpRequestAction.showRequestsPopup(project, editor, e);
        }
    }

    private static void showRequestsPopup(final @NotNull Project project, final @NotNull Editor editor, final @NotNull AnActionEvent event2) {
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            AddHttpRequestAction.$$$reportNull$$$0(2);
        }
        if (event2 == null) {
            AddHttpRequestAction.$$$reportNull$$$0(3);
        }
        String title = RestClientBundle.message("action.HTTPClient.AddRequest.text", new Object[0]);
        ListPopup requestsCollectionPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(title, requestsDescriptions){

            public PopupStep onChosen(String requestName, boolean finalChoice) {
                return this.doFinalStep(() -> AddHttpRequestAction.performHttpLiveTemplateAction(project, editor, (String)templateToDescriptionMap.get(requestName), event2));
            }
        });
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event2.getDataContext().getData(HttpClientDataKeys.ADD_REQUEST_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            requestsCollectionPopup.showUnderneathOf((Component)hyperlinkLabel);
        } else {
            requestsCollectionPopup.showInBestPositionFor(editor);
        }
    }

    private static void performHttpLiveTemplateAction(@NotNull Project project, @NotNull Editor editor, @NotNull String liveTemplateName, @NotNull AnActionEvent event2) {
        TemplateImpl httpRequestTemplate;
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            AddHttpRequestAction.$$$reportNull$$$0(5);
        }
        if (liveTemplateName == null) {
            AddHttpRequestAction.$$$reportNull$$$0(6);
        }
        if (event2 == null) {
            AddHttpRequestAction.$$$reportNull$$$0(7);
        }
        if ((httpRequestTemplate = TemplateSettings.getInstance().getTemplate(liveTemplateName, "HTTP Request")) == null) {
            AddHttpRequestAction.showErrorBalloon(project, event2, RestClientBundle.message("http.request.add.request.action.failed.find.template", new Object[0]));
            return;
        }
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().moveToOffset(0);
        Document document = editor.getDocument();
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length == 0 || HttpRequestFileUtils.isHttpRequestSystemFile(project, selectedFiles[0].getPath()) || !FileTypeRegistry.getInstance().isFileOfType(selectedFiles[0], (FileType)HttpRequestFileType.INSTANCE)) {
            AddHttpRequestAction.createScratchFileAndStartTemplate(project, event2, (Template)httpRequestTemplate);
        } else {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"Add HTTP Request", null, () -> AddHttpRequestAction.lambda$performHttpLiveTemplateAction$0(document, project, editor, (Template)httpRequestTemplate), (PsiFile[])new PsiFile[0]);
        }
    }

    private static void createScratchFileAndStartTemplate(@NotNull Project project, @NotNull AnActionEvent event2, @NotNull Template template) {
        FileEditor[] fileEditors;
        VirtualFile file;
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(8);
        }
        if (event2 == null) {
            AddHttpRequestAction.$$$reportNull$$$0(9);
        }
        if (template == null) {
            AddHttpRequestAction.$$$reportNull$$$0(10);
        }
        String fileName = PathUtil.makeFileName((String)"rest-api", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        ScratchFileService fileService = ScratchFileService.getInstance();
        try {
            file = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_new_always);
        }
        catch (IOException e) {
            AddHttpRequestAction.showErrorBalloon(project, event2, UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}));
            return;
        }
        for (FileEditor curFileEditor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(file, true)) {
            VirtualFile curFile;
            if (!(curFileEditor instanceof TextEditor) || (curFile = curFileEditor.getFile()) == null || !curFile.getPath().equals(file.getPath())) continue;
            TemplateManager.getInstance((Project)project).startTemplate(((TextEditor)curFileEditor).getEditor(), template);
            return;
        }
        Messages.showErrorDialog((Project)project, (String)RestClientBundle.message("http.request.add.request.action.error.adding.request.message", new Object[0]), (String)RestClientBundle.message("http.request.add.request.action.error.adding.request", new Object[0]));
    }

    private static void showErrorBalloon(@NotNull Project project, @NotNull AnActionEvent event2, @NotNull String message) {
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(11);
        }
        if (event2 == null) {
            AddHttpRequestAction.$$$reportNull$$$0(12);
        }
        if (message == null) {
            AddHttpRequestAction.$$$reportNull$$$0(13);
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setFadeoutTime(2000L);
        builder.setDisposable((Disposable)project);
        Balloon errorBalloon = builder.createBalloon();
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event2.getDataContext().getData(HttpClientDataKeys.ADD_REQUEST_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            errorBalloon.showInCenterOf((JComponent)hyperlinkLabel);
        } else {
            errorBalloon.show(JBPopupFactory.getInstance().guessBestPopupLocation(event2.getDataContext()), Balloon.Position.below);
        }
    }

    private static /* synthetic */ void lambda$performHttpLiveTemplateAction$0(Document document, Project project, Editor editor, Template httpRequestTemplate) {
        document.insertString(0, (CharSequence)"\n");
        TemplateManager.getInstance((Project)project).startTemplate(editor, httpRequestTemplate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liveTemplateName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/actions/AddHttpRequestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showRequestsPopup";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "performHttpLiveTemplateAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createScratchFileAndStartTemplate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorBalloon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

