/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.BooleanFunction;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.console.HttpClientConsolePrinter;
import com.intellij.ws.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.ws.http.request.run.console.HttpRequestErrorFileFilter;
import com.intellij.ws.http.request.run.console.HttpRequestErrorFixFilter;
import com.intellij.ws.http.request.run.console.HttpResponseConsole;
import com.intellij.ws.http.request.run.console.HttpResponseFileFilter;
import com.intellij.ws.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.ws.http.request.run.console.HttpResponsePresentation;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpSingleResponseConsole
implements HttpResponseConsole {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.HttpClientResponseHandler");
    private final Project myProject;
    private final ConsoleView myConsole;
    private final HttpClientMessagePrinter myPrinter;
    private final Ref<FileType> mySelectedFileType;
    private final BooleanFunction<FileType> myIsValidFileType;
    private ConsoleView myResponseHandlerConsole;
    private HttpResponseOutputAdapter myResponseHandlerPrinter;
    private final ProcessHandler myTestsProcessHandler;
    private BaseTestsOutputConsoleView myResponseHandlerTestConsole;
    private HttpResponseOutputAdapter myResponseHandlerTestPrinter;
    private final String myTargetRequestLine;
    private HttpResponsePresentation myResponse;

    public HttpSingleResponseConsole(@NotNull Project project, @NotNull String target, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpClientRequestProcessHandler processHandler, boolean withPostProcessor) {
        if (project == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(0);
        }
        if (target == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(3);
        }
        this.mySelectedFileType = new Ref((Object)PlainTextFileType.INSTANCE);
        this.myIsValidFileType = fileType -> this.mySelectedFileType.get() == fileType;
        this.myResponseHandlerConsole = null;
        this.myResponseHandlerPrinter = null;
        this.myResponseHandlerTestConsole = null;
        this.myResponseHandlerTestPrinter = null;
        this.myResponse = null;
        this.myProject = project;
        this.myConsole = new HttpResponseConsoleView(project);
        this.myConsole.attachToProcess((ProcessHandler)processHandler);
        this.myConsole.addMessageFilter((Filter)new HttpResponseFileFilter(project));
        this.myConsole.addMessageFilter((Filter)HttpRequestErrorFileFilter.getInstance(project));
        this.myConsole.addMessageFilter((Filter)new HttpRequestErrorFixFilter());
        this.myPrinter = new HttpClientConsolePrinter(this.myConsole);
        this.myPrinter.print(target, ConsoleViewContentType.SYSTEM_OUTPUT);
        ProcessHandler processHandler2 = this.myTestsProcessHandler = withPostProcessor ? processHandler.getPostProcessorHandler() : null;
        if (this.myTestsProcessHandler != null) {
            try {
                this.myResponseHandlerConsole = new ConsoleViewImpl(project, true);
                this.myResponseHandlerConsole.print(RestClientBundle.message("rest.client.request.response.handler.console", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
                this.myResponseHandlerPrinter = HttpResponseOutputAdapter.create(this.myResponseHandlerConsole);
                Disposer.register((Disposable)this.myConsole, (Disposable)this.myResponseHandlerConsole);
                this.myResponseHandlerTestConsole = SMTestRunnerConnectionUtil.createAndAttachConsole((String)properties.getTestFrameworkName(), (ProcessHandler)this.myTestsProcessHandler, (TestConsoleProperties)properties);
                this.myResponseHandlerTestPrinter = HttpResponseOutputAdapter.createTest(this.myTestsProcessHandler);
                Disposer.register((Disposable)this.myConsole, (Disposable)this.myResponseHandlerTestConsole);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myTargetRequestLine = target;
    }

    @Override
    public void onRequestStart(@NotNull String id, int size) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void onRequestEnd(@NotNull String id) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void setResponse(@NotNull String id, @NotNull HttpResponsePresentation response, @NotNull FileType fileType) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(6);
        }
        if (response == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(8);
        }
        this.myResponse = response;
        this.mySelectedFileType.set((Object)fileType);
    }

    @Override
    public void setErrorResponse(@Nullable String id, @NotNull HttpResponsePresentation response) {
        if (response == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(9);
        }
        this.setResponse(StringUtil.notNullize((String)id), response, (FileType)PlainTextFileType.INSTANCE);
        if (this.myTestsProcessHandler != null) {
            this.myTestsProcessHandler.destroyProcess();
        }
    }

    @Override
    public void onResponseFileCreated(@NotNull String id, @Nullable String pathToFile) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(10);
        }
        if (this.myResponse != null) {
            this.myResponse.print(this.myProject, this.myPrinter, pathToFile, (FileType)this.mySelectedFileType.get(), this.myIsValidFileType);
        }
    }

    @Override
    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(11);
        }
        return consoleView;
    }

    @Override
    @Nullable
    public HttpResponseOutputAdapter getResponseHandlerPrinter() {
        return this.myResponseHandlerPrinter;
    }

    @Override
    @Nullable
    public HttpResponseOutputAdapter getResponseHandlerTestPrinter() {
        return this.myResponseHandlerTestPrinter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/console/HttpSingleResponseConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpSingleResponseConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStart";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onRequestEnd";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setResponse";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setErrorResponse";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onResponseFileCreated";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HttpResponseConsoleView
    extends ConsoleViewWrapperBase {
        private static final String RESPONSE_HANDLER_ID = "HTTP_RESPONSE_HANDLER_SCRIPT";
        private static final String RESPONSE_TESTS_ID = "HTTP_RESPONSE_HANDLER_TESTS";

        private HttpResponseConsoleView(Project project) {
            if (project == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(0);
            }
            super((ConsoleView)new ConsoleViewImpl(project, false));
        }

        public void buildUi(RunnerLayoutUi ui) {
            super.buildUi(ui);
            if (HttpSingleResponseConsole.this.myResponseHandlerConsole != null) {
                this.addTab(ui, RESPONSE_HANDLER_ID, HttpSingleResponseConsole.this.myResponseHandlerConsole.getComponent(), RestClientBundle.message("rest.client.request.response.handler.tab.name", new Object[0]));
            }
            if (HttpSingleResponseConsole.this.myResponseHandlerTestConsole != null) {
                this.addTab(ui, RESPONSE_TESTS_ID, HttpSingleResponseConsole.this.myResponseHandlerTestConsole.getComponent(), RestClientBundle.message("rest.client.request.test.tab.name", new Object[0]));
            }
        }

        private void addTab(@NotNull RunnerLayoutUi ui, @NotNull String contentId, @NotNull JComponent component, @NotNull String name) {
            if (ui == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(1);
            }
            if (contentId == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(2);
            }
            if (component == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(3);
            }
            if (name == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(4);
            }
            Content content = ui.createContent(contentId, component, name, null, null);
            content.setCloseable(false);
            ui.addContent(content, 0, PlaceInGrid.bottom, false);
        }

        public AnAction @NotNull [] createConsoleActions() {
            AnAction[] oldActions = super.createConsoleActions();
            ArrayList<Object> newActions = new ArrayList<Object>(oldActions.length);
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, RestClientBundle.message("http.request.reformat.response.action.view.as.raw.text", new Object[0]), RestClientBundle.message("http.request.reformat.response.action.view.as.raw.description", new Object[0]), (FileType)PlainTextFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, (FileType)JsonFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, (FileType)XmlFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, (FileType)HtmlFileType.INSTANCE));
            group.addSeparator();
            newActions.add(group);
            for (AnAction action : oldActions) {
                if (action instanceof PreviousOccurenceToolbarAction || action instanceof NextOccurenceToolbarAction) continue;
                newActions.add(action);
            }
            AnAction[] anActionArray = newActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(5);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/console/HttpSingleResponseConsole$HttpResponseConsoleView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpSingleResponseConsole$HttpResponseConsoleView";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConsoleActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addTab";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class HttpResponseReformatBaseAction
    extends ToggleAction {
        private HttpResponseReformatBaseAction(@Nullable String text, @Nullable String description, Icon icon) {
            super(text, description, icon);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HttpResponseReformatBaseAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(HttpSingleResponseConsole.this.myResponse != null && HttpSingleResponseConsole.this.myResponse.canBeReformatted());
        }

        @Nullable
        public abstract FileType getFileType();

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HttpResponseReformatBaseAction.$$$reportNull$$$0(1);
            }
            return HttpSingleResponseConsole.this.mySelectedFileType.get() == this.getFileType();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            FileType type;
            if (e == null) {
                HttpResponseReformatBaseAction.$$$reportNull$$$0(2);
            }
            if (state && HttpSingleResponseConsole.this.myResponse != null && (type = this.getFileType()) != null && HttpSingleResponseConsole.this.mySelectedFileType.get() != type) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reformat response body as " + type.getName());
                }
                HttpSingleResponseConsole.this.mySelectedFileType.set((Object)type);
                HttpSingleResponseConsole.this.myConsole.clear();
                HttpSingleResponseConsole.this.myConsole.print(HttpSingleResponseConsole.this.myTargetRequestLine, ConsoleViewContentType.SYSTEM_OUTPUT);
                HttpSingleResponseConsole.this.myResponse.print(HttpSingleResponseConsole.this.myProject, HttpSingleResponseConsole.this.myPrinter, null, type, (BooleanFunction<? super FileType>)HttpSingleResponseConsole.this.myIsValidFileType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpSingleResponseConsole$HttpResponseReformatBaseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HttpResponseReformatAction
    extends HttpResponseReformatBaseAction {
        private final FileType myFileType;
        final /* synthetic */ HttpSingleResponseConsole this$0;

        private HttpResponseReformatAction(@NotNull HttpSingleResponseConsole httpSingleResponseConsole, FileType fileType) {
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(0);
            }
            this(httpSingleResponseConsole, RestClientBundle.message("http.request.reformat.response.action.view.as.text", fileType.getName()), RestClientBundle.message("http.request.reformat.response.action.view.as.description", fileType.getName()), fileType);
        }

        private HttpResponseReformatAction(@NotNull HttpSingleResponseConsole httpSingleResponseConsole, @NotNull String text, @NotNull String description, FileType fileType) {
            if (text == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(1);
            }
            if (description == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(3);
            }
            this.this$0 = httpSingleResponseConsole;
            super(text, description, fileType.getIcon());
            this.myFileType = fileType;
        }

        @Override
        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ws/http/request/run/console/HttpSingleResponseConsole$HttpResponseReformatAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

