/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView;

import com.intellij.analysis.problemsView.AnalysisProblem;
import com.intellij.analysis.problemsView.AnalysisProblemBundle;
import com.intellij.analysis.problemsView.AnalysisProblemsPresentationHelper;
import com.intellij.analysis.problemsView.AnalysisProblemsTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnalysisProblemsViewPanel
extends SimpleToolWindowPanel
implements DataProvider,
CopyProvider {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final TableView<AnalysisProblem> myTable;
    @NotNull
    protected final AnalysisProblemsPresentationHelper myPresentationHelper;

    public AnalysisProblemsViewPanel(@NotNull Project project, @NotNull AnalysisProblemsPresentationHelper presentationHelper) {
        if (project == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(0);
        }
        if (presentationHelper == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(1);
        }
        super(false, true);
        this.myProject = project;
        this.myPresentationHelper = presentationHelper;
        this.myTable = this.createTable();
        this.setToolbar(this.createToolbar());
        this.setContent(this.createCenterPanel());
    }

    private void popupInvoked(Component component2, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.getData(CommonDataKeys.NAVIGATABLE.getName()) != null) {
            group.add(ActionManager.getInstance().getAction("EditSource"));
        }
        group.add(ActionManager.getInstance().getAction("$Copy"));
        List selectedProblems = this.myTable.getSelectedObjects();
        AnalysisProblem selectedProblem = selectedProblems.size() == 1 ? (AnalysisProblem)selectedProblems.get(0) : null;
        this.addQuickFixActions(group, selectedProblem);
        this.addDiagnosticMessageActions(group, selectedProblem);
        AnalysisProblemsViewPanel.addDocumentationAction(group, selectedProblem);
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("toolbar", (ActionGroup)group);
        menu.getComponent().show(component2, x, y);
    }

    @NotNull
    protected TableView<AnalysisProblem> createTable() {
        TableView table = new TableView((ListTableModel)this.createTableModel());
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AnalysisProblemsViewPanel.this.navigate(false);
                }
            }
        });
        EditSourceOnDoubleClickHandler.install((JTable)table);
        table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                AnalysisProblemsViewPanel.this.popupInvoked(comp, x, y);
            }
        });
        ((DefaultRowSorter)table.getRowSorter()).setRowFilter(this.myPresentationHelper.getRowFilter());
        table.getRowSorter().addRowSorterListener(e -> {
            List<RowSorter.SortKey> sortKeys = this.myTable.getRowSorter().getSortKeys();
            assert (sortKeys.size() == 1) : sortKeys;
            ((AnalysisProblemsTableModel)((Object)((Object)this.myTable.getModel()))).setSortKey(sortKeys.get(0));
        });
        new TableSpeedSearch((JTable)table, (Convertor<Object, String>)((Convertor)object -> object instanceof AnalysisProblem ? ((AnalysisProblem)object).getErrorMessage() + " " + ((AnalysisProblem)object).getPresentableLocation() : ""));
        table.setShowVerticalLines(false);
        table.setShowHorizontalLines(false);
        table.setStriped(true);
        table.setRowHeight(table.getRowHeight() + JBUIScale.scale((int)4));
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setPreferredSize(new Dimension(0, table.getRowHeight()));
        TableView tableView = table;
        if (tableView == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(2);
        }
        return tableView;
    }

    @NotNull
    protected AnalysisProblemsTableModel createTableModel() {
        return new AnalysisProblemsTableModel(this.myPresentationHelper);
    }

    protected abstract void addQuickFixActions(@NotNull DefaultActionGroup var1, @Nullable AnalysisProblem var2);

    void addDiagnosticMessageActions(@NotNull DefaultActionGroup group, @Nullable AnalysisProblem problem) {
        List<AnalysisProblem> diagnosticMessages;
        if (group == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(3);
        }
        List<AnalysisProblem> list2 = diagnosticMessages = problem != null ? problem.getSecondaryMessages() : null;
        if (diagnosticMessages == null || diagnosticMessages.isEmpty()) {
            return;
        }
        group.addSeparator();
        Icon jumpToSourceIcon = ActionManager.getInstance().getAction("EditSource").getTemplatePresentation().getIcon();
        for (final AnalysisProblem diagnosticMessage : diagnosticMessages) {
            String message = StringUtil.notNullize((String)diagnosticMessage.getErrorMessage());
            message = StringUtil.trimEnd((String)StringUtil.trim((String)message), (String)".");
            final VirtualFile vFile = diagnosticMessage.getFile();
            if (!StringUtil.isNotEmpty((String)message) || vFile == null) continue;
            group.add((AnAction)new DumbAwareAction(message, null, jumpToSourceIcon){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    int offset = AnalysisProblemsViewPanel.this.getConvertedOffset(vFile, diagnosticMessage);
                    OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{PsiNavigationSupport.getInstance().createNavigatable(AnalysisProblemsViewPanel.this.myProject, vFile, offset)});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/analysis/problemsView/AnalysisProblemsViewPanel$3", "actionPerformed"));
                }
            });
        }
    }

    protected int getConvertedOffset(@NotNull VirtualFile vFile, @NotNull AnalysisProblem diagnosticMessage) {
        if (vFile == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(4);
        }
        if (diagnosticMessage == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(5);
        }
        return diagnosticMessage.getOffset();
    }

    @NotNull
    protected JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        this.addActionsTo(group);
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("InspectionProblemsView", (ActionGroup)group, false).getComponent();
        if (jComponent == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @NotNull
    public AnalysisProblemsTableModel getModel() {
        AnalysisProblemsTableModel analysisProblemsTableModel = (AnalysisProblemsTableModel)((Object)this.myTable.getModel());
        if (analysisProblemsTableModel == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(7);
        }
        return analysisProblemsTableModel;
    }

    protected abstract void addActionsTo(@NotNull DefaultActionGroup var1);

    @NotNull
    protected JPanel createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void fireGroupingOrFilterChanged() {
        this.myTable.getRowSorter().allRowsChanged();
        ((AnalysisProblemsTableModel)((Object)this.myTable.getModel())).onFilterChanged();
        this.updateStatusDescription();
    }

    protected abstract void updateStatusDescription();

    @NotNull
    protected Icon getStatusIcon() {
        Icon icon2 = AllIcons.Toolwindows.Problems;
        if (icon2 == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(9);
        }
        return icon2;
    }

    protected void addAutoScrollToSourceAction(@NotNull DefaultActionGroup group) {
        if (group == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(10);
        }
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return AnalysisProblemsViewPanel.this.myPresentationHelper.isAutoScrollToSource();
            }

            protected void setAutoScrollMode(boolean autoScrollToSource) {
                AnalysisProblemsViewPanel.this.myPresentationHelper.setAutoScrollToSource(autoScrollToSource);
            }
        };
        autoScrollToSourceHandler.install(this.myTable);
        group.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    protected void addGroupBySeverityAction(@NotNull DefaultActionGroup group) {
        if (group == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(11);
        }
        DumbAwareToggleAction action2 = new DumbAwareToggleAction(AnalysisProblemBundle.message("group.by.severity", new Object[0]), AnalysisProblemBundle.message("group.by.severity.description", new Object[0]), AllIcons.Nodes.SortBySeverity){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                return AnalysisProblemsViewPanel.this.myPresentationHelper.isGroupBySeverity();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean groupBySeverity) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                AnalysisProblemsViewPanel.this.myPresentationHelper.setGroupBySeverity(groupBySeverity);
                AnalysisProblemsViewPanel.this.fireGroupingOrFilterChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/analysis/problemsView/AnalysisProblemsViewPanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        group.addAction((AnAction)action2);
    }

    protected void createAndShowPopup(@NotNull String title, @NotNull JPanel jPanel) {
        if (title == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(12);
        }
        if (jPanel == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(13);
        }
        Rectangle visibleRect = this.myTable.getVisibleRect();
        Point tableTopLeft = new Point(this.myTable.getLocationOnScreen().x + visibleRect.x, this.myTable.getLocationOnScreen().y + visibleRect.y);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jPanel, null).setProject(this.myProject).setTitle(title).setMovable(true).setRequestFocus(true).createPopup().show(RelativePoint.fromScreen((Point)tableTopLeft));
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(14);
        }
        return true;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(15);
        }
        return this.myTable.getSelectedObject() != null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        List selectedObjects;
        String s;
        if (dataContext == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(16);
        }
        if (!(s = StringUtil.join((Collection)(selectedObjects = this.myTable.getSelectedObjects()), problem -> StringUtil.toLowerCase((String)problem.getSeverity()) + ": " + problem.getErrorMessage() + " (" + problem.getCode() + " at " + problem.getPresentableLocation() + ")", (String)"\n")).isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(s));
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(17);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.createNavigatable();
        }
        return null;
    }

    @Nullable
    private Navigatable createNavigatable() {
        VirtualFile file2;
        AnalysisProblem problem = (AnalysisProblem)this.myTable.getSelectedObject();
        if (problem != null && (file2 = LocalFileSystem.getInstance().findFileByPath(problem.getSystemIndependentPath())) != null) {
            OpenFileDescriptor navigatable = new OpenFileDescriptor(this.myProject, file2, problem.getOffset());
            navigatable.setScrollType(ScrollType.MAKE_VISIBLE);
            return navigatable;
        }
        return null;
    }

    private void navigate(boolean requestFocus) {
        Navigatable navigatable = this.createNavigatable();
        if (navigatable != null && navigatable.canNavigateToSource()) {
            navigatable.navigate(requestFocus);
        }
    }

    public void clearAll() {
        ((AnalysisProblemsTableModel)((Object)this.myTable.getModel())).removeAll();
        this.updateStatusDescription();
    }

    private static void addDocumentationAction(@NotNull DefaultActionGroup group, @Nullable AnalysisProblem problem) {
        String url;
        if (group == null) {
            AnalysisProblemsViewPanel.$$$reportNull$$$0(18);
        }
        String string = url = problem != null ? problem.getUrl() : null;
        if (url == null) {
            return;
        }
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.DumbAware.DartProblemsViewPanel.text.open.documentation", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.DumbAware.DartProblemsViewPanel.description.open.detailed.problem.description.in.browser", (Object[])new Object[0]), AllIcons.Ide.External_link_arrow){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                BrowserUtil.browse((String)url);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/analysis/problemsView/AnalysisProblemsViewPanel$6", "actionPerformed"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationHelper";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/AnalysisProblemsViewPanel";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticMessage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jPanel";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/AnalysisProblemsViewPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDiagnosticMessageActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedOffset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addAutoScrollToSourceAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addGroupBySeverityAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAndShowPopup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentationAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

