/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoverWrapper {
    private static final Logger LOGGER = Logger.getInstance(MoverWrapper.class);
    protected final boolean myIsDown;
    private final StatementUpDownMover myMover;
    private final StatementUpDownMover.MoveInfo myInfo;

    protected MoverWrapper(@NotNull StatementUpDownMover mover, @NotNull StatementUpDownMover.MoveInfo info, boolean isDown) {
        if (mover == null) {
            MoverWrapper.$$$reportNull$$$0(0);
        }
        if (info == null) {
            MoverWrapper.$$$reportNull$$$0(1);
        }
        this.myMover = mover;
        this.myIsDown = isDown;
        this.myInfo = info;
    }

    public StatementUpDownMover.MoveInfo getInfo() {
        return this.myInfo;
    }

    public final void move(@NotNull Editor editor, @Nullable PsiFile file2) {
        if (editor == null) {
            MoverWrapper.$$$reportNull$$$0(2);
        }
        assert (this.myInfo.toMove2 != null);
        this.myMover.beforeMove(editor, this.myInfo, this.myIsDown);
        Document document = editor.getDocument();
        Project project = editor.getProject();
        assert (project != null);
        if (!this.myInfo.toMove.equals(this.myInfo.toMove2)) {
            int start2 = StatementUpDownMover.getLineStartSafeOffset((Document)document, (int)this.myInfo.toMove.startLine);
            int end = StatementUpDownMover.getLineStartSafeOffset((Document)document, (int)this.myInfo.toMove.endLine);
            String textToInsert = document.getCharsSequence().subSequence(start2, end).toString();
            if (!StringUtil.endsWithChar((CharSequence)textToInsert, (char)'\n')) {
                textToInsert = textToInsert + '\n';
            }
            int start22 = document.getLineStartOffset(this.myInfo.toMove2.startLine);
            int end2 = StatementUpDownMover.getLineStartSafeOffset((Document)document, (int)this.myInfo.toMove2.endLine);
            String textToInsert2 = document.getCharsSequence().subSequence(start22, end2).toString();
            if (!StringUtil.endsWithChar((CharSequence)textToInsert2, (char)'\n')) {
                textToInsert2 = textToInsert2 + '\n';
            }
            this.myInfo.range1 = document.createRangeMarker(start2, end);
            this.myInfo.range2 = document.createRangeMarker(start22, end2);
            if (this.myInfo.range1.getStartOffset() < this.myInfo.range2.getStartOffset()) {
                this.myInfo.range1.setGreedyToLeft(true);
                this.myInfo.range1.setGreedyToRight(false);
                this.myInfo.range2.setGreedyToLeft(true);
                this.myInfo.range2.setGreedyToRight(true);
            } else {
                this.myInfo.range1.setGreedyToLeft(true);
                this.myInfo.range1.setGreedyToRight(true);
                this.myInfo.range2.setGreedyToLeft(true);
                this.myInfo.range2.setGreedyToRight(false);
            }
            TextRange range2 = new TextRange(start2, end);
            TextRange range22 = new TextRange(start22, end2);
            if (!range2.equals((Object)range22)) {
                if (range2.intersectsStrict(range22)) {
                    LOGGER.error("Cannot perform move", (Throwable)PluginException.createByClass((String)("Wrong move ranges requested by " + this.myMover + " " + start2 + ":" + end + " vs " + start22 + ":" + end2), null, this.myMover.getClass()), new Attachment[]{new Attachment("ranges.txt", start2 + ":" + end + "(" + textToInsert + ")\n" + start22 + ":" + end2 + "(" + textToInsert2 + ")")});
                    return;
                }
                CaretModel caretModel = editor.getCaretModel();
                int caretRelativePos = caretModel.getOffset() - start2;
                SelectionModel selectionModel = editor.getSelectionModel();
                int selectionStart = selectionModel.getSelectionStart();
                int selectionEnd = selectionModel.getSelectionEnd();
                boolean hasSelection = selectionModel.hasSelection();
                caretModel.moveToOffset(0);
                FoldRegion topRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range1);
                FoldRegion bottomRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range2);
                if (document instanceof DocumentEx) {
                    int startFirst = Math.min(start2, start22);
                    int endFirst = Math.min(end, end2);
                    int startSecond = Math.max(start2, start22);
                    int endSecond = Math.max(end, end2);
                    ((DocumentEx)document).moveText(startFirst, endFirst, startSecond);
                    ((DocumentEx)document).moveText(startSecond, endSecond, startFirst);
                    this.myInfo.range1.dispose();
                    this.myInfo.range2.dispose();
                    this.myInfo.range1 = document.createRangeMarker(start2 < start22 ? start2 : start22 + end - end2, start2 < start22 ? start2 + end2 - start22 : end);
                    this.myInfo.range2 = document.createRangeMarker(start2 < start22 ? start2 + end2 - end : start22, start2 < start22 ? end2 : start22 + end - start2);
                    MoverWrapper.insertLineBreakInTheEndIfMissing(this.myInfo.range1);
                    MoverWrapper.insertLineBreakInTheEndIfMissing(this.myInfo.range2);
                } else {
                    document.insertString(this.myInfo.range1.getStartOffset(), (CharSequence)textToInsert2);
                    document.deleteString(this.myInfo.range1.getStartOffset() + textToInsert2.length(), this.myInfo.range1.getEndOffset());
                    document.insertString(this.myInfo.range2.getStartOffset(), (CharSequence)textToInsert);
                    int s = this.myInfo.range2.getStartOffset() + textToInsert.length();
                    int e = this.myInfo.range2.getEndOffset();
                    if (e > s) {
                        document.deleteString(s, e);
                    }
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                if (topRegion != null && bottomRegion != null) {
                    CodeFoldingManager.getInstance(project).updateFoldRegions(editor);
                    editor.getFoldingModel().runBatchFoldingOperation(() -> {
                        FoldRegion newBottomRegion;
                        FoldRegion newTopRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range1);
                        if (newTopRegion != null) {
                            newTopRegion.setExpanded(bottomRegion.isExpanded());
                        }
                        if ((newBottomRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range2)) != null) {
                            newBottomRegion.setExpanded(topRegion.isExpanded());
                        }
                    });
                }
                if (hasSelection) {
                    MoverWrapper.restoreSelection(editor, selectionStart, selectionEnd, start2, end, this.myInfo.range2.getStartOffset());
                }
                caretModel.moveToOffset(this.myInfo.range2.getStartOffset() + caretRelativePos);
            }
        }
        if (file2 != null) {
            this.myMover.afterMove(editor, file2, this.myInfo, this.myIsDown);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            if (this.myInfo.indentTarget) {
                MoverWrapper.indentLinesIn(editor, file2, document, project, this.myInfo.range2);
            }
            if (this.myInfo.indentSource) {
                MoverWrapper.indentLinesIn(editor, file2, document, project, this.myInfo.range1);
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private static void insertLineBreakInTheEndIfMissing(@NotNull RangeMarker marker) {
        int endOffset;
        if (marker == null) {
            MoverWrapper.$$$reportNull$$$0(3);
        }
        Document document = marker.getDocument();
        int startOffset = marker.getStartOffset();
        if (startOffset == (endOffset = marker.getEndOffset()) || document.getImmutableCharSequence().charAt(endOffset - 1) != '\n') {
            marker.setGreedyToRight(true);
            document.insertString(endOffset, (CharSequence)"\n");
        }
    }

    private static FoldRegion findTopLevelRegionInRange(Editor editor, RangeMarker range2) {
        FoldRegion result2 = null;
        for (FoldRegion foldRegion : editor.getFoldingModel().getAllFoldRegions()) {
            if (!foldRegion.isValid() || !MoverWrapper.contains(range2, foldRegion) || MoverWrapper.contains(result2, foldRegion)) continue;
            result2 = foldRegion;
        }
        return result2;
    }

    private static boolean contains(@NotNull RangeMarker rangeMarker, @NotNull FoldRegion foldRegion) {
        if (rangeMarker == null) {
            MoverWrapper.$$$reportNull$$$0(4);
        }
        if (foldRegion == null) {
            MoverWrapper.$$$reportNull$$$0(5);
        }
        return rangeMarker.getStartOffset() <= foldRegion.getStartOffset() && rangeMarker.getEndOffset() >= foldRegion.getEndOffset();
    }

    private static boolean contains(@Nullable FoldRegion region1, @NotNull FoldRegion region2) {
        if (region2 == null) {
            MoverWrapper.$$$reportNull$$$0(6);
        }
        if (region1 == null) {
            return false;
        }
        return region1.getStartOffset() <= region2.getStartOffset() && region1.getEndOffset() >= region2.getEndOffset();
    }

    private static void indentLinesIn(Editor editor, PsiFile file2, Document document, Project project, RangeMarker range2) {
        int line1;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        int line2 = editor.offsetToLogicalPosition((int)range2.getEndOffset()).line;
        for (line1 = editor.offsetToLogicalPosition((int)range2.getStartOffset()).line; !MoverWrapper.lineContainsNonSpaces(document, line1) && line1 < line2; ++line1) {
        }
        while (!MoverWrapper.lineContainsNonSpaces(document, line2) && line1 < line2) {
            --line2;
        }
        FileViewProvider provider = file2.getViewProvider();
        PsiFile rootToAdjustIndentIn = provider.getPsi(provider.getBaseLanguage());
        codeStyleManager.adjustLineIndent(rootToAdjustIndentIn, new TextRange(document.getLineStartOffset(line1), document.getLineStartOffset(line2)));
    }

    private static boolean lineContainsNonSpaces(Document document, int line) {
        if (line >= document.getLineCount()) {
            return false;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        String text2 = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset).toString();
        return text2.trim().length() != 0;
    }

    private static void restoreSelection(Editor editor, int selectionStart, int selectionEnd, int moveStartOffset, int moveEndOffset, int insOffset) {
        int selectionRelativeStartOffset = Math.max(0, selectionStart - moveStartOffset);
        int selectionRelativeEndOffset = Math.min(moveEndOffset - moveStartOffset, selectionEnd - moveStartOffset);
        int newSelectionStart = insOffset + selectionRelativeStartOffset;
        int newSelectionEnd = insOffset + selectionRelativeEndOffset;
        EditorUtil.setSelectionExpandingFoldedRegionsIfNeeded(editor, newSelectionStart, newSelectionEnd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mover";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "move";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insertLineBreakInTheEndIfMissing";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

