/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.chains;

import com.intellij.diff.chains.DiffRequestChainBase;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncDiffRequestChain
extends DiffRequestChainBase {
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private volatile List<? extends DiffRequestProducer> myRequests = null;
    @Nullable
    private ProgressIndicator myIndicator;
    private int myAssignments = 0;

    public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(0);
        }
        if (disposable2 == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener2, disposable2);
    }

    @NotNull
    public List<? extends DiffRequestProducer> getRequests() {
        List<? extends DiffRequestProducer> requests = this.myRequests;
        if (requests == null) {
            List<SimpleDiffRequestChain.DiffRequestProducerWrapper> list2 = Collections.singletonList(new SimpleDiffRequestChain.DiffRequestProducerWrapper((DiffRequest)new LoadingDiffRequest()));
            if (list2 == null) {
                AsyncDiffRequestChain.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List<? extends DiffRequestProducer> list3 = requests;
        if (list3 == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    public ListSelection<? extends DiffRequestProducer> loadRequestsInBackground() {
        ListSelection<? extends DiffRequestProducer> listSelection;
        try {
            listSelection = this.loadRequestProducers();
        }
        catch (DiffRequestProducerException e) {
            ListSelection listSelection2 = ListSelection.createSingleton((Object)new SimpleDiffRequestChain.DiffRequestProducerWrapper((DiffRequest)new ErrorDiffRequest((Throwable)e)));
            if (listSelection2 == null) {
                AsyncDiffRequestChain.$$$reportNull$$$0(5);
            }
            return listSelection2;
        }
        if (listSelection == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(4);
        }
        return listSelection;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            if (this.myAssignments == 0 && this.myIndicator == null) {
                this.myIndicator = this.startLoading();
            }
            ++this.myAssignments;
        } else {
            --this.myAssignments;
            if (this.myAssignments == 0 && this.myIndicator != null) {
                this.myIndicator.cancel();
                this.myIndicator = null;
            }
        }
        assert (this.myAssignments >= 0);
    }

    @Nullable
    private ProgressIndicator startLoading() {
        if (this.myRequests != null) {
            return null;
        }
        return BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> {
            ListSelection<? extends DiffRequestProducer> producers = this.loadRequestsInBackground();
            return () -> {
                indicator.checkCanceled();
                this.applyLoadedChanges(producers);
            };
        }), null);
    }

    private void applyLoadedChanges(@NotNull ListSelection<? extends DiffRequestProducer> producers) {
        if (producers == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(6);
        }
        if (this.myRequests != null) {
            return;
        }
        this.myRequests = producers.getList();
        this.setIndex(producers.getSelectedIndex());
        this.myIndicator = null;
        ((Listener)this.myDispatcher.getMulticaster()).onRequestsLoaded();
    }

    @NotNull
    protected abstract ListSelection<? extends DiffRequestProducer> loadRequestProducers() throws DiffRequestProducerException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/chains/AsyncDiffRequestChain";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/chains/AsyncDiffRequestChain";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequests";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRequestsInBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyLoadedChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener
    extends EventListener {
        public void onRequestsLoaded();
    }
}

