/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.ui.ConfigureTemplatesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class SelectTemplateDialog
extends DialogWrapper {
    private ComboBox<FileTemplate> myCbxTemplates;
    private FileTemplate mySelectedTemplate;
    private final Project myProject;
    private final PsiDirectory myDirectory;

    public SelectTemplateDialog(Project project, PsiDirectory directory) {
        super(project, true);
        this.myDirectory = directory;
        this.myProject = project;
        this.setTitle(IdeBundle.message((String)"title.select.template", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.loadCombo();
        FixedSizeButton editTemplatesButton = new FixedSizeButton(this.myCbxTemplates);
        JPanel centerPanel2 = new JPanel(new GridBagLayout());
        JLabel selectTemplateLabel = new JLabel(IdeBundle.message((String)"label.name", (Object[])new Object[0]));
        centerPanel2.add((Component)selectTemplateLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)2), 0, 0));
        centerPanel2.add((Component)this.myCbxTemplates, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, (Insets)JBUI.insets((int)2), 50, 0));
        centerPanel2.add((Component)editTemplatesButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)2), 0, 0));
        editTemplatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTemplateDialog.this.onEditTemplates();
            }
        });
        return centerPanel2;
    }

    private void loadCombo() {
        DefaultComboBoxModel<FileTemplate> model = new DefaultComboBoxModel<FileTemplate>();
        FileTemplate[] allTemplates = FileTemplateManager.getInstance(this.myProject).getAllTemplates();
        PsiDirectory[] dirs = new PsiDirectory[]{this.myDirectory};
        for (FileTemplate template : allTemplates) {
            if (!FileTemplateUtil.canCreateFromTemplate(dirs, template)) continue;
            model.addElement(template);
        }
        if (this.myCbxTemplates == null) {
            this.myCbxTemplates = new ComboBox(model);
            new ComboboxSpeedSearch((JComboBox)this.myCbxTemplates){

                @Override
                protected String getElementText(Object element2) {
                    return element2 instanceof FileTemplate ? ((FileTemplate)element2).getName() : null;
                }
            };
            this.myCbxTemplates.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, fileTemplate, index) -> {
                if (fileTemplate != null) {
                    label2.setIcon(FileTemplateUtil.getIcon(fileTemplate));
                    label2.setText(fileTemplate.getName());
                }
            }));
        } else {
            Object selected2 = this.myCbxTemplates.getSelectedItem();
            this.myCbxTemplates.setModel(model);
            if (selected2 != null) {
                this.myCbxTemplates.setSelectedItem(selected2);
            }
        }
    }

    public FileTemplate getSelectedTemplate() {
        return this.mySelectedTemplate;
    }

    protected void doOKAction() {
        this.mySelectedTemplate = (FileTemplate)this.myCbxTemplates.getSelectedItem();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.mySelectedTemplate = null;
        super.doCancelAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCbxTemplates;
    }

    private void onEditTemplates() {
        new ConfigureTemplatesDialog(this.myProject).show();
        this.loadCombo();
    }
}

