/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashSet;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final IdeaPluginDescriptor myPluginDescriptor;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;
    private final AtomicLong edtTime;
    private final AtomicLong backgroundTime;
    private final AtomicInteger loadedClassCounter;
    private static final ActionWithPluginClassLoader<Class<?>, Void> loadClassInPluginCL;
    private static final ActionWithClassloader<Class<?>, Void> loadClassInCl;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES;
    private static final ActionWithPluginClassLoader<URL, Void> findResourceInPluginCL;
    private static final ActionWithClassloader<URL, Void> findResourceInCl;
    private static final ActionWithPluginClassLoader<InputStream, Void> getResourceAsStreamInPluginCL;
    private static final ActionWithClassloader<InputStream, Void> getResourceAsStreamInCl;
    private static final ActionWithPluginClassLoader<Void, List<Enumeration<URL>>> findResourcesInPluginCL;
    private static final ActionWithClassloader<Void, List<Enumeration<URL>>> findResourcesInCl;

    public PluginClassLoader(@NotNull List<URL> urls, ClassLoader @NotNull [] parents2, PluginId pluginId, @Nullable IdeaPluginDescriptor pluginDescriptor, String version2, @Nullable Path pluginRoot) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        this(PluginClassLoader.build().urls(urls).allowLock().useCache(), parents2, pluginId, pluginDescriptor, version2, pluginRoot);
    }

    public PluginClassLoader(@NotNull UrlClassLoader.Builder builder2, ClassLoader @NotNull [] parents2, PluginId pluginId, @Nullable IdeaPluginDescriptor pluginDescriptor, String version2, @Nullable Path pluginRoot) {
        Path libDir;
        if (builder2 == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        super(builder2);
        this.edtTime = new AtomicLong();
        this.backgroundTime = new AtomicLong();
        this.loadedClassCounter = new AtomicInteger();
        this.myParents = parents2;
        this.myPluginId = pluginId;
        this.myPluginDescriptor = pluginDescriptor;
        this.myPluginVersion = version2;
        this.myLibDirectories = new SmartList();
        if (pluginRoot != null && Files.exists(libDir = pluginRoot.resolve("lib"), new LinkOption[0])) {
            this.myLibDirectories.add(libDir.toAbsolutePath().toString());
        }
    }

    public PluginClassLoader(@NotNull List<URL> urls, ClassLoader @NotNull [] parents2, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            PluginClassLoader.$$$reportNull$$$0(5);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(6);
        }
        this(PluginClassLoader.build().urls(urls).allowLock().useCache(), parents2, descriptor2.getPluginId(), (IdeaPluginDescriptor)descriptor2, descriptor2.getVersion(), descriptor2.getPluginPath());
    }

    @Deprecated
    public PluginClassLoader(@NotNull List<URL> urls, ClassLoader @NotNull [] parents2, PluginId pluginId, String version2, File pluginRoot) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(7);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(8);
        }
        this(urls, parents2, pluginId, null, version2, pluginRoot == null ? null : pluginRoot.toPath());
    }

    public long getEdtTime() {
        return this.edtTime.get();
    }

    public long getBackgroundTime() {
        return this.backgroundTime.get();
    }

    public long getLoadedClassCount() {
        return this.loadedClassCounter.get();
    }

    public Class<?> loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        Class<?> c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(9);
        }
        if ((c = this.tryLoadingClass(name, resolve2, null)) == null) {
            throw new ClassNotFoundException(name + " " + (Object)((Object)this));
        }
        return c;
    }

    @Nullable
    private <Result, ParameterType> Result processResourcesInParents(String name, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, Set<ClassLoader> visited, ParameterType parameter) {
        for (ClassLoader parent : this.myParents) {
            Result resource;
            if (visited == null) {
                visited = new THashSet();
                visited.add(this);
            }
            if (!visited.add((ClassLoader)parent) || !(parent instanceof PluginClassLoader ? (resource = actionWithPluginClassLoader.execute(name, (PluginClassLoader)((Object)parent), (Set<ClassLoader>)visited, actionWithPluginClassLoader, actionWithClassloader, parameter)) != null : (resource = actionWithClassloader.execute(name, parent, parameter)) != null)) continue;
            return resource;
        }
        return null;
    }

    @Nullable
    private Class<?> tryLoadingClass(@NotNull String name, boolean resolve2, @Nullable Set<ClassLoader> visited) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(10);
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        Class<?> c = null;
        if (!PluginClassLoader.mustBeLoadedByPlatform(name)) {
            c = this.loadClassInsideSelf(name);
        }
        if (c == null) {
            c = this.processResourcesInParents(name, loadClassInPluginCL, loadClassInCl, visited, null);
        }
        if (c != null && resolve2) {
            this.resolveClass(c);
        }
        if (this.myPluginId != null && StartUpMeasurer.measuringPluginStartupCosts) {
            Application app = ApplicationManager.getApplication();
            boolean isEdt = app == null ? EventQueue.isDispatchThread() : app.isDispatchThread();
            (isEdt ? this.edtTime : this.backgroundTime).addAndGet(StartUpMeasurer.getCurrentTime() - startTime);
        }
        return c;
    }

    private static boolean mustBeLoadedByPlatform(String className) {
        if (className.startsWith("java.")) {
            return true;
        }
        return className.startsWith("kotlin.") && (className.startsWith("kotlin.jvm.functions.") || className.startsWith("kotlin.reflect.") && className.indexOf(46, 15) < 0 || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Class<?> loadClassInsideSelf(@NotNull String name) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(11);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            try {
                c = this._findClass(name);
            }
            catch (LinkageError e) {
                throw new PluginException("While loading class " + name + ": " + e.getMessage(), (Throwable)e, this.myPluginId);
            }
            if (c != null) {
                this.loadedClassCounter.incrementAndGet();
            }
            return c;
        }
    }

    public URL findResource(String name) {
        URL resource = this.findOwnResource(name);
        if (resource != null) {
            return resource;
        }
        return this.processResourcesInParents(name, findResourceInPluginCL, findResourceInCl, null, null);
    }

    @Nullable
    private URL findOwnResource(String name) {
        URL resource = super.findResource(name);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream = this.getOwnResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        return this.processResourcesInParents(name, getResourceAsStreamInPluginCL, getResourceAsStreamInCl, null, null);
    }

    @Nullable
    private InputStream getOwnResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(this.findOwnResources(name));
        this.processResourcesInParents(name, findResourcesInPluginCL, findResourcesInCl, null, resources);
        return new DeepEnumeration(resources.toArray(new Enumeration[resources.size()]));
    }

    private Enumeration<URL> findOwnResources(String name) throws IOException {
        return super.findResources(name);
    }

    public void addLibDirectories(@NotNull Collection<String> libDirectories) {
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(12);
        }
        this.myLibDirectories.addAll(libDirectories);
    }

    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    @Nullable
    public IdeaPluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    public String getPluginIdString() {
        String string = this.myPluginId != null ? this.myPluginId.getIdString() : PluginManagerCore.CORE_ID.getIdString();
        if (string == null) {
            PluginClassLoader.$$$reportNull$$$0(13);
        }
        return string;
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "] " + super.toString();
    }

    @NotNull
    @ApiStatus.Internal
    public List<ClassLoader> _getParents() {
        List<ClassLoader> list2 = Collections.unmodifiableList(Arrays.asList(this.myParents));
        if (list2 == null) {
            PluginClassLoader.$$$reportNull$$$0(14);
        }
        return list2;
    }

    static {
        if (PluginClassLoader.registerAsParallelCapable()) {
            PluginClassLoader.markParallelCapable(PluginClassLoader.class);
        }
        loadClassInPluginCL = new ActionWithPluginClassLoader<Class<?>, Void>(){

            @Override
            Class<?> execute(String name, PluginClassLoader classloader, Set<ClassLoader> visited, ActionWithPluginClassLoader<Class<?>, Void> actionWithPluginClassLoader, ActionWithClassloader<Class<?>, Void> actionWithClassloader, Void parameter) {
                return classloader.tryLoadingClass(name, false, visited);
            }

            @Override
            protected Class<?> doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return null;
            }
        };
        loadClassInCl = new ActionWithClassloader<Class<?>, Void>(){

            @Override
            public Class<?> execute(String name, ClassLoader classloader, Void parameter) {
                try {
                    return classloader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        };
        KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = ContainerUtil.set((Object[])new String[]{"kotlin.sequences.Sequence", "kotlin.Lazy", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.jvm.internal.ClassBasedDeclarationContainer", "kotlin.properties.ReadWriteProperty", "kotlin.properties.ReadOnlyProperty"});
        findResourceInPluginCL = new ActionWithPluginClassLoader<URL, Void>(){

            @Override
            protected URL doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return classloader.findOwnResource(name);
            }
        };
        findResourceInCl = new ActionWithClassloader<URL, Void>(){

            @Override
            public URL execute(String name, ClassLoader classloader, Void parameter) {
                return classloader.getResource(name);
            }
        };
        getResourceAsStreamInPluginCL = new ActionWithPluginClassLoader<InputStream, Void>(){

            @Override
            protected InputStream doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return classloader.getOwnResourceAsStream(name);
            }
        };
        getResourceAsStreamInCl = new ActionWithClassloader<InputStream, Void>(){

            @Override
            public InputStream execute(String name, ClassLoader classloader, Void parameter) {
                return classloader.getResourceAsStream(name);
            }
        };
        findResourcesInPluginCL = new ActionWithPluginClassLoader<Void, List<Enumeration<URL>>>(){

            @Override
            protected Void doExecute(String name, PluginClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.findOwnResources(name));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        findResourcesInCl = new ActionWithClassloader<Void, List<Enumeration<URL>>>(){

            @Override
            public Void execute(String name, ClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.getResources(name));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginIdString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "_getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadingClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadClassInsideSelf";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLibDirectories";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeepEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] myEnumerations;
        private int myIndex;

        DeepEnumeration(Enumeration<URL>[] enumerations) {
            this.myEnumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.myEnumerations.length) {
                Enumeration<URL> e = this.myEnumerations[this.myIndex];
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.myEnumerations[this.myIndex].nextElement();
        }
    }

    private static abstract class ActionWithPluginClassLoader<Result, ParameterType> {
        private ActionWithPluginClassLoader() {
        }

        Result execute(String name, PluginClassLoader classloader, Set<ClassLoader> visited, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, ParameterType parameter) {
            Result resource = this.doExecute(name, classloader, parameter);
            if (resource != null) {
                return resource;
            }
            return (Result)classloader.processResourcesInParents(name, actionWithPluginClassLoader, actionWithClassloader, visited, parameter);
        }

        protected abstract Result doExecute(String var1, PluginClassLoader var2, ParameterType var3);
    }

    private static interface ActionWithClassloader<Result, ParameterType> {
        public Result execute(String var1, ClassLoader var2, ParameterType var3);
    }
}

