/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplitButtonAction
extends ActionGroup
implements CustomComponentAction {
    private final ActionGroup myActionGroup;

    public SplitButtonAction(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            SplitButtonAction.$$$reportNull$$$0(0);
        }
        this.myActionGroup = actionGroup;
        this.setPopup(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SplitButtonAction.$$$reportNull$$$0(1);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        JComponent component2;
        if (e == null) {
            SplitButtonAction.$$$reportNull$$$0(2);
        }
        this.myActionGroup.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isVisible() && (component2 = (JComponent)presentation.getClientProperty(CustomComponentAction.COMPONENT_KEY)) instanceof SplitButton) {
            ((SplitButton)component2).update(e);
        }
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = this.myActionGroup.getChildren(e);
        if (anActionArray == null) {
            SplitButtonAction.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    public boolean isDumbAware() {
        return this.myActionGroup.isDumbAware();
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            SplitButtonAction.$$$reportNull$$$0(4);
        }
        if (place == null) {
            SplitButtonAction.$$$reportNull$$$0(5);
        }
        return new SplitButton((AnAction)this, presentation, place, this.myActionGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/SplitButtonAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/SplitButtonAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SplitButton
    extends ActionButton {
        private static final Icon ARROW_DOWN = AllIcons.General.ButtonDropTriangle;
        private final ActionGroup myActionGroup;
        private AnAction selectedAction;
        private boolean actionEnabled;
        private MousePressType mousePressType;
        private Disposable myDisposable;

        private SplitButton(@NotNull AnAction action2, @NotNull Presentation presentation, String place, ActionGroup actionGroup) {
            if (action2 == null) {
                SplitButton.$$$reportNull$$$0(0);
            }
            if (presentation == null) {
                SplitButton.$$$reportNull$$$0(1);
            }
            super(action2, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.actionEnabled = true;
            this.mousePressType = MousePressType.None;
            this.myActionGroup = actionGroup;
            AnAction[] actions = this.myActionGroup.getChildren(null);
            if (actions.length > 0) {
                this.selectedAction = actions[0];
                this.copyPresentation(this.selectedAction.getTemplatePresentation());
            }
        }

        private void copyPresentation(Presentation presentation) {
            this.myPresentation.copyFrom(presentation);
            this.actionEnabled = presentation.isEnabled();
            this.myPresentation.setEnabled(true);
            this.myPresentation.putClientProperty(CustomComponentAction.COMPONENT_KEY, (Object)this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width += ARROW_DOWN.getIconWidth() + JBUIScale.scale((int)7);
            return size;
        }

        private boolean selectedActionEnabled() {
            return this.selectedAction != null && this.actionEnabled;
        }

        @Override
        public void paintComponent(Graphics g) {
            ActionButtonLook look = this.getButtonLook();
            if (this.selectedActionEnabled() || !StartupUiUtil.isUnderDarcula()) {
                int state = this.getPopState();
                if (state == -1) {
                    state = 1;
                }
                look.paintBackground(g, (JComponent)this, state);
            }
            Rectangle baseRect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)baseRect, (Insets)this.getInsets());
            if (this.getPopState() == -1 && this.mousePressType != MousePressType.None && this.selectedActionEnabled() || this.isToggleActionPushed()) {
                int arrowWidth = ARROW_DOWN.getIconWidth() + JBUIScale.scale((int)7);
                Shape clip = g.getClip();
                Area buttonClip = new Area(clip);
                Rectangle execButtonRect = new Rectangle(baseRect.x, baseRect.y, baseRect.width - arrowWidth, baseRect.height);
                if (this.mousePressType == MousePressType.Action || this.isToggleActionPushed()) {
                    buttonClip.intersect(new Area(execButtonRect));
                } else if (this.mousePressType == MousePressType.Popup) {
                    Rectangle arrowButtonRect = new Rectangle(execButtonRect.x + execButtonRect.width, baseRect.y, arrowWidth, baseRect.height);
                    buttonClip.intersect(new Area(arrowButtonRect));
                }
                g.setClip(buttonClip);
                look.paintBackground(g, (JComponent)this, -1);
                g.setClip(clip);
            }
            int x = baseRect.x + baseRect.width - JBUIScale.scale((int)3) - ARROW_DOWN.getIconWidth();
            int y = baseRect.y + (baseRect.height - ARROW_DOWN.getIconHeight()) / 2 + JBUIScale.scale((int)1);
            look.paintIcon(g, this, ARROW_DOWN, x, y);
            x -= JBUIScale.scale((int)4);
            if (this.getPopState() == 1 || this.getPopState() == -1) {
                g.setColor(JBUI.CurrentTheme.ActionButton.hoverSeparatorColor());
                g.fillRect(x, baseRect.y, JBUIScale.scale((int)1), baseRect.height);
            }
            Icon actionIcon = this.getIcon();
            if (!this.selectedActionEnabled()) {
                Icon disabledIcon = this.myPresentation.getDisabledIcon();
                Icon icon2 = actionIcon = disabledIcon != null || actionIcon == null ? disabledIcon : IconLoader.getDisabledIcon((Icon)actionIcon);
                if (actionIcon == null) {
                    actionIcon = this.getFallbackIcon(false);
                }
            }
            x = baseRect.x + (x - actionIcon.getIconWidth()) / 2;
            y = baseRect.y + (baseRect.height - actionIcon.getIconHeight()) / 2;
            look.paintIcon(g, this, actionIcon, x, y);
        }

        private boolean isToggleActionPushed() {
            return this.selectedAction instanceof Toggleable && Toggleable.isSelected((Presentation)this.myPresentation);
        }

        @Override
        protected void onMousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                SplitButton.$$$reportNull$$$0(2);
            }
            Rectangle baseRect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)baseRect, (Insets)this.getInsets());
            int arrowWidth = ARROW_DOWN.getIconWidth() + JBUIScale.scale((int)7);
            Rectangle execButtonRect = new Rectangle(baseRect.x, baseRect.y, baseRect.width - arrowWidth, baseRect.height);
            Rectangle arrowButtonRect = new Rectangle(execButtonRect.x + execButtonRect.width, baseRect.y, arrowWidth, baseRect.height);
            Point p = e.getPoint();
            this.mousePressType = execButtonRect.contains(p) ? MousePressType.Action : (arrowButtonRect.contains(p) ? MousePressType.Popup : MousePressType.None);
        }

        @Override
        protected void actionPerformed(AnActionEvent event) {
            HelpTooltip.hide((Component)this);
            if (this.mousePressType == MousePressType.Popup) {
                this.showPopupMenu(event, this.myActionGroup);
            } else if (this.selectedActionEnabled()) {
                AnActionEvent newEvent = AnActionEvent.createFromInputEvent((InputEvent)event.getInputEvent(), (String)this.myPlace, (Presentation)event.getPresentation(), (DataContext)this.getDataContext());
                ActionUtil.performActionDumbAware((AnAction)this.selectedAction, (AnActionEvent)newEvent);
            }
        }

        @Override
        protected void showPopupMenu(AnActionEvent event, ActionGroup actionGroup) {
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
            ActionPopupMenu popupMenu = am.createActionPopupMenu(event.getPlace(), actionGroup, new MenuItemPresentationFactory(){

                @Override
                protected void processPresentation(Presentation presentation) {
                    if (presentation != null && StringUtil.defaultIfEmpty((String)presentation.getText(), (String)"").equals(myPresentation.getText()) && StringUtil.defaultIfEmpty((String)presentation.getDescription(), (String)"").equals(myPresentation.getDescription())) {
                        presentation.setEnabled(this.selectedActionEnabled());
                    }
                }
            });
            popupMenu.setTargetComponent((JComponent)this);
            JPopupMenu menu = popupMenu.getComponent();
            menu.addPopupMenuListener((PopupMenuListener)this.myPopupState);
            if (event.isFromActionToolbar()) {
                menu.show(this, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width + this.getInsets().left, this.getHeight());
            } else {
                menu.show(this, this.getWidth(), 0);
            }
            HelpTooltip.setMasterPopupOpenCondition((Component)this, () -> !menu.isVisible());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.myDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.myDisposable);
            ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

                public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                    if (action2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (dataContext == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT) == this) {
                        selectedAction = action2;
                        this.update(event);
                        this.repaint();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "action";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataContext";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/actionSystem/SplitButtonAction$SplitButton$2";
                    objectArray[2] = "beforeActionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this.myDisposable != null) {
                Disposer.dispose((Disposable)this.myDisposable);
                this.myDisposable = null;
            }
        }

        private void update(@NotNull AnActionEvent event) {
            if (event == null) {
                SplitButton.$$$reportNull$$$0(3);
            }
            if (this.selectedAction != null) {
                this.selectedAction.update(event);
                this.copyPresentation(event.getPresentation());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/SplitButtonAction$SplitButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onMousePressed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum MousePressType {
            Action,
            Popup,
            None;

        }
    }
}

