/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.softwrap.CompositeSoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapModelImpl
extends InlayModel.SimpleAdapter
implements SoftWrapModelEx,
PrioritizedDocumentListener,
FoldingListener,
PropertyChangeListener,
Dumpable,
Disposable {
    private static final Logger LOG = Logger.getInstance(SoftWrapModelImpl.class);
    private final List<SoftWrapChangeListener> mySoftWrapListeners;
    private final List<Segment> myDeferredFoldRegions;
    private final CachingSoftWrapDataMapper myDataMapper;
    private final SoftWrapsStorage myStorage;
    private SoftWrapPainter myPainter;
    private final SoftWrapApplianceManager myApplianceManager;
    private EditorTextRepresentationHelper myEditorTextRepresentationHelper;
    @NotNull
    private final EditorImpl myEditor;
    private boolean myUseSoftWraps;
    private int myTabWidth;
    private final FontPreferencesImpl myFontPreferences;
    private boolean myUpdateInProgress;
    private boolean myBulkUpdateInProgress;
    private boolean myDirty;
    private boolean myForceAdditionalColumns;
    private boolean myAfterLineEndInlayUpdated;
    private boolean myInlayChangedInBatchMode;

    SoftWrapModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(0);
        }
        this.mySoftWrapListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDeferredFoldRegions = new ArrayList<Segment>();
        this.myTabWidth = -1;
        this.myFontPreferences = new FontPreferencesImpl();
        this.myEditor = editor;
        this.myStorage = new SoftWrapsStorage();
        this.myPainter = new CompositeSoftWrapPainter(editor);
        this.myEditorTextRepresentationHelper = new DefaultEditorTextRepresentationHelper(editor);
        this.myDataMapper = new CachingSoftWrapDataMapper(editor, this.myStorage);
        this.myApplianceManager = new SoftWrapApplianceManager(this.myStorage, editor, this.myPainter, this.myDataMapper);
        this.myApplianceManager.addListener(new SoftWrapAwareDocumentParsingListenerAdapter(){

            @Override
            public void recalculationEnds() {
                for (SoftWrapChangeListener listener2 : SoftWrapModelImpl.this.mySoftWrapListeners) {
                    listener2.recalculationEnds();
                }
            }
        });
        this.myUseSoftWraps = this.areSoftWrapsEnabledInEditor();
        this.myEditor.getColorsScheme().getFontPreferences().copyTo((FontPreferences)this.myFontPreferences);
        editor.addPropertyChangeListener(this, this);
        this.myApplianceManager.addListener(this.myDataMapper);
        this.myEditor.getInlayModel().addListener((InlayModel.Listener)this, this);
    }

    private boolean areSoftWrapsEnabledInEditor() {
        return this.myEditor.getSettings().isUseSoftWraps() && !this.myEditor.isOneLineMode();
    }

    public void reinitSettings() {
        boolean softWrapsUsedBefore = this.myUseSoftWraps;
        this.myUseSoftWraps = this.areSoftWrapsEnabledInEditor();
        int tabWidthBefore = this.myTabWidth;
        this.myTabWidth = EditorUtil.getTabSize(this.myEditor);
        boolean fontsChanged = false;
        if (!this.myFontPreferences.equals(this.myEditor.getColorsScheme().getFontPreferences()) && this.myEditorTextRepresentationHelper instanceof DefaultEditorTextRepresentationHelper) {
            fontsChanged = true;
            this.myEditor.getColorsScheme().getFontPreferences().copyTo((FontPreferences)this.myFontPreferences);
            ((DefaultEditorTextRepresentationHelper)this.myEditorTextRepresentationHelper).clearSymbolWidthCache();
            this.myPainter.reinit();
        }
        if (this.myUseSoftWraps != softWrapsUsedBefore || tabWidthBefore >= 0 && this.myTabWidth != tabWidthBefore || fontsChanged) {
            this.myApplianceManager.reset();
            this.myDeferredFoldRegions.clear();
            this.myStorage.removeAll();
            this.myEditor.myView.reinitSettings();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    @Override
    public boolean isRespectAdditionalColumns() {
        return this.myForceAdditionalColumns;
    }

    @Override
    public void forceAdditionalColumnsUsage() {
        this.myForceAdditionalColumns = true;
    }

    public boolean isSoftWrappingEnabled() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myUseSoftWraps && !this.myEditor.isPurePaintingMode();
    }

    @Nullable
    public SoftWrap getSoftWrap(int offset) {
        if (!this.isSoftWrappingEnabled()) {
            return null;
        }
        return this.myStorage.getSoftWrap(offset);
    }

    @Override
    public int getSoftWrapIndex(int offset) {
        if (!this.isSoftWrappingEnabled()) {
            return -1;
        }
        return this.myStorage.getSoftWrapIndex(offset);
    }

    @NotNull
    public List<? extends SoftWrap> getSoftWrapsForRange(int start2, int end) {
        if (!this.isSoftWrappingEnabled() || end < start2) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                SoftWrapModelImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        int startIndex = this.myStorage.getSoftWrapIndex(start2);
        if (startIndex < 0 && ((startIndex = -startIndex - 1) >= softWraps.size() || ((SoftWrap)softWraps.get(startIndex)).getStart() > end)) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                SoftWrapModelImpl.$$$reportNull$$$0(2);
            }
            return list3;
        }
        int endIndex = this.myStorage.getSoftWrapIndex(end);
        if (endIndex >= 0) {
            List<SoftWrapImpl> list4 = softWraps.subList(startIndex, endIndex + 1);
            if (list4 == null) {
                SoftWrapModelImpl.$$$reportNull$$$0(3);
            }
            return list4;
        }
        endIndex = -endIndex - 1;
        List<SoftWrapImpl> list5 = softWraps.subList(startIndex, endIndex);
        if (list5 == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(4);
        }
        return list5;
    }

    @NotNull
    public List<? extends SoftWrap> getSoftWrapsForLine(int documentLine) {
        if (!this.isSoftWrappingEnabled() || documentLine < 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                SoftWrapModelImpl.$$$reportNull$$$0(5);
            }
            return list2;
        }
        DocumentEx document = this.myEditor.getDocument();
        if (documentLine >= document.getLineCount()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                SoftWrapModelImpl.$$$reportNull$$$0(6);
            }
            return list3;
        }
        int start2 = document.getLineStartOffset(documentLine);
        int end = document.getLineEndOffset(documentLine);
        List<? extends SoftWrap> list4 = this.getSoftWrapsForRange(start2, end + 1);
        if (list4 == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(7);
        }
        return list4;
    }

    int getSoftWrapsIntroducedLinesNumber() {
        this.prepareToMapping();
        return this.myStorage.getSoftWraps().size();
    }

    @Override
    public List<? extends SoftWrap> getRegisteredSoftWraps() {
        if (!this.isSoftWrappingEnabled()) {
            return Collections.emptyList();
        }
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        if (!softWraps.isEmpty() && softWraps.get(softWraps.size() - 1).getStart() >= this.myEditor.getDocument().getTextLength()) {
            LOG.error("Unexpected soft wrap location", new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
        }
        return softWraps;
    }

    public boolean isVisible(SoftWrap softWrap) {
        int start2;
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (foldingModel.isOffsetCollapsed(start2 = softWrap.getStart())) {
            return false;
        }
        return start2 <= 0 || !foldingModel.isOffsetCollapsed(start2 - 1);
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(8);
        }
        if (drawingType == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(9);
        }
        if (!this.isSoftWrappingEnabled()) {
            return 0;
        }
        if (!this.myEditor.getSettings().isAllSoftWrapsShown()) {
            int visualLine = y / lineHeight;
            LogicalPosition position = this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, 0));
            if (position.line != this.myEditor.getCaretModel().getLogicalPosition().line) {
                return this.myPainter.getDrawingHorizontalOffset(g, drawingType, x, y, lineHeight);
            }
        }
        return this.doPaint(g, drawingType, x, y, lineHeight);
    }

    public int doPaint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(10);
        }
        if (drawingType == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(11);
        }
        return this.myPainter.paint(g, drawingType, x, y, lineHeight);
    }

    @Override
    public int getMinDrawingWidthInPixels(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(12);
        }
        return this.myPainter.getMinDrawingWidth(drawingType);
    }

    public void prepareToMapping() {
        if (this.myUpdateInProgress || this.myBulkUpdateInProgress || !this.isSoftWrappingEnabled()) {
            return;
        }
        if (this.myDirty) {
            this.myStorage.removeAll();
            this.myApplianceManager.reset();
            this.myDeferredFoldRegions.clear();
            this.myDirty = false;
        }
        this.myApplianceManager.recalculateIfNecessary();
    }

    public boolean isInsideSoftWrap(@NotNull VisualPosition visual) {
        if (visual == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(13);
        }
        return this.isInsideSoftWrap(visual, false);
    }

    public boolean isInsideOrBeforeSoftWrap(@NotNull VisualPosition visual) {
        if (visual == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(14);
        }
        return this.isInsideSoftWrap(visual, true);
    }

    private boolean isInsideSoftWrap(@NotNull VisualPosition visual, boolean countBeforeSoftWrap) {
        if (visual == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(15);
        }
        if (!this.isSoftWrappingEnabled()) {
            return false;
        }
        SoftWrapModelImpl model = this.myEditor.getSoftWrapModel();
        if (!model.isSoftWrappingEnabled()) {
            return false;
        }
        LogicalPosition logical = this.myEditor.visualToLogicalPosition(visual);
        int offset = this.myEditor.logicalPositionToOffset(logical);
        if (offset <= 0) {
            return false;
        }
        SoftWrap softWrap = model.getSoftWrap(offset);
        if (softWrap == null) {
            return false;
        }
        VisualPosition visualAfterSoftWrap = this.myEditor.offsetToVisualPosition(offset);
        if (visualAfterSoftWrap.line == visual.line && visualAfterSoftWrap.column <= visual.column) {
            return false;
        }
        VisualPosition beforeSoftWrap = this.myEditor.offsetToVisualPosition(offset, true, true);
        return visual.line > beforeSoftWrap.line || visual.column > beforeSoftWrap.column || visual.column == beforeSoftWrap.column && countBeforeSoftWrap;
    }

    public void beforeDocumentChangeAtCaret() {
        CaretModelImpl caretModel = this.myEditor.getCaretModel();
        VisualPosition visualCaretPosition = caretModel.getVisualPosition();
        if (!this.isInsideSoftWrap(visualCaretPosition)) {
            return;
        }
        SoftWrap softWrap = this.myStorage.getSoftWrap(caretModel.getOffset());
        if (softWrap == null) {
            return;
        }
        this.myEditor.getDocument().replaceString(softWrap.getStart(), softWrap.getEnd(), softWrap.getText());
        caretModel.moveToVisualPosition(visualCaretPosition);
    }

    @Override
    public boolean addSoftWrapChangeListener(@NotNull SoftWrapChangeListener listener2) {
        if (listener2 == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(16);
        }
        this.mySoftWrapListeners.add(listener2);
        return this.myStorage.addSoftWrapChangeListener(listener2);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(17);
        }
        this.myAfterLineEndInlayUpdated = false;
        if (this.myBulkUpdateInProgress) {
            return;
        }
        this.myUpdateInProgress = true;
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        this.myApplianceManager.beforeDocumentChange(event);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(18);
        }
        if (this.myBulkUpdateInProgress) {
            return;
        }
        this.myUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        this.myApplianceManager.documentChanged(event, this.myAfterLineEndInlayUpdated);
        if (DocumentEventUtil.isMoveInsertion(event)) {
            int dstOffset = event.getOffset();
            int srcOffset = event.getMoveOffset();
            int textLength = event.getDocument().getTextLength();
            this.myApplianceManager.recalculate(Arrays.asList(new TextRange(srcOffset, Math.min(textLength, srcOffset + event.getNewLength() + 1)), new TextRange(dstOffset, Math.min(textLength, dstOffset + event.getNewLength() + 1))));
        }
    }

    void onBulkDocumentUpdateStarted() {
        this.myBulkUpdateInProgress = true;
    }

    void onBulkDocumentUpdateFinished() {
        this.myBulkUpdateInProgress = false;
        this.recalculate();
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(19);
        }
        this.myUpdateInProgress = true;
        if (!this.isSoftWrappingEnabled() || !region.isValid()) {
            this.myDirty = true;
            return;
        }
        this.myDeferredFoldRegions.add((Segment)TextRange.create((Segment)region));
    }

    @Override
    public void onFoldProcessingEnd() {
        this.myUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        try {
            if (!this.myDirty) {
                this.myApplianceManager.recalculate(this.myDeferredFoldRegions);
            }
        }
        finally {
            this.myDeferredFoldRegions.clear();
        }
    }

    public void onUpdated(@NotNull Inlay inlay, int changeFlags) {
        if (inlay == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(20);
        }
        if (this.myEditor.getDocument().isInBulkUpdate() || inlay.getPlacement() != Inlay.Placement.INLINE && inlay.getPlacement() != Inlay.Placement.AFTER_LINE_END || (changeFlags & 1) == 0) {
            return;
        }
        if (this.myEditor.getInlayModel().isInBatchMode()) {
            this.myInlayChangedInBatchMode = true;
            return;
        }
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        if (!this.myDirty) {
            if (this.myEditor.getDocument().isInEventsHandling()) {
                if (inlay.getPlacement() == Inlay.Placement.AFTER_LINE_END) {
                    this.myAfterLineEndInlayUpdated = true;
                }
                return;
            }
            int offset = inlay.getOffset();
            if (inlay.getPlacement() == Inlay.Placement.AFTER_LINE_END) {
                offset = DocumentUtil.getLineEndOffset(offset, this.myEditor.getDocument());
            }
            this.myApplianceManager.recalculate(Collections.singletonList(new TextRange(offset, offset)));
        }
    }

    public void onBatchModeFinish(@NotNull Editor editor) {
        if (editor == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(21);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (this.myInlayChangedInBatchMode) {
            this.myInlayChangedInBatchMode = false;
            this.recalculate();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("fontSize".equals(evt.getPropertyName())) {
            this.myDirty = true;
        }
    }

    public void dispose() {
        this.release();
    }

    public void release() {
        this.myStorage.removeAll();
        this.myDeferredFoldRegions.clear();
    }

    void recalculate() {
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        this.myApplianceManager.reset();
        this.myStorage.removeAll();
        this.myDeferredFoldRegions.clear();
        this.myApplianceManager.recalculateIfNecessary();
    }

    public SoftWrapApplianceManager getApplianceManager() {
        return this.myApplianceManager;
    }

    public void setSoftWrapPainter(SoftWrapPainter painter) {
        this.myPainter = painter;
        this.myApplianceManager.setSoftWrapPainter(painter);
    }

    @Override
    public EditorTextRepresentationHelper getEditorTextRepresentationHelper() {
        return this.myEditorTextRepresentationHelper;
    }

    public void setEditorTextRepresentationHelper(EditorTextRepresentationHelper editorTextRepresentationHelper) {
        this.myEditorTextRepresentationHelper = editorTextRepresentationHelper;
        this.myApplianceManager.reset();
    }

    @NotNull
    public String dumpState() {
        String string = String.format("\nuse soft wraps: %b, tab width: %d, additional columns: %b, update in progress: %b, bulk update in progress: %b, dirty: %b, deferred regions: %s\nappliance manager state: %s\nsoft wraps mapping info: %s\nsoft wraps: %s", this.myUseSoftWraps, this.myTabWidth, this.myForceAdditionalColumns, this.myUpdateInProgress, this.myBulkUpdateInProgress, this.myDirty, this.myDeferredFoldRegions.toString(), this.myApplianceManager.dumpState(), this.myDataMapper.dumpState(), this.myStorage.dumpState());
        if (string == null) {
            SoftWrapModelImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    public boolean isDirty() {
        return this.myUseSoftWraps && this.myDirty;
    }

    void validateState() {
        DocumentEx document = this.myEditor.getDocument();
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        List<? extends SoftWrap> softWraps = this.getRegisteredSoftWraps();
        int lastSoftWrapOffset = -1;
        for (SoftWrap softWrap : softWraps) {
            int softWrapOffset = softWrap.getStart();
            LOG.assertTrue(softWrapOffset > lastSoftWrapOffset, (Object)"Soft wraps are not ordered");
            LOG.assertTrue(softWrapOffset < document.getTextLength(), (Object)"Soft wrap is after document's end");
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(softWrapOffset);
            LOG.assertTrue(foldRegion == null || foldRegion.getStartOffset() == softWrapOffset, (Object)"Soft wrap is inside fold region");
            LOG.assertTrue(softWrapOffset != DocumentUtil.getLineEndOffset(softWrapOffset, document) || foldRegion != null, (Object)"Soft wrap before line break");
            LOG.assertTrue(softWrapOffset != DocumentUtil.getLineStartOffset(softWrapOffset, document) || foldingModel.isOffsetCollapsed(softWrapOffset - 1), (Object)"Soft wrap after line break");
            LOG.assertTrue(!DocumentUtil.isInsideCharacterPair(document, softWrapOffset), (Object)"Soft wrap inside a surrogate pair or inside a line break");
            lastSoftWrapOffset = softWrapOffset;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/SoftWrapModelImpl";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visual";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/SoftWrapModelImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapsForRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapsForLine";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 22: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doPaint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMinDrawingWidthInPixels";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSoftWrap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInsideOrBeforeSoftWrap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSoftWrapChangeListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onFoldRegionStateChange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onUpdated";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onBatchModeFinish";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

