/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePreviewPanelProvider
extends PreviewPanelProvider<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> {
    public static final PreviewProviderId<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> ID = PreviewProviderId.create("Files");
    private final Project myProject;
    private final EditorWindow myWindow;
    private final EditorsSplitters myEditorsSplitters;

    public FilePreviewPanelProvider(@NotNull Project project) {
        if (project == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(0);
        }
        super(ID);
        this.myProject = project;
        this.myEditorsSplitters = new MyEditorsSplitters((FileEditorManagerImpl)FileEditorManagerEx.getInstanceEx(project), false, this);
        this.myEditorsSplitters.createCurrentWindow();
        this.myWindow = this.myEditorsSplitters.getCurrentWindow();
        this.myWindow.setTabsPlacement(0);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        EditorsSplitters editorsSplitters = this.myEditorsSplitters;
        if (editorsSplitters == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(1);
        }
        return editorsSplitters;
    }

    @Override
    protected Pair<FileEditor[], FileEditorProvider[]> initComponent(VirtualFile file2, boolean requestFocus) {
        Pair<FileEditor[], FileEditorProvider[]> result2 = FileEditorManagerEx.getInstanceEx(this.myProject).openFileWithProviders(file2, requestFocus, this.myWindow);
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(() -> this.myWindow.requestFocus(true));
        return result2;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(2);
        }
        String string = VfsPresentationUtil.getPresentableNameForUI(this.myProject, file2);
        if (string == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(4);
        }
        return file2.getFileType().getIcon();
    }

    @Override
    public float getMenuOrder() {
        return 0.0f;
    }

    @Override
    public void showInStandardPlace(@NotNull VirtualFile file2) {
        FileEditorManagerImpl fileEditorManager;
        EditorWindow window;
        if (file2 == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(5);
        }
        if ((window = (fileEditorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.myProject)).getCurrentWindow()) == null) {
            fileEditorManager.getMainSplitters().createCurrentWindow();
            window = fileEditorManager.getCurrentWindow();
        }
        fileEditorManager.openFileWithProviders(file2, true, window);
    }

    @Override
    public boolean isModified(VirtualFile content2, boolean beforeReuse) {
        for (EditorWithProviderComposite composite : this.myEditorsSplitters.getEditorComposites()) {
            if (!composite.isModified() || !Comparing.equal((Object)composite.getFile(), (Object)content2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void release(@NotNull VirtualFile content2) {
        if (content2 == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(6);
        }
        this.myEditorsSplitters.closeFile(content2, false);
    }

    @Override
    public boolean contentsAreEqual(@NotNull VirtualFile content1, @NotNull VirtualFile content2) {
        if (content1 == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(7);
        }
        if (content2 == null) {
            FilePreviewPanelProvider.$$$reportNull$$$0(8);
        }
        return Comparing.equal((Object)content1, (Object)content2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showInStandardPlace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contentsAreEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyEditorsSplitters
    extends EditorsSplitters {
        private MyEditorsSplitters(FileEditorManagerImpl manager, @NotNull boolean createOwnDockableContainer, Disposable parentDisposable) {
            if (manager == null) {
                MyEditorsSplitters.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                MyEditorsSplitters.$$$reportNull$$$0(1);
            }
            super(manager, createOwnDockableContainer, parentDisposable);
        }

        @Override
        protected void afterFileClosed(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyEditorsSplitters.$$$reportNull$$$0(2);
            }
            PreviewManager.SERVICE.close(FilePreviewPanelProvider.this.myProject, FilePreviewPanelProvider.this.getId(), file2);
        }

        @Override
        @NotNull
        protected EditorWindow createEditorWindow() {
            return new EditorWindow(this, this.parentDisposable){

                @Override
                protected void onBeforeSetEditor(VirtualFile file2) {
                    for (EditorWithProviderComposite composite : MyEditorsSplitters.this.getEditorComposites()) {
                        if (!composite.isModified()) continue;
                        PreviewManager.SERVICE.moveToStandardPlaceImpl(FilePreviewPanelProvider.this.myProject, FilePreviewPanelProvider.this.getId(), composite.getFile());
                        return;
                    }
                }
            };
        }

        @Override
        public void setTabsPlacement(int tabPlacement) {
            super.setTabsPlacement(0);
        }

        @Override
        public boolean isPreview() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider$MyEditorsSplitters";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterFileClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

