/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

final class Banner
extends SimpleBanner {
    private final JLabel myProjectIcon = new JLabel();
    private final Breadcrumbs myBreadcrumbs = new Breadcrumbs(){

        protected int getFontStyle(Crumb crumb) {
            return 1;
        }
    };

    Banner(Action action2) {
        this.myProjectIcon.setMinimumSize(new Dimension(0, 0));
        this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurable);
        this.myProjectIcon.setForeground(UIUtil.getContextHelpForeground());
        this.myProjectIcon.setVisible(false);
        this.myLeftPanel.add((Component)this.myBreadcrumbs, 0);
        this.add("Center", this.myProjectIcon);
        this.add("East", RelativeFont.BOLD.install((Component)new SwingActionLink(action2)));
    }

    void setText(@NotNull Collection<String> names2) {
        if (names2 == null) {
            Banner.$$$reportNull$$$0(0);
        }
        ArrayList<Crumb.Impl> crumbs = new ArrayList<Crumb.Impl>();
        if (!names2.isEmpty()) {
            List<Action> actions = CopySettingsPathAction.createSwingActions(() -> names2);
            for (String name : names2) {
                crumbs.add(new Crumb.Impl(null, name, null, actions));
            }
        }
        this.myBreadcrumbs.setCrumbs(crumbs);
    }

    void setProject(Project project) {
        if (project == null) {
            this.myProjectIcon.setVisible(false);
        } else {
            this.myProjectIcon.setVisible(true);
            this.myProjectIcon.setText(project.isDefault() ? IdeUICustomization.getInstance().projectMessage("configurable.default.project.tooltip", new Object[0]) : IdeUICustomization.getInstance().projectMessage("configurable.current.project.tooltip", new Object[0]));
        }
    }

    @Override
    void setCenterComponent(Component component2) {
        boolean addProjectIcon = this.myCenterComponent != null && component2 == null;
        super.setCenterComponent(component2);
        if (addProjectIcon) {
            this.getLayout().addLayoutComponent("Center", this.myProjectIcon);
        }
    }

    @Override
    void setLeftComponent(Component component2) {
        super.setLeftComponent(component2);
        this.myBreadcrumbs.setVisible(component2 == null);
    }

    @Override
    void updateProgressBorder() {
    }

    @Override
    Component getBaselineTemplate() {
        return this.myBreadcrumbs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/openapi/options/newEditor/Banner", "setText"));
    }
}

