/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProgressDialog
implements Disposable {
    private final ProgressWindow myProgressWindow;
    private long myLastTimeDrawn;
    private final boolean myShouldShowBackground;
    private final SingleAlarm myUpdateAlarm;
    private boolean myWasShown;
    final Runnable myRepaintRunnable;
    JPanel myPanel;
    private JLabel myTextLabel;
    private JBLabel myText2Label;
    private JButton myCancelButton;
    private JButton myBackgroundButton;
    private JProgressBar myProgressBar;
    private boolean myRepaintedFlag;
    private TitlePanel myTitlePanel;
    private JPanel myInnerPanel;
    DialogWrapper myPopup;
    private final Window myParentWindow;
    private final SingleAlarm myDisableCancelAlarm;
    private final SingleAlarm myEnableCancelAlarm;
    static final int UPDATE_INTERVAL = 50;

    ProgressDialog(@NotNull ProgressWindow progressWindow, boolean shouldShowBackground, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText, @Nullable Window parentWindow) {
        if (progressWindow == null) {
            ProgressDialog.$$$reportNull$$$0(0);
        }
        this.myLastTimeDrawn = -1L;
        Runnable runnable2 = () -> this.update();
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new SingleAlarm(runnable2, 500, this);
        this.myRepaintRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String text2 = ProgressDialog.this.myProgressWindow.getText();
                double fraction = ProgressDialog.this.myProgressWindow.getFraction();
                String text22 = ProgressDialog.this.myProgressWindow.getText2();
                if (ProgressDialog.this.myProgressBar.isShowing()) {
                    ProgressDialog.this.myProgressBar.setIndeterminate(ProgressDialog.this.myProgressWindow.isIndeterminate());
                    ProgressDialog.this.myProgressBar.setValue((int)(fraction * 100.0));
                }
                ProgressDialog.this.myTextLabel.setText(ProgressDialog.fitTextToLabel(text2, ProgressDialog.this.myTextLabel));
                ProgressDialog.this.myText2Label.setText(ProgressDialog.fitTextToLabel(text22, (JLabel)ProgressDialog.this.myText2Label));
                ProgressDialog.this.myTitlePanel.setText(ProgressDialog.this.myProgressWindow.getTitle() != null && !ProgressDialog.this.myProgressWindow.getTitle().isEmpty() ? ProgressDialog.this.myProgressWindow.getTitle() : " ");
                ProgressDialog.this.myLastTimeDrawn = System.currentTimeMillis();
                ProgressDialog progressDialog = ProgressDialog.this;
                synchronized (progressDialog) {
                    ProgressDialog.this.myRepaintedFlag = true;
                }
            }
        };
        this.myRepaintedFlag = true;
        this.myDisableCancelAlarm = new SingleAlarm(this::setCancelButtonDisabledInEDT, 500, ModalityState.any(), (Disposable)this);
        this.myEnableCancelAlarm = new SingleAlarm(this::setCancelButtonEnabledInEDT, 500, ModalityState.any(), (Disposable)this);
        this.myProgressWindow = progressWindow;
        this.myParentWindow = parentWindow;
        this.myShouldShowBackground = shouldShowBackground;
        this.initDialog(cancelText);
    }

    @NotNull
    private static String fitTextToLabel(@Nullable String fullText, @NotNull JLabel label2) {
        if (label2 == null) {
            ProgressDialog.$$$reportNull$$$0(1);
        }
        if (fullText == null || fullText.isEmpty()) {
            return " ";
        }
        fullText = StringUtil.last((CharSequence)fullText, (int)500, (boolean)true).toString();
        while (label2.getFontMetrics(label2.getFont()).stringWidth(fullText) > label2.getWidth()) {
            int sep = fullText.indexOf(File.separatorChar, 4);
            if (sep < 0) {
                String string = fullText;
                if (string == null) {
                    ProgressDialog.$$$reportNull$$$0(2);
                }
                return string;
            }
            fullText = "..." + fullText.substring(sep);
        }
        String string = fullText;
        if (string == null) {
            ProgressDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void initDialog(@Nullable String cancelText) {
        if (SystemInfo.isMac) {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myText2Label);
        }
        this.myText2Label.setForeground(UIUtil.getContextHelpForeground());
        this.myInnerPanel.setPreferredSize(new Dimension(SystemInfo.isMac ? 350 : JBUIScale.scale((int)450), -1));
        this.myCancelButton.addActionListener(__ -> this.doCancelAction());
        this.myCancelButton.registerKeyboardAction(__ -> {
            if (this.myCancelButton.isEnabled()) {
                this.doCancelAction();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        if (cancelText != null) {
            this.myProgressWindow.setCancelButtonText(cancelText);
        }
        this.myProgressBar.setIndeterminate(this.myProgressWindow.isIndeterminate());
        this.myProgressBar.setMaximum(100);
        this.createCenterPanel();
        this.myTitlePanel.setActive(true);
        WindowMoveListener moveListener = new WindowMoveListener((Component)this.myTitlePanel){

            @Override
            protected Component getView(Component component2) {
                return SwingUtilities.getAncestorOfClass(DialogWrapperDialog.class, component2);
            }
        };
        this.myTitlePanel.addMouseListener((MouseListener)moveListener);
        this.myTitlePanel.addMouseMotionListener((MouseMotionListener)moveListener);
    }

    public void dispose() {
        UIUtil.disposeProgress((JProgressBar)this.myProgressBar);
        UIUtil.dispose((Component)this.myTitlePanel);
        UIUtil.dispose((Component)this.myBackgroundButton);
        UIUtil.dispose((Component)this.myCancelButton);
    }

    @NotNull
    JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ProgressDialog.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    void changeCancelButtonText(@NotNull String text2) {
        if (text2 == null) {
            ProgressDialog.$$$reportNull$$$0(5);
        }
        this.myCancelButton.setText(text2);
    }

    private void doCancelAction() {
        if (this.myProgressWindow.myShouldShowCancel) {
            this.myProgressWindow.cancel();
        }
    }

    void cancel() {
        this.enableCancelButtonIfNeeded(false);
    }

    private void setCancelButtonEnabledInEDT() {
        this.myCancelButton.setEnabled(true);
    }

    private void setCancelButtonDisabledInEDT() {
        this.myCancelButton.setEnabled(false);
    }

    void enableCancelButtonIfNeeded(boolean enable) {
        if (!this.myProgressWindow.myShouldShowCancel || this.myDisableCancelAlarm.isDisposed()) {
            return;
        }
        (enable ? this.myEnableCancelAlarm : this.myDisableCancelAlarm).request();
    }

    private void createCenterPanel() {
        if (this.myProgressWindow.myCancelText != null) {
            this.myCancelButton.setText(this.myProgressWindow.myCancelText);
        }
        this.myCancelButton.setVisible(this.myProgressWindow.myShouldShowCancel);
        this.myBackgroundButton.setVisible(this.myShouldShowBackground);
        this.myBackgroundButton.addActionListener(__ -> {
            if (this.myShouldShowBackground) {
                this.myProgressWindow.background();
            }
        });
    }

    synchronized void update() {
        if (this.myRepaintedFlag) {
            if (System.currentTimeMillis() > this.myLastTimeDrawn + 50L) {
                this.myRepaintedFlag = false;
                EdtExecutorService.getInstance().execute(this.myRepaintRunnable);
            } else if (!this.myUpdateAlarm.isDisposed() && this.myUpdateAlarm.isEmpty()) {
                EdtExecutorService.getInstance().execute(() -> {
                    if (!this.myUpdateAlarm.isDisposed()) {
                        this.myUpdateAlarm.request(this.myProgressWindow.getModalityState());
                    }
                });
            }
        }
    }

    synchronized void background() {
        if (this.myShouldShowBackground) {
            this.myBackgroundButton.setEnabled(false);
        }
        this.hide();
    }

    void hide() {
        ApplicationManager.getApplication().invokeLater(this::hideImmediately, ModalityState.any());
    }

    void hideImmediately() {
        if (this.myPopup != null) {
            this.myPopup.close(1);
            this.myPopup = null;
        }
    }

    void show() {
        if (this.myWasShown) {
            return;
        }
        this.myWasShown = true;
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myParentWindow == null) {
            return;
        }
        if (this.myPopup != null) {
            this.myPopup.close(1);
        }
        this.myPopup = this.myParentWindow.isShowing() ? new MyDialogWrapper(this.myParentWindow, this.myProgressWindow.myShouldShowCancel) : new MyDialogWrapper(this.myProgressWindow.myProject, this.myProgressWindow.myShouldShowCancel);
        this.myPopup.setUndecorated(true);
        if (this.myPopup.getPeer() instanceof DialogWrapperPeerImpl) {
            ((DialogWrapperPeerImpl)this.myPopup.getPeer()).setAutoRequestFocus(false);
            if (this.isWriteActionProgress()) {
                this.myPopup.setModal(false);
            }
        }
        this.myPopup.pack();
        SwingUtilities.invokeLater(() -> {
            if (this.myPopup != null) {
                this.myProgressWindow.getFocusManager().requestFocusInProject((Component)this.myCancelButton, this.myProgressWindow.myProject).doWhenDone(this.myRepaintRunnable);
            }
        });
        Disposer.register((Disposable)this.myPopup.getDisposable(), () -> this.myProgressWindow.exitModality());
        this.myPopup.show();
    }

    private boolean isWriteActionProgress() {
        return this.myProgressWindow instanceof PotemkinProgress;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitlePanel titlePanel;
        JButton jButton;
        JButton jButton2;
        JProgressBar jProgressBar;
        JBLabel jBLabel;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(6, 10, 10, 10), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInnerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 2, null, null, null));
        this.myTextLabel = jLabel = new JLabel();
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, new Dimension(0, -1), null, null));
        this.myText2Label = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 9, 1, 7, 0, new Dimension(0, -1), null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.putClientProperty("html.disable", Boolean.FALSE);
        jPanel.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(" ");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(" ");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 2, null, null, null));
        this.myCancelButton = jButton2 = new JButton();
        ((Component)jButton2).setEnabled(true);
        jButton2.setFocusPainted(true);
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/CommonBundle", ProgressDialog.class).getString("button.cancel"));
        jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundButton = jButton = new JButton();
        jButton.setFocusPainted(true);
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/CommonBundle", ProgressDialog.class).getString("button.background"));
        jPanel4.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTitlePanel = titlePanel = new TitlePanel();
        jPanel2.add((Component)titlePanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/ProgressDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/ProgressDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fitTextToLabel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fitTextToLabel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeCancelButtonText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private final boolean myIsCancellable;

        MyDialogWrapper(Project project, boolean cancellable) {
            super(project, false);
            this.init();
            this.myIsCancellable = cancellable;
        }

        MyDialogWrapper(Component parent, boolean cancellable) {
            if (parent == null) {
                MyDialogWrapper.$$$reportNull$$$0(0);
            }
            super(parent, false);
            this.init();
            this.myIsCancellable = cancellable;
        }

        public void doCancelAction() {
            if (this.myIsCancellable) {
                super.doCancelAction();
            }
        }

        @NotNull
        protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
            if (parent == null) {
                MyDialogWrapper.$$$reportNull$$$0(1);
            }
            if (this.useLightPopup()) {
                try {
                    return new GlassPaneDialogWrapperPeer(this, parent);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    DialogWrapperPeer dialogWrapperPeer = super.createPeer(parent, canBeParent);
                    if (dialogWrapperPeer == null) {
                        MyDialogWrapper.$$$reportNull$$$0(2);
                    }
                    return dialogWrapperPeer;
                }
            }
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(parent, canBeParent);
            if (dialogWrapperPeer == null) {
                MyDialogWrapper.$$$reportNull$$$0(3);
            }
            return dialogWrapperPeer;
        }

        @NotNull
        protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
            DialogWrapperPeer dialogWrapperPeer = this.createPeer(null, canBeParent, applicationModalIfPossible);
            if (dialogWrapperPeer == null) {
                MyDialogWrapper.$$$reportNull$$$0(4);
            }
            return dialogWrapperPeer;
        }

        @NotNull
        protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
            if (this.useLightPopup()) {
                try {
                    return new GlassPaneDialogWrapperPeer(this);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    DialogWrapperPeer dialogWrapperPeer = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
                    if (dialogWrapperPeer == null) {
                        MyDialogWrapper.$$$reportNull$$$0(5);
                    }
                    return dialogWrapperPeer;
                }
            }
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
            if (dialogWrapperPeer == null) {
                MyDialogWrapper.$$$reportNull$$$0(6);
            }
            return dialogWrapperPeer;
        }

        private boolean useLightPopup() {
            return System.getProperty("vintage.progress") == null && !ProgressDialog.this.isWriteActionProgress();
        }

        @NotNull
        protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent) {
            if (System.getProperty("vintage.progress") == null) {
                try {
                    return new GlassPaneDialogWrapperPeer(project, this);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    DialogWrapperPeer dialogWrapperPeer = super.createPeer(project, canBeParent);
                    if (dialogWrapperPeer == null) {
                        MyDialogWrapper.$$$reportNull$$$0(7);
                    }
                    return dialogWrapperPeer;
                }
            }
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(project, canBeParent);
            if (dialogWrapperPeer == null) {
                MyDialogWrapper.$$$reportNull$$$0(8);
            }
            return dialogWrapperPeer;
        }

        protected void init() {
            super.init();
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            ProgressDialog.this.myPanel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        }

        protected boolean isProgressDialog() {
            return true;
        }

        protected JComponent createCenterPanel() {
            return ProgressDialog.this.myPanel;
        }

        @Nullable
        protected JComponent createSouthPanel() {
            return null;
        }

        @Nullable
        protected Border createContentPaneBorder() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPeer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createPeer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

