/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

class PoweredProgressIndicator
extends DelegatingProgressIndicator {
    private static final String DISABLED_VALUE = "-";
    private final double myPower;

    static ProgressIndicator apply(@NotNull ProgressIndicator indicator) {
        Double power;
        if (indicator == null) {
            PoweredProgressIndicator.$$$reportNull$$$0(0);
        }
        return (power = PoweredProgressIndicator.getPower()) == null ? indicator : new PoweredProgressIndicator(indicator, power);
    }

    private PoweredProgressIndicator(@NotNull ProgressIndicator indicator, double power) {
        if (indicator == null) {
            PoweredProgressIndicator.$$$reportNull$$$0(1);
        }
        super(indicator);
        this.myPower = power;
    }

    public void setFraction(double fraction) {
        double poweredFraction = Math.pow(fraction, this.myPower);
        super.setFraction(poweredFraction);
    }

    private static Double getPower() {
        String rawValue = Registry.stringValue((String)"indexing.progress.indicator.power");
        if (DISABLED_VALUE.equals(rawValue)) {
            return null;
        }
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "indicator";
        objectArray2[1] = "com/intellij/openapi/project/PoweredProgressIndicator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

